/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.owasp.security.logging.util.ByteIntervalProperty;
import org.owasp.security.logging.util.DefaultIntervalProperty;
import org.owasp.security.logging.util.IntervalLoggerModel;
import org.owasp.security.logging.util.IntervalProperty;

public class DefaultIntervalLoggerModel
implements IntervalLoggerModel {
    private static ThreadGroup rootThreadGroup = null;
    private ArrayList<IntervalProperty> list = new ArrayList();

    public DefaultIntervalLoggerModel() {
        this.addProperty(new ByteIntervalProperty("MemoryTotal"){

            @Override
            public void refresh() {
                this.value = this.addUnits(Long.toString(Runtime.getRuntime().totalMemory()));
            }
        });
        this.addProperty(new ByteIntervalProperty("MemoryFree"){

            @Override
            public void refresh() {
                this.value = this.addUnits(Long.toString(Runtime.getRuntime().freeMemory()));
            }
        });
        this.addProperty(new ByteIntervalProperty("MemoryMax"){

            @Override
            public void refresh() {
                this.value = this.addUnits(Long.toString(Runtime.getRuntime().maxMemory()));
            }
        });
        this.addProperty(new DefaultIntervalProperty("ThreadNew"){

            @Override
            public void refresh() {
                this.value = Long.toString(DefaultIntervalLoggerModel.this.getThreadState(Thread.State.NEW));
            }
        });
        this.addProperty(new DefaultIntervalProperty("ThreadRunnable"){

            @Override
            public void refresh() {
                this.value = Long.toString(DefaultIntervalLoggerModel.this.getThreadState(Thread.State.RUNNABLE));
            }
        });
        this.addProperty(new DefaultIntervalProperty("ThreadBlocked"){

            @Override
            public void refresh() {
                this.value = Long.toString(DefaultIntervalLoggerModel.this.getThreadState(Thread.State.BLOCKED));
            }
        });
        this.addProperty(new DefaultIntervalProperty("ThreadWaiting"){

            @Override
            public void refresh() {
                this.value = Long.toString(DefaultIntervalLoggerModel.this.getThreadState(Thread.State.WAITING));
            }
        });
        this.addProperty(new DefaultIntervalProperty("ThreadTerminated"){

            @Override
            public String getValue() {
                return Long.toString(DefaultIntervalLoggerModel.this.getThreadState(Thread.State.TERMINATED));
            }
        });
    }

    @Override
    public synchronized void addProperty(IntervalProperty action) {
        this.list.add(action);
    }

    @Override
    public synchronized void removeProperty(IntervalProperty action) {
        this.list.remove(action);
    }

    @Override
    public synchronized IntervalProperty[] getProperties() {
        return this.list.toArray(new IntervalProperty[0]);
    }

    @Override
    public synchronized void refresh() {
        IntervalProperty[] properties;
        for (IntervalProperty p : properties = this.getProperties()) {
            p.refresh();
        }
    }

    private int getThreadState(Thread.State state) {
        Thread[] threads = this.getAllThreads();
        int ct = 0;
        for (Thread thread : threads) {
            if (!state.equals((Object)thread.getState())) continue;
            ++ct;
        }
        return ct;
    }

    private Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = this.getRootThreadGroup();
        int ct = Thread.activeCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[ct *= 2], true)) == ct) {
        }
        return Arrays.copyOf(threads, n);
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }
}

