/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.mdc;

import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.owasp.security.logging.mdc.IPlugin;
import org.owasp.security.logging.mdc.plugins.IPAddressPlugin;
import org.owasp.security.logging.mdc.plugins.SessionPlugin;
import org.slf4j.MDC;

public class MDCFilter
implements Filter {
    public static final String IPADDRESS = "ipAddress";
    public static final String LOGIN_ID = "username";
    public static final String SESSION = "session";
    private static final String HOSTNAME = "hostName";
    private static final String PRODUCTNAME = "productName";
    private String productName;
    private static final Map<String, IPlugin> plugins = new LinkedHashMap<String, IPlugin>();

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String pluginName = (String)e.nextElement();
            if ("ProductName".equals(pluginName)) {
                this.productName = filterConfig.getInitParameter("ProductName");
                continue;
            }
            try {
                IPlugin plugin = (IPlugin)Class.forName(filterConfig.getInitParameter(pluginName)).newInstance();
                plugin.init(filterConfig);
                plugins.put(pluginName, plugin);
            }
            catch (Exception cnfe) {
                cnfe.printStackTrace();
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        MDC.put((String)HOSTNAME, (String)servletRequest.getServerName());
        if (this.productName != null) {
            MDC.put((String)PRODUCTNAME, (String)this.productName);
        }
        MDC.put((String)"locale", (String)servletRequest.getLocale().getDisplayName());
        for (IPlugin plugin : plugins.values()) {
            plugin.execute(request);
        }
        filterChain.doFilter(servletRequest, servletResponse);
        MDC.clear();
    }

    public void destroy() {
    }

    static {
        plugins.put(IPADDRESS, new IPAddressPlugin());
        plugins.put(SESSION, new SessionPlugin());
    }
}

