/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class FuzzerFileFilter
extends FileFilter {
    private Hashtable<String, FuzzerFileFilter> filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;

    public FuzzerFileFilter() {
        this.addExtension("jbrf");
        this.setDescription("JBroFuzz Payload Files");
    }

    @Override
    public boolean accept(File fileObject) {
        if (fileObject != null) {
            if (fileObject.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(fileObject);
            if (extension != null && this.filters.get(this.getExtension(fileObject)) != null) {
                return true;
            }
        }
        return false;
    }

    private void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(Locale.ENGLISH), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration<String> extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    private String getExtension(File fileObject) {
        String filename;
        int index;
        if (fileObject != null && (index = (filename = fileObject.getName()).lastIndexOf(46)) > 0 && index < filename.length() - 1) {
            return filename.substring(index + 1).toLowerCase();
        }
        return null;
    }

    private boolean isExtensionListInDescription() {
        return true;
    }

    private void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }
}

