/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.update;

import com.Ostermiller.util.Browser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class StartUpdateChecker
extends JDialog {
    private static final long serialVersionUID = 9196081991196086812L;
    private static final int SIZE_X = 440;
    private static final int SIZE_Y = 220;
    private static final double ZERO_VERSION = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static double getWebsiteVersion() {
        StringBuffer body;
        URLConnection urlc2222222;
        String response = "";
        BufferedReader instream = null;
        URL url = new URL("http://www.owasp.org/index.php/JBroFuzz");
        boolean proxyEnabled = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.UPDATE[0].getId(), false);
        if (proxyEnabled) {
            String proxy = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[1].getId(), "");
            int port = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.UPDATE[2].getId(), -1);
            Proxy myProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, port));
            urlc2222222 = url.openConnection(myProxy);
            boolean proxyReqAuth = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.UPDATE[3].getId(), false);
            if (proxyReqAuth) {
                String user = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[5].getId(), "");
                String pass = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[6].getId(), "");
                String encodedPassword = EncoderHashCore.encode(user + ":" + pass, "Base64");
                urlc2222222.setRequestProperty("Proxy-Authorization", "Basic " + encodedPassword);
            }
        } else {
            urlc2222222 = url.openConnection();
        }
        urlc2222222.setRequestProperty("User-Agent", "JBroFuzz/2.5");
        int statusCode = ((HttpURLConnection)urlc2222222).getResponseCode();
        if (statusCode == 200) {
            int count;
            instream = new BufferedReader(new InputStreamReader(urlc2222222.getInputStream()));
            long contentLength = urlc2222222.getContentLength();
            if (contentLength > Integer.MAX_VALUE) {
                double proxyReqAuth = 0.0;
                IOUtils.closeQuietly((Reader)instream);
                return proxyReqAuth;
            }
            body = new StringBuffer(65535);
            for (int limit = 0; (count = instream.read()) != -1 && limit < 65535; ++limit) {
                body.append((char)count);
            }
        } else {
            double d = 0.0;
            IOUtils.closeQuietly(instream);
            return d;
        }
        instream.close();
        response = body.toString();
        IOUtils.closeQuietly((Reader)instream);
        if (response.equalsIgnoreCase("")) return 0.0;
        Pattern pattern1 = Pattern.compile("Current version is (\\d.\\d)");
        Matcher match1 = pattern1.matcher(response);
        if (!match1.find()) return 0.0;
        String webVersion = match1.group().substring(19, 22);
        try {
            return Double.parseDouble(webVersion);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
        catch (IOException e) {
            double urlc2222222 = 0.0;
            return urlc2222222;
        }
        finally {
            IOUtils.closeQuietly(instream);
        }
    }

    protected StartUpdateChecker(JBroFuzzWindow parent) {
        super(parent, " JBroFuzz - New Version Available ", true);
        double current;
        double latest = StartUpdateChecker.getWebsiteVersion();
        if (latest == 0.0) {
            this.dispose();
            return;
        }
        try {
            current = Double.parseDouble("2.5");
        }
        catch (NumberFormatException e1) {
            current = 0.0;
        }
        if (latest <= current) {
            this.dispose();
            return;
        }
        String text = "<html><b>A new version of JBroFuzz is available:&nbsp;" + latest + "<br><br>You are currently running version:&nbsp;" + current + "<br><br>Do you wish to download the <br>new version now?" + "</b></html>";
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setLayout(new BorderLayout());
        this.setFont(new Font("Verdana", 0, 12));
        JPanel centerPanel = new JPanel(new FlowLayout(0, 15, 15));
        JPanel southPanel = new JPanel(new FlowLayout(2, 15, 15));
        JLabel mainLabel = new JLabel(text, ImageCreator.IMG_OWASP, 2);
        mainLabel.setIconTextGap(20);
        mainLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        centerPanel.add(mainLabel);
        JButton download = new JButton("Download");
        JButton close = new JButton("Close");
        southPanel.add(download);
        southPanel.add(close);
        download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent even) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Browser.init();
                        try {
                            Browser.displayURL((String)"http://www.owasp.org/index.php/JBroFuzz");
                        }
                        catch (IOException e) {
                            System.out.println("An IOException occurred.");
                        }
                        StartUpdateChecker.this.dispose();
                    }
                });
            }
        });
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent even) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StartUpdateChecker.this.dispose();
                    }
                });
            }
        });
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
        int xLocation = parent.getLocationOnScreen().x - 220 + parent.getWidth() / 2;
        int yLocation = parent.getLocationOnScreen().y - 110 + parent.getHeight() / 2;
        this.setSize(440, 220);
        this.setLocation(xLocation, yLocation);
        this.setMinimumSize(new Dimension(440, 220));
        this.setResizable(true);
        this.setVisible(true);
    }
}

