/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.update;

import com.Ostermiller.util.Browser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.prefs.PrefDialog;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class CheckForUpdates
extends JDialog {
    private static final long serialVersionUID = -3559816997365442282L;
    private static final int SIZE_X = 650;
    private static final int SIZE_Y = 400;
    private final JTextArea mainLabel;
    private final JButton startStop;
    private final JButton proxy;
    private final JButton close;
    private boolean newVersionExists;

    public CheckForUpdates(final JBroFuzzWindow parent) {
        super(parent, " JBroFuzz - Check For Updates ", true);
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setDefaultCloseOperation(0);
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        JPanel centerPanel = new JPanel(new FlowLayout(0, 15, 15));
        JPanel southPanel = new JPanel(new FlowLayout(2, 15, 15));
        this.newVersionExists = false;
        this.mainLabel = new JTextArea();
        this.mainLabel.setFont(new Font("Monospaced", 0, 14));
        this.mainLabel.setMargin(new Insets(1, 1, 1, 1));
        this.mainLabel.setBackground(Color.BLACK);
        this.mainLabel.setForeground(new Color(0, 128, 255));
        this.mainLabel.setEditable(false);
        this.mainLabel.setVisible(true);
        AbstractPanel.popupText(this.mainLabel, false, true, false, true);
        JLabel imageLabel = new JLabel(ImageCreator.IMG_OWASP);
        JScrollPane providersTableScrollPane = new JScrollPane(imageLabel);
        providersTableScrollPane.setColumnHeader(null);
        providersTableScrollPane.setVerticalScrollBarPolicy(20);
        providersTableScrollPane.setHorizontalScrollBarPolicy(30);
        imageLabel.setPreferredSize(new Dimension(100, 290));
        centerPanel.add(imageLabel);
        JScrollPane providersTextScrollPane = new JScrollPane(this.mainLabel);
        providersTextScrollPane.setVerticalScrollBarPolicy(20);
        providersTextScrollPane.setHorizontalScrollBarPolicy(30);
        providersTextScrollPane.setPreferredSize(new Dimension(500, 290));
        centerPanel.add(providersTextScrollPane);
        this.startStop = new JButton("Check");
        this.proxy = new JButton("Proxy");
        this.close = new JButton("Close");
        this.startStop.setToolTipText("Check online for a latest version");
        this.proxy.setToolTipText("Configure proxy settings");
        this.close.setToolTipText("Close this window");
        southPanel.add(this.startStop);
        southPanel.add(this.proxy);
        southPanel.add(this.close);
        this.startStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final class Starter
                extends SwingWorker<String, Object> {
                    Starter() {
                    }

                    @Override
                    public String doInBackground() {
                        CheckForUpdates.this.startUpdate();
                        return "check-update-return";
                    }

                    @Override
                    protected void done() {
                        CheckForUpdates.this.finishUpdate();
                    }
                }
                new Starter().execute();
            }
        });
        this.proxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckForUpdates.this.dispose();
                        new PrefDialog(parent, PrefDialog.PrefsPanel.UPDATE);
                    }
                });
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckForUpdates.this.dispose();
                    }
                });
            }
        });
        this.getContentPane().add((Component)centerPanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
        this.setLocation(parent.getLocation().x + (parent.getWidth() - 650) / 2, parent.getLocation().y + (parent.getHeight() - 400) / 2);
        this.setSize(650, 400);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void finishUpdate() {
        ActionListener[] acArray;
        if (!this.startStop.isEnabled()) {
            return;
        }
        this.proxy.setEnabled(true);
        this.close.setEnabled(true);
        for (ActionListener listener : acArray = this.startStop.getActionListeners()) {
            this.startStop.removeActionListener(listener);
        }
        if (this.newVersionExists) {
            this.startStop.setText("Download");
            this.startStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Browser.init();
                            try {
                                Browser.displayURL((String)"http://www.owasp.org/index.php/JBroFuzz");
                                CheckForUpdates.this.startStop.setEnabled(false);
                                CheckForUpdates.this.proxy.setEnabled(true);
                                CheckForUpdates.this.close.setEnabled(true);
                            }
                            catch (IOException ex) {
                                CheckForUpdates.this.mainLabel.append("\nAn error occured while attempting to open the browser:\n\nhttp://www.owasp.org/index.php/JBroFuzz");
                            }
                            CheckForUpdates.this.dispose();
                        }
                    });
                }
            });
        } else {
            this.startStop.setText("Finish");
            this.startStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CheckForUpdates.this.startStop.setEnabled(false);
                            CheckForUpdates.this.proxy.setEnabled(true);
                            CheckForUpdates.this.close.setEnabled(true);
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUpdate() {
        String response;
        block26: {
            ActionListener[] acArray;
            if (!this.startStop.isEnabled()) {
                return;
            }
            this.startStop.setEnabled(true);
            this.startStop.setText("Stop");
            this.proxy.setEnabled(false);
            this.close.setEnabled(false);
            for (ActionListener listener : acArray = this.startStop.getActionListeners()) {
                this.startStop.removeActionListener(listener);
            }
            this.startStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CheckForUpdates.this.startStop.setEnabled(false);
                            CheckForUpdates.this.proxy.setEnabled(true);
                            CheckForUpdates.this.close.setEnabled(true);
                        }
                    });
                }
            });
            response = "";
            this.mainLabel.setText("Finding JBroFuzz Website...\t\t\t\t");
            try {
                URLConnection urlc;
                URL url = new URL("http://www.owasp.org/index.php/JBroFuzz");
                boolean proxyEnabled = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.UPDATE[0].getId(), false);
                if (proxyEnabled) {
                    String proxy = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[1].getId(), "");
                    int port = JBroFuzz.PREFS.getInt(JBroFuzzPrefs.UPDATE[2].getId(), -1);
                    Proxy myProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy, port));
                    urlc = url.openConnection(myProxy);
                    boolean proxyReqAuth = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.UPDATE[3].getId(), false);
                    if (proxyReqAuth) {
                        String user = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[5].getId(), "");
                        String pass = JBroFuzz.PREFS.get(JBroFuzzPrefs.UPDATE[6].getId(), "");
                        String encodedPassword = EncoderHashCore.encode(user + ":" + pass, "Base64");
                        urlc.setRequestProperty("Proxy-Authorization", "Basic " + encodedPassword);
                    }
                } else {
                    urlc = url.openConnection();
                }
                urlc.setRequestProperty("User-Agent", "JBroFuzz/2.5");
                int statusCode = ((HttpURLConnection)urlc).getResponseCode();
                if (statusCode == 200) {
                    this.mainLabel.append("[ OK ]\nChecking JBroFuzz Website...\t\t\t\t");
                    BufferedReader instream = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
                    if (instream != null) {
                        int c;
                        long contentLength = urlc.getContentLength();
                        if (contentLength > Integer.MAX_VALUE) {
                            throw new IOException("Content too large to be buffered: " + contentLength + " bytes");
                        }
                        StringBuffer body = new StringBuffer(131072);
                        for (int l = 0; (c = instream.read()) != -1 && l < 131072; ++l) {
                            body.append((char)c);
                        }
                        instream.close();
                        response = body.toString();
                    }
                    break block26;
                }
                this.mainLabel.append("[FAIL]\nConnection returned the following code: " + statusCode + "\n");
            }
            catch (MalformedURLException e) {
                this.mainLabel.append("[FAIL]\nMalformed URL violation: " + e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                this.mainLabel.append("[FAIL]\nEncoding error: " + e.getMessage());
            }
            catch (IOException e) {
                this.mainLabel.append("[FAIL]\nFatal transport error: " + e.getMessage());
            }
        }
        if (!response.equalsIgnoreCase("")) {
            this.mainLabel.append("[ OK ]\nChecking for latest version...\t\t\t\t");
            Pattern p1 = Pattern.compile("Current version is (\\d.\\d)");
            Matcher m1 = p1.matcher(response);
            if (m1.find()) {
                this.mainLabel.append("[ OK ]\nComparing version numbers...\t\t\t\t");
                String webVersion = m1.group().substring(19, 22);
                double current = 0.0;
                double latest = 0.0;
                try {
                    current = Double.parseDouble("2.5");
                    latest = Double.parseDouble(webVersion);
                    this.mainLabel.append("[ OK ]\n\nWebsite Version is: " + webVersion);
                    this.mainLabel.append("\nCurrent Version is: 2.5\n\n");
                }
                catch (NumberFormatException e) {
                    this.mainLabel.append("[FAIL]\n");
                }
                if (latest == 0.0) {
                    this.mainLabel.append("\nCould not interpret JBroFuzz version\nnumbers.\n\nTo check manually, visit:\n\nhttp://www.owasp.org/index.php/JBroFuzz");
                } else if (latest > current) {
                    this.mainLabel.append("\nJBroFuzz " + latest + " is available for download.");
                    this.newVersionExists = true;
                } else if (latest < current) {
                    this.mainLabel.append("\nYou are running a newer (perhaps experimental) version.");
                } else {
                    this.mainLabel.append("\nYou are running the latest version.");
                }
            } else {
                this.mainLabel.append("[FAIL]\n\nCould not identify JBroFuzz version at:\n\nhttp://www.owasp.org/index.php/JBroFuzz");
            }
        }
    }
}

