/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.payloads;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.tablemodels.SingleColumnModel;
import org.owasp.jbrofuzz.util.NonWrappingTextPane;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class PayloadsDialog
extends JDialog {
    private static final long serialVersionUID = -1083415577221148132L;
    private static final int SIZE_X = 680;
    private static final int SIZE_Y = 400;
    private static final String NAME_CATEGORY = "Category-Table";
    private static final String NAME_FUZZER = "Fuzzer-Table";
    private static final String NAME_PAYLOAD = "Payload-Table";
    private final JButton okBut;
    private final JBroFuzzWindow mWindow;
    private final JPanel fuzzersPanel;
    private final JPanel payloadsPanel;
    private final JTable categoriesTable;
    private final JTable fuzzersTable;
    private final JTable payloadsTable;
    private final SingleColumnModel catTableModel;
    private final SingleColumnModel fTableModel;
    private final SingleColumnModel pTableModel;
    private TableRowSorter<SingleColumnModel> sorter2;
    private final NonWrappingTextPane fInfoArea;

    public PayloadsDialog(AbstractPanel parent, final int start, final int end) {
        super(parent.getFrame(), " Add a Fuzzer ", true);
        this.setFont(new Font("SansSerif", 1, 10));
        this.setLayout(null);
        this.mWindow = parent.getFrame();
        JPanel categoriesPanel = new JPanel();
        categoriesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Categories "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        categoriesPanel.setBounds(10, 20, 190, 330);
        this.add(categoriesPanel);
        this.catTableModel = new SingleColumnModel(" Category Name ");
        this.categoriesTable = new JTable(this.catTableModel);
        this.categoriesTable.setName(NAME_CATEGORY);
        this.popup(this.categoriesTable);
        this.categoriesTable.setSelectionMode(0);
        this.catTableModel.setData(this.mWindow.getJBroFuzz().getDatabase().getAllCategories());
        TableRowSorter<SingleColumnModel> sorter = new TableRowSorter<SingleColumnModel>(this.catTableModel);
        this.categoriesTable.setRowSorter(sorter);
        this.categoriesTable.setFont(new Font("Verdana", 1, 10));
        this.categoriesTable.setRowHeight(30);
        this.categoriesTable.getSelectionModel().addListSelectionListener(new CategoriesRowListener());
        this.categoriesTable.setBackground(Color.BLACK);
        this.categoriesTable.setForeground(Color.WHITE);
        this.categoriesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent kEvent) {
                if (kEvent.getKeyCode() == 27) {
                    PayloadsDialog.this.dispose();
                }
            }
        });
        JScrollPane catScrollPane = new JScrollPane(this.categoriesTable);
        catScrollPane.setVerticalScrollBarPolicy(20);
        catScrollPane.setHorizontalScrollBarPolicy(30);
        catScrollPane.setPreferredSize(new Dimension(170, 290));
        categoriesPanel.add(catScrollPane);
        this.fuzzersPanel = new JPanel();
        this.fuzzersPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Select a Category "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.fuzzersPanel.setBounds(210, 20, 180, 250);
        this.add(this.fuzzersPanel);
        this.fTableModel = new SingleColumnModel(" Fuzzer Name ");
        this.fuzzersTable = new JTable(this.fTableModel);
        this.fuzzersTable.setName(NAME_FUZZER);
        this.popup(this.fuzzersTable);
        this.sorter2 = new TableRowSorter<SingleColumnModel>(this.fTableModel);
        this.fuzzersTable.setRowSorter(this.sorter2);
        this.fuzzersTable.setFont(new Font("Verdana", 1, 10));
        this.fuzzersTable.setRowHeight(30);
        this.fuzzersTable.setSelectionMode(0);
        this.fuzzersTable.getSelectionModel().addListSelectionListener(new FuzzersRowListener());
        this.fuzzersTable.setBackground(Color.BLACK);
        this.fuzzersTable.setForeground(Color.WHITE);
        this.fuzzersTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent kEvent) {
                if (kEvent.getKeyCode() == 27) {
                    PayloadsDialog.this.dispose();
                }
            }
        });
        JScrollPane nameScrollPane = new JScrollPane(this.fuzzersTable);
        nameScrollPane.setVerticalScrollBarPolicy(20);
        nameScrollPane.setHorizontalScrollBarPolicy(30);
        nameScrollPane.setPreferredSize(new Dimension(160, 210));
        this.fuzzersPanel.add(nameScrollPane);
        this.payloadsPanel = new JPanel();
        this.payloadsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Select a Fuzzer "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.payloadsPanel.setBounds(400, 20, 260, 190);
        this.payloadsPanel.setLayout(new BoxLayout(this.payloadsPanel, 1));
        this.add(this.payloadsPanel);
        this.pTableModel = new SingleColumnModel(" Payloads ");
        this.payloadsTable = new JTable(this.pTableModel);
        this.payloadsTable.setName(NAME_PAYLOAD);
        this.popup(this.payloadsTable);
        this.payloadsTable.setFont(new Font("Verdana", 1, 10));
        this.payloadsTable.setRowHeight(30);
        this.payloadsTable.setSelectionMode(0);
        this.payloadsTable.setBackground(Color.BLACK);
        this.payloadsTable.setForeground(Color.WHITE);
        JScrollPane plScrollPane = new JScrollPane(this.payloadsTable);
        plScrollPane.setVerticalScrollBarPolicy(20);
        plScrollPane.setHorizontalScrollBarPolicy(30);
        plScrollPane.setPreferredSize(new Dimension(200, 210));
        this.fInfoArea = new NonWrappingTextPane();
        this.fInfoArea.putClientProperty("charset", "UTF-8");
        this.fInfoArea.setEditable(false);
        this.fInfoArea.setVisible(true);
        this.fInfoArea.setFont(new Font("Verdana", 1, 10));
        this.fInfoArea.setMargin(new Insets(1, 1, 1, 1));
        this.fInfoArea.setBackground(Color.WHITE);
        this.fInfoArea.setForeground(Color.BLACK);
        AbstractPanel.popupText(this.fInfoArea, false, true, false, true);
        this.fInfoArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent kEvent) {
                if (kEvent.getKeyCode() == 27) {
                    PayloadsDialog.this.dispose();
                }
            }
        });
        JScrollPane fuzzerInfoScrollPane = new JScrollPane(this.fInfoArea);
        fuzzerInfoScrollPane.setVerticalScrollBarPolicy(20);
        fuzzerInfoScrollPane.setHorizontalScrollBarPolicy(30);
        fuzzerInfoScrollPane.setPreferredSize(new Dimension(150, 100));
        JSplitPane payloadsSplitPane = new JSplitPane(0);
        payloadsSplitPane.setOneTouchExpandable(false);
        payloadsSplitPane.setTopComponent(plScrollPane);
        payloadsSplitPane.setBottomComponent(fuzzerInfoScrollPane);
        payloadsSplitPane.setDividerLocation(150);
        this.payloadsPanel.add(plScrollPane);
        this.payloadsTable.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.fInfoArea.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.okBut = new JButton(" Add Fuzzer ", ImageCreator.IMG_ADD);
        this.okBut.setBounds(515, 305, 140, 40);
        this.okBut.setEnabled(false);
        this.okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int selRow = PayloadsDialog.this.fuzzersTable.getSelectedRow();
                        String name = (String)PayloadsDialog.this.fTableModel.getValueAt(PayloadsDialog.this.fuzzersTable.convertRowIndexToModel(selRow), 0);
                        String selID = PayloadsDialog.this.mWindow.getJBroFuzz().getDatabase().getIdFromName(name);
                        PayloadsDialog.this.mWindow.getPanelFuzzing().getFuzzersPanel().addFuzzer(selID, start, end);
                        PayloadsDialog.this.dispose();
                    }
                });
            }
        });
        this.okBut.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent kEvent) {
                if (kEvent.getKeyCode() == 27) {
                    PayloadsDialog.this.dispose();
                }
            }
        });
        this.okBut.setToolTipText("The selected category will be added to the fuzzing list");
        this.getContentPane().add(this.okBut);
        this.setLocation(parent.getFrame().getLocation().x + 100, parent.getFrame().getLocation().y + 100);
        this.setSize(680, 400);
        this.setResizable(true);
        this.setVisible(true);
    }

    private void popup(final JTable area) {
        final JPopupMenu popmenu = new JPopupMenu();
        JMenuItem i1_cut = new JMenuItem("Cut");
        JMenuItem i2_copy = new JMenuItem("Copy");
        JMenuItem i3_paste = new JMenuItem("Paste");
        JMenuItem i4_select = new JMenuItem("Select All");
        JMenuItem i5_properties = new JMenuItem("Properties");
        i1_cut.setEnabled(false);
        i2_copy.setEnabled(true);
        i3_paste.setEnabled(false);
        i4_select.setEnabled(false);
        popmenu.add(i1_cut);
        popmenu.add(i2_copy);
        popmenu.add(i3_paste);
        popmenu.add(i4_select);
        popmenu.addSeparator();
        popmenu.add(i5_properties);
        i2_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                int selRow = area.getSelectedRow();
                String value = (String)area.getModel().getValueAt(selRow, 0);
                StringSelection ss = new StringSelection(value);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
            }
        });
        i5_properties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String category;
                String fuzzer;
                int c;
                if (area.getName().equalsIgnoreCase(PayloadsDialog.NAME_FUZZER)) {
                    c = PayloadsDialog.this.fuzzersTable.getSelectedRow();
                    PayloadsDialog.this.fuzzersTable.getSelectionModel().setSelectionInterval(PayloadsDialog.this.fuzzersTable.convertRowIndexToModel(c), PayloadsDialog.this.fuzzersTable.convertRowIndexToModel(c));
                    fuzzer = (String)PayloadsDialog.this.fTableModel.getValueAt(PayloadsDialog.this.fuzzersTable.convertRowIndexToModel(c), 0);
                    int d = PayloadsDialog.this.categoriesTable.getSelectedRow();
                    category = (String)PayloadsDialog.this.catTableModel.getValueAt(PayloadsDialog.this.categoriesTable.convertRowIndexToModel(d), 0);
                    PayloadsDialog.this.dispose();
                    PayloadsDialog.this.mWindow.setTabShow(125);
                    PayloadsDialog.this.mWindow.getPanelPayloads().setCategoryDisplayed(category);
                    PayloadsDialog.this.mWindow.getPanelPayloads().setFuzzerDisplayed(fuzzer, category);
                }
                if (area.getName().equalsIgnoreCase(PayloadsDialog.NAME_CATEGORY)) {
                    c = PayloadsDialog.this.categoriesTable.getSelectedRow();
                    PayloadsDialog.this.categoriesTable.getSelectionModel().setSelectionInterval(PayloadsDialog.this.categoriesTable.convertRowIndexToModel(c), PayloadsDialog.this.categoriesTable.convertRowIndexToModel(c));
                    String value = (String)PayloadsDialog.this.catTableModel.getValueAt(PayloadsDialog.this.categoriesTable.convertRowIndexToModel(c), 0);
                    PayloadsDialog.this.dispose();
                    PayloadsDialog.this.mWindow.setTabShow(125);
                    PayloadsDialog.this.mWindow.getPanelPayloads().setCategoryDisplayed(value);
                }
                if (area.getName().equalsIgnoreCase(PayloadsDialog.NAME_PAYLOAD)) {
                    c = PayloadsDialog.this.fuzzersTable.getSelectedRow();
                    PayloadsDialog.this.fuzzersTable.getSelectionModel().setSelectionInterval(PayloadsDialog.this.fuzzersTable.convertRowIndexToModel(c), PayloadsDialog.this.fuzzersTable.convertRowIndexToModel(c));
                    fuzzer = (String)PayloadsDialog.this.fTableModel.getValueAt(PayloadsDialog.this.fuzzersTable.convertRowIndexToModel(c), 0);
                    int selCat = PayloadsDialog.this.categoriesTable.getSelectedRow();
                    PayloadsDialog.this.categoriesTable.getSelectionModel().setSelectionInterval(PayloadsDialog.this.categoriesTable.convertRowIndexToModel(selCat), PayloadsDialog.this.categoriesTable.convertRowIndexToModel(selCat));
                    category = (String)PayloadsDialog.this.catTableModel.getValueAt(PayloadsDialog.this.categoriesTable.convertRowIndexToModel(selCat), 0);
                    int k = PayloadsDialog.this.payloadsTable.getSelectedRow();
                    PayloadsDialog.this.payloadsTable.getSelectionModel().setSelectionInterval(k, k);
                    String payload = (String)PayloadsDialog.this.pTableModel.getValueAt(k, 0);
                    PayloadsDialog.this.dispose();
                    PayloadsDialog.this.mWindow.setTabShow(125);
                    PayloadsDialog.this.mWindow.getPanelPayloads().setCategoryDisplayed(category);
                    PayloadsDialog.this.mWindow.getPanelPayloads().setFuzzerDisplayed(fuzzer, category);
                    PayloadsDialog.this.mWindow.getPanelPayloads().setPayloadDisplayed(payload, fuzzer, category);
                }
            }
        });
        area.addMouseListener(new MouseAdapter(){

            private void checkForTriggerEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    area.requestFocus();
                    JTable myTable = (JTable)e.getSource();
                    int c = myTable.rowAtPoint(new Point(e.getX(), e.getY()));
                    myTable.getSelectionModel().setAnchorSelectionIndex(c);
                    myTable.setRowSelectionInterval(c, c);
                    myTable.getSelectionModel().setSelectionInterval(c, c);
                    popmenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkForTriggerEvent(e);
            }
        });
    }

    private class FuzzersRowListener
    implements ListSelectionListener {
        private FuzzersRowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            String name;
            if (event.getValueIsAdjusting()) {
                return;
            }
            int dount = PayloadsDialog.this.fuzzersTable.getSelectedRow();
            try {
                dount = PayloadsDialog.this.fuzzersTable.convertRowIndexToModel(dount);
                name = (String)PayloadsDialog.this.fTableModel.getValueAt(dount, 0);
            }
            catch (IndexOutOfBoundsException e) {
                return;
            }
            String fuzzerID = PayloadsDialog.this.mWindow.getJBroFuzz().getDatabase().getIdFromName(name);
            PayloadsDialog.this.pTableModel.setData(PayloadsDialog.this.mWindow.getJBroFuzz().getDatabase().getPayloads(fuzzerID));
            if (PayloadsDialog.this.pTableModel.getRowCount() > 0) {
                PayloadsDialog.this.okBut.setEnabled(true);
                PayloadsDialog.this.payloadsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" " + PayloadsDialog.this.mWindow.getJBroFuzz().getDatabase().getPrototype(fuzzerID).getType() + " ID: " + fuzzerID + " "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
                PayloadsDialog.this.fInfoArea.setText("\nFuzzer Name: " + name + "\n" + "Fuzzer Type: " + PayloadsDialog.this.mWindow.getJBroFuzz().getDatabase().getPrototype(fuzzerID).getType() + "\n" + "Fuzzer Id:   " + fuzzerID + "\n\n" + "Total Number of Payloads: " + PayloadsDialog.this.mWindow.getJBroFuzz().getDatabase().getSize(fuzzerID));
                PayloadsDialog.this.fInfoArea.setCaretPosition(PayloadsDialog.this.fInfoArea.getText().length());
            } else {
                PayloadsDialog.this.okBut.setEnabled(false);
            }
        }
    }

    private class CategoriesRowListener
    implements ListSelectionListener {
        private CategoriesRowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            String value;
            if (event.getValueIsAdjusting()) {
                return;
            }
            int count = PayloadsDialog.this.categoriesTable.getSelectedRow();
            try {
                count = PayloadsDialog.this.categoriesTable.convertRowIndexToModel(count);
                value = (String)PayloadsDialog.this.catTableModel.getValueAt(count, 0);
            }
            catch (IndexOutOfBoundsException e) {
                return;
            }
            PayloadsDialog.this.fuzzersTable.setRowSorter(null);
            PayloadsDialog.this.fTableModel.setData(PayloadsDialog.this.mWindow.getJBroFuzz().getDatabase().getPrototypeNamesInCategory(value));
            PayloadsDialog.this.sorter2 = new TableRowSorter<SingleColumnModel>(PayloadsDialog.this.fTableModel);
            PayloadsDialog.this.fuzzersTable.setRowSorter(PayloadsDialog.this.sorter2);
            PayloadsDialog.this.payloadsTable.setRowSorter(null);
            PayloadsDialog.this.pTableModel.setData(null);
            PayloadsDialog.this.fuzzersPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" " + value + " "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            PayloadsDialog.this.payloadsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Select a Fuzzer "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            PayloadsDialog.this.fInfoArea.setText("");
            PayloadsDialog.this.fInfoArea.setCaretPosition(0);
        }
    }
}

