/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.headers;

import java.util.Enumeration;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.core.Prototype;
import org.owasp.jbrofuzz.core.Verifier;
import org.owasp.jbrofuzz.headers.Header;
import org.owasp.jbrofuzz.headers.HeaderTreeNode;

class HeaderLoader {
    private static final String HEADER = "JBroFuzz Headers Collection";
    private static final int MAX_RECURSION = 1024;
    private final HeaderTreeNode myNode = new HeaderTreeNode("JBroFuzz Headers Collection");
    private int globalCounter = 0;
    private final Map<String, Prototype> headersMap = Verifier.loadFile("headers.jbrf");

    private void addNodes(String[] categoriesArray, HeaderTreeNode headerTreeNode) {
        if (categoriesArray.length == 0) {
            return;
        }
        if (this.globalCounter > 1024) {
            return;
        }
        ++this.globalCounter;
        String firstElement = StringUtils.stripStart((String)StringUtils.stripEnd((String)categoriesArray[0], (String)" "), (String)" ");
        int index = 0;
        boolean exists = false;
        Enumeration<HeaderTreeNode> e = this.extracted(headerTreeNode);
        while (e.hasMoreElements() && !exists) {
            String currentElement = e.nextElement().toString();
            if (currentElement.equalsIgnoreCase(firstElement)) {
                exists = true;
                continue;
            }
            ++index;
        }
        if (!exists) {
            headerTreeNode.add(new HeaderTreeNode(firstElement));
        }
        String[] temp = (String[])ArrayUtils.subarray((Object[])categoriesArray, (int)1, (int)categoriesArray.length);
        HeaderTreeNode nemp = (HeaderTreeNode)headerTreeNode.getChildAt(index);
        this.addNodes(temp, nemp);
    }

    private Enumeration<HeaderTreeNode> extracted(HeaderTreeNode headerTreeNode) {
        return headerTreeNode.children();
    }

    protected Header getHeader(TreePath treePath) {
        if (!((HeaderTreeNode)treePath.getLastPathComponent()).isLeaf()) {
            return Header.ZERO;
        }
        for (String headerName : this.headersMap.keySet()) {
            Prototype proto = this.headersMap.get(headerName);
            int catLength = proto.getNoOfCategories();
            String[] categories = new String[catLength];
            proto.getCategories().toArray(categories);
            Object[] path = treePath.getPath();
            int success = path.length - 1;
            for (int i = 0; i < path.length; ++i) {
                try {
                    if (path[i + 1].toString().equalsIgnoreCase(categories[i])) {
                        --success;
                        continue;
                    }
                    i = 32;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException exp) {
                    i = 32;
                }
            }
            if (success != 0) continue;
            int noOfFields = proto.size();
            String[] output = new String[noOfFields];
            proto.getPayloads().toArray(output);
            StringBuffer myBuffer = new StringBuffer();
            for (String payload : output) {
                myBuffer.append(payload);
                myBuffer.append('\n');
            }
            myBuffer.append('\n');
            String commentL = proto.getComment();
            return new Header(noOfFields, myBuffer.toString(), commentL);
        }
        return Header.ZERO;
    }

    public HeaderTreeNode getMasterTreeNode() {
        return this.myNode;
    }

    protected void load() {
        for (String hd : this.headersMap.keySet()) {
            Prototype pt = this.headersMap.get(hd);
            String[] catArray = new String[pt.getNoOfCategories()];
            pt.getCategories().toArray(catArray);
            this.addNodes(catArray, this.myNode);
        }
    }
}

