/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.graph;

import com.Ostermiller.util.Browser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.graph.FileSystemTreeModel;
import org.owasp.jbrofuzz.graph.GraphingPanel;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.viewers.WindowViewerFrame;
import org.owasp.jbrofuzz.version.ImageCreator;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

class FileSystemTree
extends JTree
implements MouseListener {
    private static final long serialVersionUID = -4289004118182074303L;
    private static final String GR_PANEL = "Graphing Panel: ";
    private final JPopupMenu popmenu = new JPopupMenu();

    protected FileSystemTree(final GraphingPanel graphingPanel, FileSystemTreeModel fsTreeModel) {
        super(fsTreeModel);
        JMenuItem i0_graph = new JMenuItem("Graph");
        JMenuItem i1_open_folder = new JMenuItem("Open Containing Folder");
        JMenuItem i2_open_browser = new JMenuItem("Open in Browser");
        JMenuItem i3_open_viewer = new JMenuItem("Open in Viewer");
        JMenuItem i4_copy = new JMenuItem("Copy");
        i2_open_browser.setIcon(ImageCreator.IMG_OPENINBROWSER);
        i4_copy.setIcon(ImageCreator.IMG_COPY);
        this.popmenu.add(i0_graph);
        this.popmenu.addSeparator();
        this.popmenu.add(i1_open_folder);
        this.popmenu.add(i2_open_browser);
        this.popmenu.add(i3_open_viewer);
        this.popmenu.addSeparator();
        this.popmenu.add(i4_copy);
        i0_graph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                String stringFile = FileSystemTree.this.getFileFromPath(FileSystemTree.this.getSelectionPath());
                if (stringFile.startsWith(FileSystemTree.GR_PANEL)) {
                    Logger.log(stringFile, 4);
                } else {
                    File pathFile = new File(stringFile);
                    if (pathFile.isFile()) {
                        Logger.log("Graphing Panel: Cannot graph individual files", 4);
                    } else {
                        graphingPanel.getTabbedPlotter().plot(pathFile);
                    }
                }
            }
        });
        i1_open_folder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent openEvt) {
                String stringFile = FileSystemTree.this.getFileFromPath(FileSystemTree.this.getSelectionPath());
                if (stringFile.startsWith(FileSystemTree.GR_PANEL)) {
                    Logger.log(stringFile, 4);
                } else {
                    File pathFile = new File(stringFile);
                    File parentFile = pathFile.getParentFile();
                    Browser.init();
                    try {
                        Browser.displayURL((String)parentFile.toURI().toString());
                    }
                    catch (IOException ex) {
                        Logger.log("Graphing Panel: Could not open containing folder: " + parentFile.toString(), 3);
                    }
                }
            }
        });
        i2_open_browser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent openEvt) {
                String stringFile = FileSystemTree.this.getFileFromPath(FileSystemTree.this.getSelectionPath());
                if (stringFile.startsWith(FileSystemTree.GR_PANEL)) {
                    Logger.log(stringFile, 4);
                } else {
                    File pathFile = new File(stringFile);
                    Browser.init();
                    try {
                        Browser.displayURL((String)pathFile.toURI().toString());
                    }
                    catch (IOException ex) {
                        Logger.log("Graphing Panel: Could not open file in browser: " + pathFile.toString(), 3);
                    }
                }
            }
        });
        i3_open_viewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent openEvt) {
                String stringFile = FileSystemTree.this.getFileFromPath(FileSystemTree.this.getSelectionPath());
                if (stringFile.startsWith(FileSystemTree.GR_PANEL)) {
                    Logger.log(stringFile, 4);
                } else {
                    new WindowViewerFrame(graphingPanel, stringFile);
                }
            }
        });
        i4_copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent cpEvent) {
                String stringFile = FileSystemTree.this.getFileFromPath(FileSystemTree.this.getSelectionPath());
                if (stringFile.startsWith(FileSystemTree.GR_PANEL)) {
                    Logger.log(stringFile, 4);
                } else {
                    JTextArea myTempArea = new JTextArea(stringFile);
                    myTempArea.selectAll();
                    myTempArea.copy();
                }
            }
        });
        this.addMouseListener(this);
    }

    private final String getFileFromPath(TreePath selectedPath) {
        if (selectedPath == null) {
            return "Graphing Panel: The selected path is null";
        }
        if (selectedPath.getPathCount() > 32) {
            return "Graphing Panel: Path has more than 32 locations";
        }
        Object[] path = selectedPath.getPath();
        boolean saveElsewhere = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.DIRS[1].getId(), true);
        String dirString = saveElsewhere ? JBroFuzz.PREFS.get(JBroFuzzPrefs.DIRS[0].getId(), System.getProperty("user.dir")) : System.getProperty("user.dir");
        StringBuffer stringPath = new StringBuffer(dirString);
        stringPath.append(File.separator);
        stringPath.append("jbrofuzz");
        for (Object node : path) {
            stringPath.append(System.getProperty("file.separator"));
            stringPath.append(node.toString());
        }
        File pathFile = new File(stringPath.toString());
        if (!pathFile.exists()) {
            return "Graphing Panel: Path does not exist: " + pathFile;
        }
        if (!pathFile.canExecute()) {
            return "Graphing Panel: Path cannot be executed: " + pathFile;
        }
        return pathFile.toString();
    }

    private void checkForTriggerEvent(MouseEvent mEvent1) {
        if (mEvent1.isPopupTrigger()) {
            TreePath selPath = this.getPathForLocation(mEvent1.getX(), mEvent1.getY());
            this.setSelectionPath(selPath);
            this.popmenu.show(mEvent1.getComponent(), mEvent1.getX(), mEvent1.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mEvent2) {
        this.checkForTriggerEvent(mEvent2);
    }

    @Override
    public void mouseEntered(MouseEvent mEvent3) {
        this.checkForTriggerEvent(mEvent3);
    }

    @Override
    public void mouseExited(MouseEvent mEvent4) {
        this.checkForTriggerEvent(mEvent4);
    }

    @Override
    public void mousePressed(MouseEvent mEvent5) {
        this.checkForTriggerEvent(mEvent5);
    }

    @Override
    public void mouseReleased(MouseEvent mEvent6) {
        this.checkForTriggerEvent(mEvent6);
    }
}

