/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.owasp.jbrofuzz.encode.EncoderHashCore;
import org.owasp.jbrofuzz.fuzz.ui.ComboBoxRenderer;
import org.owasp.jbrofuzz.fuzz.ui.TransformsTableModel;

public class TransformsTable
extends JTable {
    private static final long serialVersionUID = 1876543211323L;

    public TransformsTable(TransformsTableModel model) {
        super(model);
        this.setFont(new Font("Monospaced", 1, 12));
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(30);
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        String[] encodersList = new String[EncoderHashCore.CODES.length + 2];
        System.arraycopy(EncoderHashCore.CODES, 0, encodersList, 0, EncoderHashCore.CODES.length);
        System.arraycopy(new String[]{"Match & Replace", "Prefix & Suffix"}, 0, encodersList, EncoderHashCore.CODES.length, 2);
        JComboBox<String> encoderCombo = new JComboBox<String>(encodersList);
        String[] timeOptions = new String[]{new String(), "Epoch Time"};
        final JComboBox<String> pomcombo = new JComboBox<String>(timeOptions);
        pomcombo.setEditable(true);
        final JComboBox<String> sorcombo = new JComboBox<String>(timeOptions);
        sorcombo.setEditable(true);
        pomcombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (pomcombo.getSelectedItem().equals("Epoch Time") || pomcombo.getSelectedItem().equals("DateFormat Time")) {
                    pomcombo.setEditable(false);
                } else {
                    pomcombo.setEditable(true);
                }
            }
        });
        sorcombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (sorcombo.getSelectedItem().equals("Epoch Time") || sorcombo.getSelectedItem().equals("DateFormat Time")) {
                    sorcombo.setEditable(false);
                } else {
                    sorcombo.setEditable(true);
                }
            }
        });
        int modelColumn = this.convertColumnIndexToModel(column);
        if (modelColumn == 0) {
            return new DefaultCellEditor(encoderCombo);
        }
        if (modelColumn == 1) {
            return new DefaultCellEditor(pomcombo);
        }
        if (modelColumn == 2) {
            return new DefaultCellEditor(sorcombo);
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int modelColumn = this.convertColumnIndexToModel(column);
        if (modelColumn == 0) {
            return new ComboBoxRenderer();
        }
        if (modelColumn == 1) {
            return new ComboBoxRenderer();
        }
        if (modelColumn == 2) {
            return new ComboBoxRenderer();
        }
        return super.getCellRenderer(row, column);
    }
}

