/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.encode;

import java.util.ArrayList;

public class ZBase32 {
    private static char[] encoding = "ybndrfg8ejkmcpqxot1uwisza345h769".toCharArray();
    private static byte[] decoding;

    public ZBase32() {
        ZBase32.init();
    }

    private static void init() {
        decoding = new byte[128];
        for (int i = 0; i < encoding.length; ++i) {
            ZBase32.decoding[ZBase32.encoding[i]] = (byte)i;
        }
    }

    public static String encode(String in) {
        return ZBase32.encode(in.getBytes());
    }

    public static String encode(byte[] in) {
        ZBase32.init();
        byte[] input = in;
        StringBuilder output = new StringBuilder();
        int special = input.length % 5;
        int normal = input.length - special;
        for (int i = 0; i < normal; i += 5) {
            output.append(encoding[(input[i] & 0xFF) >> 3 & 0x1F]);
            output.append(encoding[((input[i] & 0xFF) << 2 | (input[i + 1] & 0xFF) >> 6) & 0x1F]);
            output.append(encoding[(input[i + 1] & 0xFF) >> 1 & 0x1F]);
            output.append(encoding[((input[i + 1] & 0xFF) << 4 | (input[i + 2] & 0xFF) >> 4) & 0x1F]);
            output.append(encoding[((input[i + 2] & 0xFF) << 1 | (input[i + 3] & 0xFF) >> 7) & 0x1F]);
            output.append(encoding[(input[i + 3] & 0xFF) >> 2 & 0x1F]);
            output.append(encoding[((input[i + 3] & 0xFF) << 3 | (input[i + 4] & 0xFF) >> 5) & 0x1F]);
            output.append(encoding[input[i + 4] & 0xFF & 0x1F]);
        }
        switch (special) {
            case 1: {
                output.append(encoding[(input[normal] & 0xFF) >> 3 & 0x1F]);
                output.append(encoding[(input[normal] & 0xFF) << 2 & 0x1F]);
                break;
            }
            case 2: {
                output.append(encoding[(input[normal] & 0xFF) >> 3 & 0x1F]);
                output.append(encoding[((input[normal] & 0xFF) << 2 | (input[normal + 1] & 0xFF) >> 6) & 0x1F]);
                output.append(encoding[(input[normal + 1] & 0xFF) >> 1 & 0x1F]);
                output.append(encoding[(input[normal + 1] & 0xFF) << 4 & 0x1F]);
                break;
            }
            case 3: {
                output.append(encoding[(input[normal] & 0xFF) >> 3 & 0x1F]);
                output.append(encoding[((input[normal] & 0xFF) << 2 | (input[normal + 1] & 0xFF) >> 6) & 0x1F]);
                output.append(encoding[(input[normal + 1] & 0xFF) >> 1 & 0x1F]);
                output.append(encoding[((input[normal + 1] & 0xFF) << 4 | (input[normal + 2] & 0xFF) >> 4) & 0x1F]);
                output.append(encoding[(input[normal + 2] & 0xFF) << 1 & 0x1F]);
                break;
            }
            case 4: {
                output.append(encoding[(input[normal] & 0xFF) >> 3 & 0x1F]);
                output.append(encoding[((input[normal] & 0xFF) << 2 | (input[normal + 1] & 0xFF) >> 6) & 0x1F]);
                output.append(encoding[(input[normal + 1] & 0xFF) >> 1 & 0x1F]);
                output.append(encoding[((input[normal + 1] & 0xFF) << 4 | (input[normal + 2] & 0xFF) >> 4) & 0x1F]);
                output.append(encoding[((input[normal + 2] & 0xFF) << 1 | (input[normal + 3] & 0xFF) >> 7) & 0x1F]);
                output.append(encoding[(input[normal + 3] & 0xFF) >> 2 & 0x1F]);
                output.append(encoding[(input[normal + 3] & 0xFF) << 3 & 0x1F]);
            }
        }
        return output.toString();
    }

    public static String decode(String in) {
        int dataLen;
        ZBase32.init();
        String input = in;
        int expOrgSize = (int)Math.floor((double)input.length() / 1.6);
        int expPadSize = (int)Math.ceil((double)expOrgSize / 5.0) * 8;
        StringBuilder s = new StringBuilder(input);
        for (int i = 0; i < expPadSize; ++i) {
            s.append("=");
        }
        char[] data = s.toString().toLowerCase().toCharArray();
        for (dataLen = data.length; dataLen > 0 && ZBase32.ignore(data[dataLen - 1]); --dataLen) {
        }
        ArrayList<Byte> output = new ArrayList<Byte>();
        int i = 0;
        int e = dataLen - 8;
        i = ZBase32.next(data, i, e);
        while (i < e) {
            byte b1 = decoding[data[i++]];
            i = ZBase32.next(data, i, e);
            byte b2 = decoding[data[i++]];
            i = ZBase32.next(data, i, e);
            byte b3 = decoding[data[i++]];
            i = ZBase32.next(data, i, e);
            byte b4 = decoding[data[i++]];
            i = ZBase32.next(data, i, e);
            byte b5 = decoding[data[i++]];
            i = ZBase32.next(data, i, e);
            byte b6 = decoding[data[i++]];
            i = ZBase32.next(data, i, e);
            byte b7 = decoding[data[i++]];
            i = ZBase32.next(data, i, e);
            byte b8 = decoding[data[i++]];
            output.add((byte)(b1 << 3 | b2 >> 2));
            output.add((byte)(b2 << 6 | b3 << 1 | b4 >> 4));
            output.add((byte)(b4 << 4 | b5 >> 1));
            output.add((byte)(b5 << 7 | b6 << 2 | b7 >> 3));
            output.add((byte)(b7 << 5 | b8));
            i = ZBase32.next(data, i, e);
        }
        if (data[dataLen - 6] == '=') {
            output.add((byte)(decoding[data[dataLen - 8]] << 3 | decoding[data[dataLen - 7]] >> 2));
        } else if (data[dataLen - 4] == '=') {
            output.add((byte)(decoding[data[dataLen - 8]] << 3 | decoding[data[dataLen - 7]] >> 2));
            output.add((byte)(decoding[data[dataLen - 7]] << 6 | decoding[data[dataLen - 6]] << 1 | decoding[data[dataLen - 5]] >> 4));
        } else if (data[dataLen - 3] == '=') {
            output.add((byte)(decoding[data[dataLen - 8]] << 3 | decoding[data[dataLen - 7]] >> 2));
            output.add((byte)(decoding[data[dataLen - 7]] << 6 | decoding[data[dataLen - 6]] << 1 | decoding[data[dataLen - 5]] >> 4));
            output.add((byte)(decoding[data[dataLen - 5]] << 4 | decoding[data[dataLen - 4]] >> 1));
        } else if (data[dataLen - 1] == '=') {
            output.add((byte)(decoding[data[dataLen - 8]] << 3 | decoding[data[dataLen - 7]] >> 2));
            output.add((byte)(decoding[data[dataLen - 7]] << 6 | decoding[data[dataLen - 6]] << 1 | decoding[data[dataLen - 5]] >> 4));
            output.add((byte)(decoding[data[dataLen - 5]] << 4 | decoding[data[dataLen - 4]] >> 1));
            output.add((byte)(decoding[data[dataLen - 4]] << 7 | decoding[data[dataLen - 3]] << 2 | decoding[data[dataLen - 2]] >> 3));
        } else {
            output.add((byte)(decoding[data[dataLen - 8]] << 3 | decoding[data[dataLen - 7]] >> 2));
            output.add((byte)(decoding[data[dataLen - 7]] << 6 | decoding[data[dataLen - 6]] << 1 | decoding[data[dataLen - 5]] >> 4));
            output.add((byte)(decoding[data[dataLen - 5]] << 4 | decoding[data[dataLen - 4]] >> 1));
            output.add((byte)(decoding[data[dataLen - 4]] << 7 | decoding[data[dataLen - 3]] << 2 | decoding[data[dataLen - 2]] >> 3));
            output.add((byte)(decoding[data[dataLen - 2]] << 5 | decoding[data[dataLen - 1]]));
        }
        byte[] b = ZBase32.toPrimitive(output.toArray(new Byte[0]));
        return ZBase32.trim(new String(b));
    }

    private static String trim(String s) {
        char[] c = s.toCharArray();
        int end = c.length;
        int i = c.length - 1;
        while (i >= 0 && c[i] == '\u0000') {
            end = i--;
        }
        return s.substring(0, end);
    }

    private static int next(char[] data, int i, int e) {
        while (i < e && ZBase32.ignore(data[i])) {
            ++i;
        }
        return i;
    }

    private static boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ' || c == '-';
    }

    private static byte[] toPrimitive(Byte[] bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i];
        }
        return result;
    }
}

