/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.core.Prototype;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.util.JBroFuzzFileFilter;

public final class Verifier {
    private static final int MAX_CHARS = 65535;
    private static final int MAX_LINES = 500000;
    private static final int MAX_LINE_LENGTH = 2048;
    private static final int MAX_PROTO_NAME_LENGTH = 127;
    private static final int MAX_NO_OF_PAYLOADS = 500000;
    private static final int MAX_NO_OF_CATEGORIES = 127;
    private static final String ERROR_MSG = "\n\n\tBroken JBroFuzz Installation:\n\n\t";
    private static Map<String, Prototype> prototypes;
    private static Map<String, Prototype> headers;

    private Verifier() {
    }

    public static Map<String, Prototype> loadFile(String fileName) {
        if ("fuzzers.jbrf".equalsIgnoreCase(fileName)) {
            String inputContents;
            boolean extFilePresent = Verifier.checkExternalFile(fileName);
            if (extFilePresent) {
                Logger.log("Loading from the external file fuzzers.jbrf found in the current directory", 0);
                inputContents = Verifier.parseExtFile(fileName);
            } else {
                Logger.log("Loading from the internal file fuzzers.jbrf found in the current directory", 0);
                inputContents = Verifier.parseFile(fileName);
            }
            prototypes = new HashMap<String, Prototype>();
            Verifier.parsePrototypes(prototypes, inputContents);
            Logger.log("fuzzers.jbrf file loaded with " + prototypes.size() + " fuzzers", 0);
            return prototypes;
        }
        if ("headers.jbrf".equalsIgnoreCase(fileName)) {
            String headerContents = Verifier.parseFile(fileName);
            headers = new HashMap<String, Prototype>();
            Verifier.parsePrototypes(headers, headerContents);
            return headers;
        }
        throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tis not a valid name to load " + fileName);
    }

    public static Map<String, Prototype> loadAnyFile(String fuzzersFilePath) {
        if (fuzzersFilePath.length() > 512) {
            Logger.log("Cannot open a .jbrf file that has an absolute path greater than 512 characters", 4);
            return Verifier.loadFile("fuzzers.jbrf");
        }
        if (!fuzzersFilePath.endsWith(".jbrf")) {
            Logger.log("Cannot open file, does not have a .jbrf extension", 4);
            return Verifier.loadFile("fuzzers.jbrf");
        }
        boolean extFilePresent = Verifier.checkExternalFilePath(fuzzersFilePath);
        String inputContents = extFilePresent ? Verifier.parseExtFilePath(fuzzersFilePath) : Verifier.parseFile("fuzzers.jbrf");
        prototypes = new HashMap<String, Prototype>();
        Verifier.parsePrototypes(prototypes, inputContents);
        Logger.log("External file loaded with " + prototypes.size() + " fuzzers", 0);
        return prototypes;
    }

    private static boolean checkExternalFile(String fileName) {
        String dirString;
        try {
            dirString = System.getProperty("user.dir");
        }
        catch (SecurityException e) {
            return false;
        }
        File inputFile = new File(dirString + File.separator + fileName);
        JBroFuzzFileFilter jbfff = new JBroFuzzFileFilter();
        if (!jbfff.accept(inputFile)) {
            return false;
        }
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return false;
            }
            return inputFile.canRead();
        }
        return false;
    }

    private static boolean checkExternalFilePath(String fileNamePath) {
        File inputFile = new File(fileNamePath);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return false;
            }
            return inputFile.canRead();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseExtFile(String fileName) {
        int counter;
        JBroFuzzFileFilter jbfff = new JBroFuzzFileFilter();
        File inputFile = new File(System.getProperty("user.dir") + File.separator + fileName);
        if (!jbfff.accept(inputFile)) {
            return "This file is not accepted";
        }
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return "File is a directory:\n\n" + fileName;
            }
            if (!inputFile.canRead()) {
                return "File cannot be read:\n\n" + fileName;
            }
        } else {
            return "File does not exist:\n\n" + fileName;
        }
        BufferedInputStream in = null;
        FileInputStream fis = null;
        StringBuffer fileContents = new StringBuffer();
        try {
            int c;
            fis = new FileInputStream(inputFile);
            in = new BufferedInputStream(fis);
            for (counter = 0; (c = ((InputStream)in).read()) > 0 && counter <= 65535; ++counter) {
                if (!CharUtils.isAsciiPrintable((char)((char)c)) && (char)c != '\n') continue;
                fileContents.append((char)c);
            }
            ((InputStream)in).close();
            fis.close();
        }
        catch (IOException e) {
            String string;
            try {
                string = "Attempting to open the file caused an I/O Error:\n\n" + fileName;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)fis);
            return string;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((InputStream)fis);
        if (counter == 65535) {
            String maxMessage = "\n... stopped reading file after 65535 characters.\n";
            fileContents.append("\n... stopped reading file after 65535 characters.\n");
            Logger.log("\n... stopped reading file after 65535 characters.\n", 3);
        }
        return fileContents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseExtFilePath(String fuzzersFilePath) {
        int counter;
        File inputFile = new File(fuzzersFilePath);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                return "File is a directory:\n\n" + fuzzersFilePath;
            }
            if (!inputFile.canRead()) {
                return "File cannot be read:\n\n" + fuzzersFilePath;
            }
        } else {
            return "File does not exist:\n\n" + fuzzersFilePath;
        }
        BufferedInputStream in = null;
        FileInputStream fis = null;
        StringBuffer fileContents = new StringBuffer();
        try {
            int c;
            fis = new FileInputStream(inputFile);
            in = new BufferedInputStream(fis);
            for (counter = 0; (c = ((InputStream)in).read()) > 0 && counter <= 65535; ++counter) {
                if (!CharUtils.isAsciiPrintable((char)((char)c)) && (char)c != '\n') continue;
                fileContents.append((char)c);
            }
            ((InputStream)in).close();
            fis.close();
        }
        catch (IOException e) {
            String string;
            try {
                string = "Attempting to open the file caused an I/O Error:\n\n" + fuzzersFilePath;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)fis);
            return string;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((InputStream)fis);
        if (counter == 65535) {
            String maxMessage = "\n... stopped reading file after 65535 characters.\n";
            fileContents.append("\n... stopped reading file after 65535 characters.\n");
            Logger.log("\n... stopped reading file after 65535 characters.\n", 3);
        }
        return fileContents.toString();
    }

    private static String parseFile(String fileName) {
        StringBuffer fileContents = new StringBuffer();
        URL fileURL = ClassLoader.getSystemClassLoader().getResource(fileName);
        if (fileURL == null) {
            throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tcould not find " + fileName);
        }
        BufferedReader in = null;
        try {
            int c;
            int counter;
            URLConnection connection = fileURL.openConnection();
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            for (counter = 0; (c = in.read()) > 0 && counter < 65535; ++counter) {
                if (!CharUtils.isAsciiPrintable((char)((char)c)) && (char)c != '\n') continue;
                fileContents.append((char)c);
            }
            in.close();
            if (counter == 65535) {
                throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\t\n... stopped reading file :" + fileName + "\nafter " + 65535 + " characters.\n\n");
            }
        }
        catch (IOException e1) {
            try {
                throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tcould not read " + fileName);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)in);
        return fileContents.toString();
    }

    private static void parsePrototypes(Map<String, Prototype> map, String input) {
        String[] fileInput = input.split("\n");
        if (fileInput.length > 500000) {
            throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tfuzzers.jbrf has more than 500000 lines.");
        }
        if (fileInput.length < 3) {
            throw new RuntimeException("\n\n\tBroken JBroFuzz Installation:\n\n\tfuzzers.jbrf does not have enough lines.");
        }
        for (int i = 0; i < fileInput.length; ++i) {
            char inputTypeChar;
            if (fileInput[i].startsWith("#") || fileInput[i].length() > 2048) continue;
            try {
                if (fileInput[i].charAt(1) != ':') continue;
                if (fileInput[i].charAt(13) != ':') {
                }
            }
            catch (IndexOutOfBoundsException e1) {}
            continue;
            String[] _fla = fileInput[i].split(":");
            if (_fla.length != 4 || !Prototype.isValidFuzzerType(inputTypeChar = _fla[0].charAt(0)) || _fla[1].isEmpty() || _fla[2].isEmpty() || _fla[2].length() > 127) continue;
            int noPayloads = 0;
            try {
                noPayloads = Integer.parseInt(_fla[3]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (noPayloads > 500000 || noPayloads == 0 || i + noPayloads > fileInput.length) continue;
            try {
                if (!fileInput[i + 1].startsWith(">")) continue;
                if (!fileInput[i + 2].startsWith(">>")) {
                }
            }
            catch (IndexOutOfBoundsException e) {}
            continue;
            String line2 = "";
            try {
                line2 = fileInput[i + 1].substring(1);
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            String comment = "";
            try {
                comment = fileInput[i + 2].substring(2);
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            String[] _sla = line2.split("\\|");
            if (_sla.length > 127) continue;
            Prototype proto = new Prototype(inputTypeChar, _fla[1], _fla[2]);
            if (_sla.length > 0) {
                for (String categ_ry : _sla) {
                    categ_ry = StringUtils.stripEnd((String)categ_ry, (String)" ");
                    if ((categ_ry = StringUtils.stripStart((String)categ_ry, (String)" ")).isEmpty()) continue;
                    proto.addCategory(categ_ry);
                }
            } else {
                proto.addCategory("JBroFuzz");
            }
            proto.addComment(comment);
            for (int j = 1; j <= noPayloads; ++j) {
                try {
                    proto.addPayload(fileInput[i + 2 + j]);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            map.put(_fla[1], proto);
        }
    }

    static {
        headers = null;
    }
}

