/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.core;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.owasp.jbrofuzz.core.NoSuchFuzzerException;
import org.owasp.jbrofuzz.core.Prototype;

public class FuzzerBigInteger
implements Iterator<String> {
    private final transient int len;
    private final transient Prototype prototype;
    private transient List<String> payloads;
    private transient BigInteger cValue;
    private transient BigInteger maxValue;

    protected FuzzerBigInteger(Prototype prototype, int len) throws NoSuchFuzzerException {
        this.prototype = prototype;
        if (prototype == null) {
            this.maxValue = BigInteger.ZERO;
        } else {
            this.payloads = this.prototype.getPayloads();
            if (this.prototype.isRecursive()) {
                this.maxValue = BigInteger.valueOf(this.payloads.size());
                this.maxValue = this.maxValue.pow(len < 0 ? 0 : len);
            } else {
                this.maxValue = BigInteger.valueOf(this.payloads.size());
            }
        }
        this.cValue = BigInteger.ZERO;
        this.len = len;
    }

    public String getCurrectValue() {
        return this.cValue.toString();
    }

    public String getId() {
        return this.prototype.getId();
    }

    public String getMaximumValue() {
        return this.maxValue.toString();
    }

    public String getName() {
        return this.prototype.getName();
    }

    @Override
    public boolean hasNext() {
        return this.cValue.compareTo(this.maxValue) < 0;
    }

    @Override
    public String next() {
        StringBuffer output = new StringBuffer("");
        if (this.maxValue.compareTo(BigInteger.valueOf(this.payloads.size())) == 0) {
            output.append(this.payloads.get(this.cValue.intValue()));
            this.cValue = this.cValue.add(BigInteger.ONE);
        } else {
            BigInteger val = this.cValue;
            Stack<BigInteger> stack = new Stack<BigInteger>();
            while (val.compareTo(BigInteger.valueOf(this.payloads.size())) >= 0) {
                stack.push(val.mod(BigInteger.valueOf(this.payloads.size())));
                val = val.divide(BigInteger.valueOf(this.payloads.size()));
            }
            output.append(StringUtils.leftPad((String)this.payloads.get(val.intValue()), (int)(this.len - stack.size()), (String)this.payloads.get(0)));
            while (!stack.isEmpty()) {
                output.append(this.payloads.get(((BigInteger)stack.pop()).intValue()));
            }
            this.cValue = this.cValue.add(BigInteger.ONE);
        }
        return output.toString();
    }

    @Override
    public void remove() {
        this.cValue = this.cValue.subtract(BigInteger.ONE);
    }
}

