/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Settings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    private static final String PROPERTIES_FILE = "dependencycheck.properties";
    private static final String ARRAY_SEP = ",";
    private Properties props = null;
    private List<Predicate<String>> maskedKeys;
    private File tempDirectory = null;

    public Settings() {
        this.initialize(PROPERTIES_FILE);
    }

    public Settings(Properties properties) {
        this.props = properties;
        this.logProperties("Properties loaded", this.props);
    }

    public Settings(@NotNull String propertiesFilePath) {
        this.initialize(propertiesFilePath);
    }

    private void initialize(@NotNull String propertiesFilePath) {
        this.props = new Properties();
        try (InputStream in = FileUtils.getResourceAsStream(propertiesFilePath);){
            this.props.load(in);
        }
        catch (NullPointerException ex) {
            LOGGER.error("Did not find settings file '{}'.", (Object)propertiesFilePath);
            LOGGER.debug("", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load settings from '{}'.", (Object)propertiesFilePath);
            LOGGER.debug("", (Throwable)ex);
        }
        this.logProperties("Properties loaded", this.props);
    }

    public void cleanup() {
        this.cleanup(true);
    }

    public synchronized void cleanup(boolean deleteTemporary) {
        if (deleteTemporary && this.tempDirectory != null && this.tempDirectory.exists()) {
            LOGGER.debug("Deleting ALL temporary files from `{}`", (Object)this.tempDirectory.toString());
            FileUtils.delete(this.tempDirectory);
            this.tempDirectory = null;
        }
    }

    private boolean isKeyMasked(@NotNull String key) {
        if (this.maskedKeys == null || this.maskedKeys.isEmpty()) {
            this.initMaskedKeys();
        }
        return this.maskedKeys.stream().anyMatch(maskExp -> maskExp.test(key));
    }

    protected String getPrintableValue(@NotNull String key, String value) {
        String printableValue = null;
        if (value != null) {
            printableValue = this.isKeyMasked(key) ? "********" : value;
        }
        return printableValue;
    }

    protected void initMaskedKeys() {
        String[] masked = this.getArray("odc.settings.mask");
        this.maskedKeys = masked == null ? new ArrayList<Predicate<String>>() : Arrays.asList(masked).stream().map(v -> Pattern.compile(v).asPredicate()).collect(Collectors.toList());
    }

    private void logProperties(@NotNull String header, @NotNull Properties properties) {
        if (LOGGER.isDebugEnabled()) {
            this.initMaskedKeys();
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                pw.format("%s:%n%n", header);
                Enumeration<?> e = properties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = this.getPrintableValue(key, properties.getProperty(key));
                    if (value == null) continue;
                    pw.format("%s='%s'%n", key, value);
                }
                pw.flush();
                LOGGER.debug(sw.toString());
            }
        }
    }

    public void setString(@NotNull String key, @NotNull String value) {
        this.props.setProperty(key, value);
        LOGGER.debug("Setting: {}='{}'", (Object)key, (Object)this.getPrintableValue(key, value));
    }

    public void setStringIfNotNull(@NotNull String key, @Nullable String value) {
        if (null != value) {
            this.setString(key, value);
        }
    }

    public void setStringIfNotEmpty(@NotNull String key, @Nullable String value) {
        if (null != value && !value.isEmpty()) {
            this.setString(key, value);
        }
    }

    public void setArrayIfNotEmpty(@NotNull String key, @Nullable String[] value) {
        if (null != value && value.length > 0) {
            this.setString(key, new Gson().toJson((Object)value));
        }
    }

    public void setArrayIfNotEmpty(@NotNull String key, @Nullable List<String> value) {
        if (null != value && !value.isEmpty()) {
            this.setString(key, new Gson().toJson(value));
        }
    }

    public void setBoolean(@NotNull String key, boolean value) {
        this.setString(key, Boolean.toString(value));
    }

    public void setBooleanIfNotNull(@NotNull String key, @Nullable Boolean value) {
        if (null != value) {
            this.setBoolean(key, value);
        }
    }

    public void setFloat(@NotNull String key, float value) {
        this.setString(key, Float.toString(value));
    }

    public void setInt(@NotNull String key, int value) {
        this.props.setProperty(key, String.valueOf(value));
        LOGGER.debug("Setting: {}='{}'", (Object)key, (Object)value);
    }

    public void setIntIfNotNull(@NotNull String key, @Nullable Integer value) {
        if (null != value) {
            this.setInt(key, value);
        }
    }

    @SuppressFBWarnings(justification="try with resource will clenaup the resources", value={"OBL_UNSATISFIED_OBLIGATION"})
    public void mergeProperties(@NotNull File filePath) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(filePath);){
            this.mergeProperties(fis);
        }
    }

    @SuppressFBWarnings(justification="try with resource will clenaup the resources", value={"OBL_UNSATISFIED_OBLIGATION"})
    public void mergeProperties(@NotNull String filePath) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(filePath);){
            this.mergeProperties(fis);
        }
    }

    public void mergeProperties(@NotNull InputStream stream) throws IOException {
        this.props.load(stream);
        this.logProperties("Properties updated via merge", this.props);
    }

    @Nullable
    public File getFile(@NotNull String key) {
        String file = this.getString(key);
        if (file == null) {
            return null;
        }
        return new File(file);
    }

    protected File getDataFile(@NotNull String key) {
        String file = this.getString(key);
        LOGGER.debug("Settings.getDataFile() - file: '{}'", (Object)file);
        if (file == null) {
            return null;
        }
        if (file.startsWith("[JAR]")) {
            LOGGER.debug("Settings.getDataFile() - transforming filename");
            File jarPath = this.getJarPath();
            LOGGER.debug("Settings.getDataFile() - jar file: '{}'", (Object)jarPath.toString());
            File retVal = new File(jarPath, file.substring(6));
            LOGGER.debug("Settings.getDataFile() - returning: '{}'", (Object)retVal.toString());
            return retVal;
        }
        return new File(file);
    }

    private File getJarPath() {
        String decodedPath = ".";
        String jarPath = "";
        ProtectionDomain domain = Settings.class.getProtectionDomain();
        if (domain != null && domain.getCodeSource() != null && domain.getCodeSource().getLocation() != null) {
            jarPath = Settings.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        }
        try {
            decodedPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.trace("", (Throwable)ex);
        }
        File path = new File(decodedPath);
        if (path.getName().toLowerCase().endsWith(".jar")) {
            return path.getParentFile();
        }
        return new File(".");
    }

    public String getString(@NotNull String key, @Nullable String defaultValue) {
        return System.getProperty(key, this.props.getProperty(key, defaultValue));
    }

    public synchronized File getTempDirectory() throws IOException {
        if (this.tempDirectory == null) {
            File baseTemp = new File(this.getString("temp.directory", System.getProperty("java.io.tmpdir")));
            this.tempDirectory = FileUtils.createTempDirectory(baseTemp);
        }
        return this.tempDirectory;
    }

    public String getString(@NotNull String key) {
        return System.getProperty(key, this.props.getProperty(key));
    }

    public String[] getArray(@NotNull String key) {
        String string = this.getString(key);
        if (string != null) {
            if (string.charAt(0) == '{' || string.charAt(0) == '[') {
                return (String[])new Gson().fromJson(string, String[].class);
            }
            return string.split(ARRAY_SEP);
        }
        return null;
    }

    public void removeProperty(@NotNull String key) {
        this.props.remove(key);
    }

    public int getInt(@NotNull String key) throws InvalidSettingException {
        try {
            return Integer.parseInt(this.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to an int.", ex);
        }
    }

    public int getInt(@NotNull String key, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(this.getString(key));
        }
        catch (NumberFormatException ex) {
            if (!this.getString(key, "").isEmpty()) {
                LOGGER.debug("Could not convert property '{}={}' to an int; using {} instead.", new Object[]{key, this.getPrintableValue(key, this.getString(key)), defaultValue});
            }
            value = defaultValue;
        }
        return value;
    }

    public long getLong(@NotNull String key) throws InvalidSettingException {
        try {
            return Long.parseLong(this.getString(key));
        }
        catch (NumberFormatException ex) {
            throw new InvalidSettingException("Could not convert property '" + key + "' to a long.", ex);
        }
    }

    public boolean getBoolean(@NotNull String key) throws InvalidSettingException {
        return Boolean.parseBoolean(this.getString(key));
    }

    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getString(key, Boolean.toString(defaultValue)));
    }

    public float getFloat(@NotNull String key, float defaultValue) {
        float retValue = defaultValue;
        try {
            retValue = Float.parseFloat(this.getString(key));
        }
        catch (Throwable ex) {
            LOGGER.trace("ignore", ex);
        }
        return retValue;
    }

    public String getConnectionString(String connectionStringKey, String dbFileNameKey) throws IOException, InvalidSettingException {
        String connStr = this.getString(connectionStringKey);
        if (connStr == null) {
            String msg = String.format("Invalid properties file; %s is missing.", connectionStringKey);
            throw new InvalidSettingException(msg);
        }
        if (connStr.contains("%s")) {
            File directory = this.getH2DataDirectory();
            LOGGER.debug("Data directory: {}", (Object)directory);
            String fileName = null;
            if (dbFileNameKey != null) {
                fileName = this.getString(dbFileNameKey);
            }
            if (fileName == null) {
                String msg = String.format("Invalid properties file to get a file based connection string; '%s' must be defined.", dbFileNameKey);
                throw new InvalidSettingException(msg);
            }
            if (connStr.startsWith("jdbc:h2:file:") && fileName.endsWith(".mv.db")) {
                fileName = fileName.substring(0, fileName.length() - 6);
            }
            File dbFile = new File(directory, fileName);
            String cString = String.format(connStr, dbFile.getCanonicalPath());
            LOGGER.debug("Connection String: '{}'", (Object)cString);
            return cString;
        }
        return connStr;
    }

    public File getDataDirectory() throws IOException {
        File path = this.getDataFile("data.directory");
        if (path != null && (path.exists() || path.mkdirs())) {
            return path;
        }
        throw new IOException(String.format("Unable to create the data directory '%s'", path == null ? "unknown" : path.getAbsolutePath()));
    }

    public File getH2DataDirectory() throws IOException {
        String h2Test = this.getString("data.h2.directory");
        File path = h2Test != null && !h2Test.isEmpty() ? this.getDataFile("data.h2.directory") : this.getDataFile("data.directory");
        if (path != null && (path.exists() || path.mkdirs())) {
            return path;
        }
        throw new IOException(String.format("Unable to create the h2 data directory '%s'", path == null ? "unknown" : path.getAbsolutePath()));
    }

    public File getTempFile(@NotNull String prefix, @NotNull String extension) throws IOException {
        File dir = this.getTempDirectory();
        String tempFileName = String.format("%s%s.%s", prefix, UUID.randomUUID().toString(), extension);
        File tempFile = new File(dir, tempFileName);
        if (tempFile.exists()) {
            return this.getTempFile(prefix, extension);
        }
        return tempFile;
    }

    public static final class KEYS {
        public static final String APPLICATION_NAME = "odc.application.name";
        public static final String APPLICATION_VERSION = "odc.application.version";
        public static final String ENGINE_VERSION_CHECK_URL = "engine.version.url";
        public static final String AUTO_UPDATE = "odc.autoupdate";
        public static final String DB_DRIVER_NAME = "data.driver_name";
        public static final String DB_DRIVER_PATH = "data.driver_path";
        public static final String DB_CONNECTION_STRING = "data.connection_string";
        public static final String DB_USER = "data.user";
        public static final String DB_PASSWORD = "data.password";
        public static final String DATA_DIRECTORY = "data.directory";
        public static final String H2_DATA_DIRECTORY = "data.h2.directory";
        public static final String DB_FILE_NAME = "data.file_name";
        public static final String DB_VERSION = "data.version";
        public static final String CVE_CPE_STARTS_WITH_FILTER = "cve.cpe.startswith.filter";
        public static final String CVE_MODIFIED_JSON = "cve.url.modified";
        public static final String CVE_ORIGINAL_JSON = "cve.url.original";
        public static final String CVE_BASE_JSON = "cve.url.base";
        public static final String CVE_MODIFIED_VALID_FOR_DAYS = "cve.url.modified.validfordays";
        public static final String CVE_CHECK_VALID_FOR_HOURS = "cve.check.validforhours";
        public static final String CVE_START_YEAR = "cve.startyear";
        public static final String CPE_MODIFIED_VALID_FOR_DAYS = "cpe.validfordays";
        public static final String CPE_URL = "cpe.url";
        public static final String PROXY_DISABLE_SCHEMAS = "proxy.disableSchemas";
        public static final String PROXY_SERVER = "proxy.server";
        public static final String PROXY_PORT = "proxy.port";
        public static final String PROXY_USERNAME = "proxy.username";
        public static final String PROXY_PASSWORD = "proxy.password";
        public static final String PROXY_NON_PROXY_HOSTS = "proxy.nonproxyhosts";
        public static final String CONNECTION_TIMEOUT = "connection.timeout";
        public static final String TEMP_DIRECTORY = "temp.directory";
        public static final String MAX_DOWNLOAD_THREAD_POOL_SIZE = "max.download.threads";
        public static final String ANALYSIS_TIMEOUT = "odc.analysis.timeout";
        public static final String SUPPRESSION_FILE = "suppression.file";
        public static final String HINTS_FILE = "hints.file";
        public static final String JUNIT_FAIL_ON_CVSS = "junit.fail.on.cvss";
        public static final String ANALYZER_JAR_ENABLED = "analyzer.jar.enabled";
        public static final String ANALYZER_EXPERIMENTAL_ENABLED = "analyzer.experimental.enabled";
        public static final String ANALYZER_RETIRED_ENABLED = "analyzer.retired.enabled";
        public static final String ANALYZER_ARCHIVE_ENABLED = "analyzer.archive.enabled";
        public static final String ANALYZER_NODE_PACKAGE_ENABLED = "analyzer.node.package.enabled";
        public static final String ANALYZER_NODE_AUDIT_ENABLED = "analyzer.node.audit.enabled";
        public static final String ANALYZER_NODE_AUDIT_URL = "analyzer.node.audit.url";
        public static final String ANALYZER_NODE_AUDIT_SKIPDEV = "analyzer.node.audit.skipdev";
        public static final String ANALYZER_NODE_AUDIT_USE_CACHE = "analyzer.node.audit.use.cache";
        public static final String ANALYZER_RETIREJS_ENABLED = "analyzer.retirejs.enabled";
        public static final String ANALYZER_RETIREJS_FILTERS = "analyzer.retirejs.filters";
        public static final String ANALYZER_RETIREJS_FILTER_NON_VULNERABLE = "analyzer.retirejs.filternonvulnerable";
        public static final String ANALYZER_RETIREJS_REPO_JS_URL = "analyzer.retirejs.repo.js.url";
        public static final String ANALYZER_RETIREJS_FORCEUPDATE = "analyzer.retirejs.forceupdate";
        public static final String ANALYZER_RETIREJS_REPO_VALID_FOR_HOURS = "analyzer.retirejs.repo.validforhours";
        public static final String ANALYZER_COMPOSER_LOCK_ENABLED = "analyzer.composer.lock.enabled";
        public static final String ANALYZER_PYTHON_DISTRIBUTION_ENABLED = "analyzer.python.distribution.enabled";
        public static final String ANALYZER_PYTHON_PACKAGE_ENABLED = "analyzer.python.package.enabled";
        public static final String ANALYZER_GOLANG_MOD_ENABLED = "analyzer.golang.mod.enabled";
        public static final String ANALYZER_GOLANG_PATH = "analyzer.golang.path";
        public static final String ANALYZER_GOLANG_DEP_ENABLED = "analyzer.golang.dep.enabled";
        public static final String ANALYZER_RUBY_GEMSPEC_ENABLED = "analyzer.ruby.gemspec.enabled";
        public static final String ANALYZER_AUTOCONF_ENABLED = "analyzer.autoconf.enabled";
        public static final String ANALYZER_CMAKE_ENABLED = "analyzer.cmake.enabled";
        public static final String ANALYZER_BUNDLE_AUDIT_ENABLED = "analyzer.bundle.audit.enabled";
        public static final String ANALYZER_ASSEMBLY_ENABLED = "analyzer.assembly.enabled";
        public static final String ANALYZER_NUSPEC_ENABLED = "analyzer.nuspec.enabled";
        public static final String ANALYZER_NUGETCONF_ENABLED = "analyzer.nugetconf.enabled";
        public static final String ANALYZER_MSBUILD_PROJECT_ENABLED = "analyzer.msbuildproject.enabled";
        public static final String ANALYZER_NEXUS_ENABLED = "analyzer.nexus.enabled";
        public static final String ANALYZER_NEXUS_URL = "analyzer.nexus.url";
        public static final String ANALYZER_NEXUS_USER = "analyzer.nexus.username";
        public static final String ANALYZER_NEXUS_PASSWORD = "analyzer.nexus.password";
        public static final String ANALYZER_NEXUS_USES_PROXY = "analyzer.nexus.proxy";
        public static final String ANALYZER_ARTIFACTORY_ENABLED = "analyzer.artifactory.enabled";
        public static final String ANALYZER_ARTIFACTORY_URL = "analyzer.artifactory.url";
        public static final String ANALYZER_ARTIFACTORY_API_USERNAME = "analyzer.artifactory.api.username";
        public static final String ANALYZER_ARTIFACTORY_API_TOKEN = "analyzer.artifactory.api.token";
        public static final String ANALYZER_ARTIFACTORY_BEARER_TOKEN = "analyzer.artifactory.bearer.token";
        public static final String ANALYZER_ARTIFACTORY_USES_PROXY = "analyzer.artifactory.proxy";
        public static final String ANALYZER_ARTIFACTORY_PARALLEL_ANALYSIS = "analyzer.artifactory.parallel.analysis";
        public static final String ANALYZER_CENTRAL_ENABLED = "analyzer.central.enabled";
        public static final String CENTRAL_CONTENT_URL = "central.content.url";
        public static final String ANALYZER_CENTRAL_PARALLEL_ANALYSIS = "analyzer.central.parallel.analysis";
        public static final String ANALYZER_CENTRAL_RETRY_COUNT = "analyzer.central.retry.count";
        public static final String ANALYZER_OPENSSL_ENABLED = "analyzer.openssl.enabled";
        public static final String ANALYZER_COCOAPODS_ENABLED = "analyzer.cocoapods.enabled";
        public static final String ANALYZER_SWIFT_PACKAGE_MANAGER_ENABLED = "analyzer.swift.package.manager.enabled";
        public static final String ANALYZER_CENTRAL_URL = "analyzer.central.url";
        public static final String ANALYZER_CENTRAL_QUERY = "analyzer.central.query";
        public static final String ANALYZER_CENTRAL_USE_CACHE = "analyzer.central.use.cache";
        public static final String ANALYZER_ASSEMBLY_DOTNET_PATH = "analyzer.assembly.dotnet.path";
        public static final String ANALYZER_BUNDLE_AUDIT_PATH = "analyzer.bundle.audit.path";
        public static final String ANALYZER_BUNDLE_AUDIT_WORKING_DIRECTORY = "analyzer.bundle.audit.working.directory";
        public static final String ADDITIONAL_ZIP_EXTENSIONS = "extensions.zip";
        public static final String VFEED_DATA_FILE = "vfeed.data_file";
        public static final String VFEED_CONNECTION_STRING = "vfeed.connection_string";
        public static final String VFEED_DOWNLOAD_URL = "vfeed.download_url";
        public static final String VFEED_DOWNLOAD_FILE = "vfeed.download_file";
        public static final String VFEED_UPDATE_STATUS = "vfeed.update_status";
        public static final String DOWNLOADER_QUICK_QUERY_TIMESTAMP = "downloader.quick.query.timestamp";
        public static final String DOWNLOADER_TLS_PROTOCOL_LIST = "downloader.tls.protocols";
        public static final String ANALYZER_CPE_ENABLED = "analyzer.cpe.enabled";
        public static final String ANALYZER_NPM_CPE_ENABLED = "analyzer.npm.cpe.enabled";
        public static final String ANALYZER_CPE_SUPPRESSION_ENABLED = "analyzer.cpesuppression.enabled";
        public static final String ANALYZER_DEPENDENCY_BUNDLING_ENABLED = "analyzer.dependencybundling.enabled";
        public static final String ANALYZER_DEPENDENCY_MERGING_ENABLED = "analyzer.dependencymerging.enabled";
        public static final String ANALYZER_FALSE_POSITIVE_ENABLED = "analyzer.falsepositive.enabled";
        public static final String ANALYZER_FILE_NAME_ENABLED = "analyzer.filename.enabled";
        public static final String ANALYZER_PE_ENABLED = "analyzer.pe.enabled";
        public static final String ANALYZER_HINT_ENABLED = "analyzer.hint.enabled";
        public static final String ANALYZER_VERSION_FILTER_ENABLED = "analyzer.versionfilter.enabled";
        public static final String ANALYZER_NVD_CVE_ENABLED = "analyzer.nvdcve.enabled";
        public static final String ANALYZER_VULNERABILITY_SUPPRESSION_ENABLED = "analyzer.vulnerabilitysuppression.enabled";
        public static final String UPDATE_NVDCVE_ENABLED = "updater.nvdcve.enabled";
        public static final String UPDATE_VERSION_CHECK_ENABLED = "updater.versioncheck.enabled";
        public static final String ECOSYSTEM_SKIP_CPEANALYZER = "ecosystem.skip.cpeanalyzer";
        public static final String ENABLE_BATCH_UPDATES = "database.batchinsert.enabled";
        public static final String MAX_BATCH_SIZE = "database.batchinsert.maxsize";
        public static final String H2DB_SHUTDOWN_HOOK = "data.h2.shutdownhook";
        public static final String ANALYZER_OSSINDEX_ENABLED = "analyzer.ossindex.enabled";
        public static final String ANALYZER_OSSINDEX_USE_CACHE = "analyzer.ossindex.use.cache";
        public static final String ANALYZER_OSSINDEX_URL = "analyzer.ossindex.url";
        public static final String ANALYZER_OSSINDEX_USER = "analyzer.ossindex.user";
        public static final String ANALYZER_OSSINDEX_PASSWORD = "analyzer.ossindex.password";
        public static final String PRETTY_PRINT = "odc.reports.pretty.print";
        public static final String MASKED_PROPERTIES = "odc.settings.mask";
        public static final String NVD_NEW_YEAR_GRACE_PERIOD = "nvd.newyear.grace.period";

        private KEYS() {
        }
    }
}

