/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CliParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CliParser.class);
    private CommandLine line;
    private boolean isValid = true;
    private final Settings settings;
    private static final String SUPPORTED_FORMATS = "HTML, XML, CSV, JSON, JUNIT, SARIF, or ALL";

    public CliParser(Settings settings) {
        this.settings = settings;
    }

    public void parse(String[] args) throws FileNotFoundException, ParseException {
        this.line = this.parseArgs(args);
        if (this.line != null) {
            this.validateArgs();
        }
    }

    private CommandLine parseArgs(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        Options options = this.createCommandLineOptions();
        return parser.parse(options, args);
    }

    private void validateArgs() throws FileNotFoundException, ParseException {
        if (this.isUpdateOnly() || this.isRunScan()) {
            int i;
            String value = this.line.getOptionValue("cveValidForHours");
            if (value != null) {
                try {
                    i = Integer.parseInt(value);
                    if (i < 0) {
                        throw new ParseException("Invalid Setting: cveValidForHours must be a number greater than or equal to 0.");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Invalid Setting: cveValidForHours must be a number greater than or equal to 0.");
                }
            }
            if ((value = this.line.getOptionValue("cveStartYear")) != null) {
                try {
                    i = Integer.parseInt(value);
                    if (i < 2002) {
                        throw new ParseException("Invalid Setting: cveStartYear must be a number greater than or equal to 2002.");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Invalid Setting: cveStartYear must be a number greater than or equal to 2002.");
                }
            }
        }
        if (this.isRunScan()) {
            this.validatePathExists(this.getScanFiles(), "scan");
            this.validatePathExists(this.getReportDirectory(), "out");
            String pathToCore = this.getStringArgument("dotnet");
            if (pathToCore != null) {
                this.validatePathExists(pathToCore, "dotnet");
            }
            if (this.line.hasOption("format")) {
                String validating = null;
                try {
                    String[] stringArray = this.getReportFormat();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String format;
                        validating = format = stringArray[i];
                        ReportGenerator.Format.valueOf((String)format);
                    }
                }
                catch (IllegalArgumentException ex) {
                    String msg = String.format("An invalid 'format' of '%s' was specified. Supported output formats are HTML, XML, CSV, JSON, JUNIT, SARIF, or ALL", validating);
                    throw new ParseException(msg);
                }
            }
            String base = this.getStringArgument("cveUrlBase");
            String modified = this.getStringArgument("cveUrlModified");
            if (base != null && modified == null || base == null && modified != null) {
                String msg = "If one of the CVE URLs is specified they must all be specified; please add the missing CVE URL.";
                throw new ParseException("If one of the CVE URLs is specified they must all be specified; please add the missing CVE URL.");
            }
            if (this.line.hasOption("symLink")) {
                try {
                    int i = Integer.parseInt(this.line.getOptionValue("symLink"));
                    if (i < 0) {
                        throw new ParseException("Symbolic Link Depth (symLink) must be greater than zero.");
                    }
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Symbolic Link Depth (symLink) is not a number.");
                }
            }
        }
    }

    private void validatePathExists(String[] paths, String optType) throws FileNotFoundException {
        for (String path : paths) {
            this.validatePathExists(path, optType);
        }
    }

    private void validatePathExists(String path, String argumentName) throws FileNotFoundException {
        if (path == null) {
            this.isValid = false;
            String msg = String.format("Invalid '%s' argument: null", argumentName);
            throw new FileNotFoundException(msg);
        }
        if (!path.contains("*") && !path.contains("?")) {
            File f = new File(path);
            String[] formats = this.getReportFormat();
            if ("o".equalsIgnoreCase(argumentName.substring(0, 1)) && formats.length == 1 && !"ALL".equalsIgnoreCase(formats[0])) {
                String checkPath = path.toLowerCase();
                if (checkPath.endsWith(".html") || checkPath.endsWith(".xml") || checkPath.endsWith(".htm") || checkPath.endsWith(".csv") || checkPath.endsWith(".json")) {
                    if (f.getParentFile() == null) {
                        f = new File(".", path);
                    }
                    if (!f.getParentFile().isDirectory()) {
                        this.isValid = false;
                        String msg = String.format("Invalid '%s' argument: '%s' - directory path does not exist", argumentName, path);
                        throw new FileNotFoundException(msg);
                    }
                }
            } else if ("o".equalsIgnoreCase(argumentName.substring(0, 1)) && !f.isDirectory()) {
                if (f.getParentFile() != null && f.getParentFile().isDirectory() && !f.mkdir()) {
                    this.isValid = false;
                    String msg = String.format("Invalid '%s' argument: '%s' - unable to create the output directory", argumentName, path);
                    throw new FileNotFoundException(msg);
                }
                if (!f.isDirectory()) {
                    this.isValid = false;
                    String msg = String.format("Invalid '%s' argument: '%s' - path does not exist", argumentName, path);
                    throw new FileNotFoundException(msg);
                }
            } else if (!f.exists()) {
                this.isValid = false;
                String msg = String.format("Invalid '%s' argument: '%s' - path does not exist", argumentName, path);
                throw new FileNotFoundException(msg);
            }
        } else if (path.endsWith("/*") && !path.endsWith("**/*") || path.endsWith("\\*") && path.endsWith("**\\*")) {
            LOGGER.warn("Possibly incorrect path '{}' from argument '{}' because it ends with a slash star; dependency-check uses ant-style paths", (Object)path, (Object)argumentName);
        }
    }

    private Options createCommandLineOptions() {
        Options options = new Options();
        this.addStandardOptions(options);
        this.addAdvancedOptions(options);
        return options;
    }

    private void addStandardOptions(Options options) {
        options.addOptionGroup(this.newOptionGroup(this.newOptionWithArg("s", "scan", "path", "The path to scan - this option can be specified multiple times. Ant style paths are supported (e.g. 'path/**/*.jar'); if using Ant style paths it is highly recommended to quote the argument value."))).addOptionGroup(this.newOptionGroup(this.newOptionWithArg("exclude", "pattern", "Specify an exclusion pattern. This option can be specified multiple times and it accepts Ant style exclusions."))).addOption(this.newOptionWithArg("project", "name", "The name of the project being scanned.")).addOption(this.newOptionWithArg("o", "out", "path", "The folder to write reports to. This defaults to the current directory. It is possible to set this to a specific file name if the format argument is not set to ALL.")).addOption(this.newOptionWithArg("f", "format", "format", "The report format (HTML, XML, CSV, JSON, JUNIT, SARIF, or ALL). The default is HTML. Multiple format parameters can be specified.")).addOption(this.newOption("prettyPrint", "When specified the JSON and XML report formats will be pretty printed.")).addOption(this.newOption("v", "version", "Print the version information.")).addOption(this.newOption("h", "help", "Print this message.")).addOption(this.newOption("advancedHelp", "Print the advanced help message.")).addOption(this.newOption("n", "noupdate", "Disables the automatic updating of the CPE data.")).addOption(this.newOptionWithArg("l", "log", "file", "The file path to write verbose logging information.")).addOptionGroup(this.newOptionGroup(this.newOptionWithArg("suppression", "file", "The file path to the suppression XML file. This can be specified more then once to utilize multiple suppression files"))).addOption(this.newOption("enableExperimental", "Enables the experimental analyzers.")).addOption(this.newOptionWithArg("failOnCVSS", "score", "Specifies if the build should be failed if a CVSS score above a specified level is identified. The default is 11; since the CVSS scores are 0-10, by default the build will never fail.")).addOption(this.newOptionWithArg("junitFailOnCVSS", "score", "Specifies the CVSS score that is considered a failure when generating the junit report. The default is 0."));
    }

    private void addAdvancedOptions(Options options) {
        options.addOption(this.newOption("updateonly", "Only update the local NVD data cache; no scan will be executed.")).addOption(this.newOptionWithArg("cveUrlBase", "url", "Base URL for each year\u2019s CVE files (json.gz), the %d will be replaced with the year.")).addOption(this.newOptionWithArg("cveUrlModified", "url", "URL for the modified CVE (json.gz).")).addOption(this.newOptionWithArg("cveDownloadWait", "milliseconds", "Time in milliseconds to wait between downloading from the NVD.")).addOption(this.newOptionWithArg("cveUser", "user", "Credentials for basic authentication to the CVE data.")).addOption(this.newOptionWithArg("cvePassword", "password", "Credentials for basic authentication to the CVE data.")).addOption(this.newOptionWithArg("proxyport", "port", "The proxy port to use when downloading resources.")).addOption(this.newOptionWithArg("proxyserver", "server", "The proxy server to use when downloading resources.")).addOption(this.newOptionWithArg("proxyuser", "user", "The proxy username to use when downloading resources.")).addOption(this.newOptionWithArg("proxypass", "pass", "The proxy password to use when downloading resources.")).addOption(this.newOptionWithArg("nonProxyHosts", "list", "The proxy exclusion list: hostnames (or patterns) for which proxy should not be used. Use pipe, comma or colon as list separator.")).addOption(this.newOptionWithArg("c", "connectiontimeout", "timeout", "The connection timeout (in milliseconds) to use when downloading resources.")).addOption(this.newOptionWithArg("connectionString", "connStr", "The connection string to the database.")).addOption(this.newOptionWithArg("dbUser", "user", "The username used to connect to the database.")).addOption(this.newOptionWithArg("d", "data", "path", "The location of the H2 Database file. This option should generally not be set.")).addOption(this.newOptionWithArg("dbPassword", "password", "The password for connecting to the database.")).addOption(this.newOptionWithArg("dbDriverName", "driver", "The database driver name.")).addOption(this.newOptionWithArg("dbDriverPath", "path", "The path to the database driver; note, this does not need to be set unless the JAR is outside of the classpath.")).addOption(this.newOptionWithArg("symLink", "depth", "Sets how deep nested symbolic links will be followed; 0 indicates symbolic links will not be followed.")).addOption(this.newOptionWithArg("bundleAudit", "path", "The path to bundle-audit for Gem bundle analysis.")).addOption(this.newOptionWithArg("bundleAuditWorkingDirectory", "path", "The path to working directory that the bundle-audit command should be executed from when doing Gem bundle analysis.")).addOption(this.newOptionWithArg("ossIndexUsername", "username", "The username to authenticate to Sonatype's OSS Index. If not set the Sonatype OSS Index Analyzer will use an unauthenticated connection.")).addOption(this.newOptionWithArg("ossIndexPassword", "password", "The password to authenticate to Sonatype's OSS Index. If not set the Sonatype OSS Index Analyzer will use an unauthenticated connection.")).addOption(this.newOption("retireJsForceUpdate", "Force the RetireJS Analyzer to update even if autoupdate is disabled")).addOption(this.newOptionWithArg("retireJsUrl", "url", "The Retire JS Respository URL")).addOption(this.newOption("retirejsFilterNonVulnerable", "Specifies that the Retire JS Analyzer should filter out non-vulnerable JS files from the report.")).addOption(this.newOptionWithArg("artifactoryParallelAnalysis", "true/false", "Whether the Artifactory Analyzer should use parallel analysis.")).addOption(this.newOptionWithArg("artifactoryUseProxy", "true/false", "Whether the Artifactory Analyzer should use the proxy.")).addOption(this.newOptionWithArg("artifactoryUsername", "username", "The Artifactory username for authentication.")).addOption(this.newOptionWithArg("artifactoryApiToken", "token", "The Artifactory API token.")).addOption(this.newOptionWithArg("artifactoryBearerToken", "token", "The Artifactory bearer token.")).addOption(this.newOptionWithArg("artifactoryUrl", "url", "The Artifactory URL.")).addOption(this.newOptionWithArg("go", "path", "The path to the `go` executable.")).addOption(this.newOptionWithArg("yarn", "path", "The path to the `yarn` executable.")).addOption(this.newOptionWithArg("cveValidForHours", "hours", "The number of hours to wait before checking for new updates from the NVD.")).addOption(this.newOptionWithArg("cveStartYear", "year", "The first year to retrieve NVD CVE data for; default is 2002.")).addOption(this.newOptionWithArg("retirejsFilter", "pattern", "Specify Retire JS content filter used to exclude files from analysis based on their content; most commonly used to exclude based on your applications own copyright line. This option can be specified multiple times.")).addOption(this.newOptionWithArg("nexus", "url", "The url to the Nexus Server's REST API Endpoint (http://domain/nexus/service/local). If not set the Nexus Analyzer will be disabled.")).addOption(this.newOptionWithArg("nexusUser", "username", "The username to authenticate to the Nexus Server's REST API Endpoint. If not set the Nexus Analyzer will use an unauthenticated connection.")).addOption(this.newOptionWithArg("nexusPass", "password", "The password to authenticate to the Nexus Server's REST API Endpoint. If not set the Nexus Analyzer will use an unauthenticated connection.")).addOption(this.newOptionWithArg("nexusUsesProxy", "true/false", "Whether or not the configured proxy should be used when connecting to Nexus.")).addOption(this.newOptionWithArg("zipExtensions", "extensions", "A comma separated list of additional extensions to be scanned as ZIP files (ZIP, EAR, WAR are already treated as zip files)")).addOption(this.newOptionWithArg("P", "propertyfile", "file", "A property file to load.")).addOption(this.newOptionWithArg("dotnet", "path", "The path to dotnet core.")).addOption(this.newOptionWithArg("hints", "file", "The file path to the hints XML file.")).addOption(this.newOption("enableRetired", "Enables the retired analyzers.")).addOption(this.newOption("disableMSBuild", "Disable the MS Build Analyzer.")).addOption(this.newOption("disableJar", "Disable the Jar Analyzer.")).addOption(this.newOption("disableArchive", "Disable the Archive Analyzer.")).addOption(this.newOption("disableAssembly", "Disable the .NET Assembly Analyzer.")).addOption(this.newOption("disablePyDist", "Disable the Python Distribution Analyzer.")).addOption(this.newOption("disableCmake", "Disable the Cmake Analyzer.")).addOption(this.newOption("disablePyPkg", "Disable the Python Package Analyzer.")).addOption(this.newOption("disableMixAudit", "Disable the Elixir mix_audit Analyzer.")).addOption(this.newOption("disableRubygems", "Disable the Ruby Gemspec Analyzer.")).addOption(this.newOption("disableBundleAudit", "Disable the Ruby Bundler-Audit Analyzer.")).addOption(this.newOption("disableFileName", "Disable the File Name Analyzer.")).addOption(this.newOption("disableAutoconf", "Disable the Autoconf Analyzer.")).addOption(this.newOption("disablePip", "Disable the pip Analyzer.")).addOption(this.newOption("disablePipfile", "Disable the Pipfile Analyzer.")).addOption(this.newOption("disableComposer", "Disable the PHP Composer Analyzer.")).addOption(this.newOption("disableCpan", "Disable the Perl CPAN file Analyzer.")).addOption(this.newOption("disableGolangMod", "Disable the Golang Mod Analyzer.")).addOption(this.newOption("disableOpenSSL", "Disable the OpenSSL Analyzer.")).addOption(this.newOption("disableNuspec", "Disable the Nuspec Analyzer.")).addOption(this.newOption("disableNugetconf", "Disable the Nuget packages.config Analyzer.")).addOption(this.newOption("disableCentral", "Disable the Central Analyzer. If this analyzer is disabled it is likely you also want to disable the Nexus Analyzer.")).addOption(this.newOption("disableCentralCache", "Disallow the Central Analyzer from caching results")).addOption(this.newOption("disableOssIndex", "Disable the Sonatype OSS Index Analyzer.")).addOption(this.newOption("disableOssIndexCache", "Disallow the OSS Index Analyzer from caching results")).addOption(this.newOption("disableCocoapodsAnalyzer", "Disable the CocoaPods Analyzer.")).addOption(this.newOption("disableSwiftPackageManagerAnalyzer", "Disable the swift package Analyzer.")).addOption(this.newOption("disableSwiftPackageResolvedAnalyzer", "Disable the swift package resolved Analyzer.")).addOption(this.newOption("disableGolangDep", "Disable the Golang Package Analyzer.")).addOption(this.newOption("disableNodeJS", "Disable the Node.js Package Analyzer.")).addOption(this.newOption("nodePackageSkipDevDependencies", "Configures the Node Package Analyzer to skip devDependencies")).addOption(this.newOption("disableNodeAudit", "Disable the Node Audit Analyzer.")).addOption(this.newOption("disableYarnAudit", "Disable the Yarn Audit Analyzer.")).addOption(this.newOption("disableNodeAuditCache", "Disallow the Node Audit Analyzer from caching results")).addOption(this.newOption("nodeAuditSkipDevDependencies", "Configures the Node Audit Analyzer to skip devDependencies")).addOption(this.newOption("disableRetireJS", "Disable the RetireJS Analyzer.")).addOption(this.newOption("enableNexus", "Disable the Nexus Analyzer.")).addOption(this.newOption("enableArtifactory", "Whether the Artifactory Analyzer should be enabled.")).addOption(this.newOption("purge", "Purges the local NVD data cache"));
    }

    public boolean isGetVersion() {
        return this.line != null && this.line.hasOption("version");
    }

    public boolean isGetHelp() {
        return this.line != null && this.line.hasOption("help");
    }

    public boolean isRunScan() {
        return this.line != null && this.isValid && this.line.hasOption("scan");
    }

    public int getSymLinkDepth() {
        int value = 0;
        try {
            value = Integer.parseInt(this.line.getOptionValue("symLink", "0"));
            if (value < 0) {
                value = 0;
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.debug("Symbolic link was not a number");
        }
        return value;
    }

    public boolean hasDisableOption(String argument, String setting) {
        if (this.line == null || !this.line.hasOption(argument)) {
            try {
                return !this.settings.getBoolean(setting);
            }
            catch (InvalidSettingException ise) {
                LOGGER.warn("Invalid property setting '{}' defaulting to false", (Object)setting);
                return false;
            }
        }
        return true;
    }

    public boolean isNodeAuditDisabled() {
        if (this.hasDisableOption("disableNSP", "analyzer.node.audit.enabled")) {
            LOGGER.error("The disableNSP argument has been deprecated and replaced by disableNodeAudit");
            LOGGER.error("The disableNSP argument will be removed in the next version");
            return true;
        }
        return this.hasDisableOption("disableNodeAudit", "analyzer.node.audit.enabled");
    }

    public boolean isYarnAuditDisabled() {
        return this.hasDisableOption("disableYarnAudit", "analyzer.yarn.audit.enabled");
    }

    public boolean isPnpmAuditDisabled() {
        return this.hasDisableOption("disablePnpmAudit", "analyzer.pnpm.audit.enabled");
    }

    public boolean isNexusUsesProxy() {
        if (this.line == null || !this.line.hasOption("nexusUsesProxy")) {
            try {
                return this.settings.getBoolean("analyzer.nexus.proxy");
            }
            catch (InvalidSettingException ise) {
                return true;
            }
        }
        return Boolean.parseBoolean(this.line.getOptionValue("nexusUsesProxy"));
    }

    @SuppressFBWarnings(justification="Accepting that this is a bad practice - used a Boolean as we needed three states", value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean getBooleanArgument(String argument) {
        String value;
        if (this.line != null && this.line.hasOption(argument) && (value = this.line.getOptionValue(argument)) != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public String getStringArgument(String option) {
        return this.getStringArgument(option, null);
    }

    public String getStringArgument(String option, String key) {
        if (this.line != null && this.line.hasOption(option)) {
            if (key != null && (option.toLowerCase().endsWith("password") || option.toLowerCase().endsWith("pass"))) {
                LOGGER.warn("{} used on the command line, consider moving the password to a properties file using the key `{}` and using the --propertyfile argument instead", (Object)option, (Object)key);
            }
            return this.line.getOptionValue(option);
        }
        return null;
    }

    public String[] getStringArguments(String option) {
        if (this.line != null && this.line.hasOption(option)) {
            return this.line.getOptionValues(option);
        }
        return null;
    }

    public File getFileArgument(String option) {
        String path = this.line.getOptionValue(option);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        Options options = new Options();
        this.addStandardOptions(options);
        if (this.line != null && this.line.hasOption("advancedHelp")) {
            this.addAdvancedOptions(options);
        }
        String helpMsg = String.format("%n%s can be used to identify if there are any known CVE vulnerabilities in libraries utilized by an application. %s will automatically update required data from the Internet, such as the CVE and CPE data files from nvd.nist.gov.%n%n", this.settings.getString("odc.application.name", "DependencyCheck"), this.settings.getString("odc.application.name", "DependencyCheck"));
        formatter.printHelp(this.settings.getString("odc.application.name", "DependencyCheck"), helpMsg, options, "", true);
    }

    public String[] getScanFiles() {
        return this.line.getOptionValues("scan");
    }

    public String[] getExcludeList() {
        return this.line.getOptionValues("exclude");
    }

    public String[] getRetireJsFilters() {
        return this.line.getOptionValues("retirejsFilter");
    }

    @SuppressFBWarnings(justification="Accepting that this is a bad practice - but made more sense in this use case", value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean isRetireJsFilterNonVulnerable() {
        return this.line != null && this.line.hasOption("retirejsFilterNonVulnerable") ? Boolean.valueOf(true) : null;
    }

    public String getReportDirectory() {
        return this.line.getOptionValue("out", ".");
    }

    public String[] getReportFormat() {
        if (this.line.hasOption("format")) {
            return this.line.getOptionValues("format");
        }
        return new String[]{"HTML"};
    }

    public String getProjectName() {
        String name = this.line.getOptionValue("project");
        if (name == null) {
            name = "";
        }
        return name;
    }

    public void printVersionInfo() {
        String version = String.format("%s version %s", this.settings.getString("odc.application.name", "dependency-check"), this.settings.getString("odc.application.version", "Unknown"));
        System.out.println(version);
    }

    public boolean isUpdateOnly() {
        return this.line != null && this.line.hasOption("updateonly");
    }

    public boolean isPurge() {
        return this.line != null && this.line.hasOption("purge");
    }

    public String getDatabaseDriverName() {
        return this.line.getOptionValue("dbDriverName");
    }

    public Integer getIntegerValue(String argument) {
        String v = this.line.getOptionValue(argument);
        if (v != null) {
            return Integer.parseInt(v);
        }
        return null;
    }

    @SuppressFBWarnings(justification="Accepting that this is a bad practice - but made more sense in this use case", value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean hasOption(String option) {
        return this.line != null && this.line.hasOption(option) ? Boolean.valueOf(true) : null;
    }

    public float getFailOnCVSS() {
        if (this.line.hasOption("failOnCVSS")) {
            String value = this.line.getOptionValue("failOnCVSS");
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                return 11.0f;
            }
        }
        return 11.0f;
    }

    public float getFloatArgument(String option, float defaultValue) {
        if (this.line.hasOption(option)) {
            String value = this.line.getOptionValue(option);
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private Option newOption(String name, String description) {
        return Option.builder().longOpt(name).desc(description).build();
    }

    private Option newOption(String shortName, String name, String description) {
        return Option.builder((String)shortName).longOpt(name).desc(description).build();
    }

    private Option newOptionWithArg(String name, String arg, String description) {
        return Option.builder().longOpt(name).argName(arg).hasArg().desc(description).build();
    }

    private Option newOptionWithArg(String shortName, String name, String arg, String description) {
        return Option.builder((String)shortName).longOpt(name).argName(arg).hasArg().desc(description).build();
    }

    private OptionGroup newOptionGroup(Option option) {
        OptionGroup group = new OptionGroup();
        group.addOption(option);
        return group;
    }

    public static class ARGUMENT {
        public static final String SCAN = "scan";
        public static final String SCAN_SHORT = "s";
        public static final String DISABLE_AUTO_UPDATE = "noupdate";
        public static final String DISABLE_AUTO_UPDATE_SHORT = "n";
        public static final String UPDATE_ONLY = "updateonly";
        public static final String PURGE_NVD = "purge";
        public static final String OUT = "out";
        public static final String OUT_SHORT = "o";
        public static final String OUTPUT_FORMAT = "format";
        public static final String OUTPUT_FORMAT_SHORT = "f";
        public static final String PROJECT = "project";
        public static final String HELP = "help";
        public static final String ADVANCED_HELP = "advancedHelp";
        public static final String HELP_SHORT = "h";
        public static final String VERSION_SHORT = "v";
        public static final String VERSION = "version";
        public static final String PROXY_PORT = "proxyport";
        public static final String PROXY_SERVER = "proxyserver";
        public static final String PROXY_USERNAME = "proxyuser";
        public static final String PROXY_PASSWORD = "proxypass";
        public static final String NON_PROXY_HOSTS = "nonProxyHosts";
        public static final String CONNECTION_TIMEOUT_SHORT = "c";
        public static final String CONNECTION_TIMEOUT = "connectiontimeout";
        public static final String PROP_SHORT = "P";
        public static final String PROP = "propertyfile";
        public static final String DATA_DIRECTORY = "data";
        public static final String CVE_MODIFIED_URL = "cveUrlModified";
        public static final String CVE_BASE_URL = "cveUrlBase";
        public static final String CVE_DOWNLOAD_WAIT_TIME = "cveDownloadWait";
        public static final String DATA_DIRECTORY_SHORT = "d";
        public static final String VERBOSE_LOG = "log";
        public static final String VERBOSE_LOG_SHORT = "l";
        public static final String SYM_LINK_DEPTH = "symLink";
        public static final String SUPPRESSION_FILES = "suppression";
        public static final String HINTS_FILE = "hints";
        public static final String CVE_VALID_FOR_HOURS = "cveValidForHours";
        public static final String CVE_START_YEAR = "cveStartYear";
        public static final String CVE_USER = "cveUser";
        public static final String CVE_PASSWORD = "cvePassword";
        public static final String DISABLE_JAR = "disableJar";
        public static final String DISABLE_MSBUILD = "disableMSBuild";
        public static final String DISABLE_ARCHIVE = "disableArchive";
        public static final String DISABLE_PY_DIST = "disablePyDist";
        public static final String DISABLE_PY_PKG = "disablePyPkg";
        public static final String DISABLE_MIX_AUDIT = "disableMixAudit";
        public static final String DISABLE_GO_DEP = "disableGolangDep";
        public static final String DISABLE_COMPOSER = "disableComposer";
        public static final String DISABLE_CPAN = "disableCpan";
        public static final String DISABLE_GOLANG_MOD = "disableGolangMod";
        public static final String PATH_TO_GO = "go";
        public static final String PATH_TO_YARN = "yarn";
        public static final String PATH_TO_PNPM = "pnpm";
        public static final String DISABLE_RUBYGEMS = "disableRubygems";
        public static final String DISABLE_AUTOCONF = "disableAutoconf";
        public static final String DISABLE_PIP = "disablePip";
        public static final String DISABLE_PIPFILE = "disablePipfile";
        public static final String DISABLE_CMAKE = "disableCmake";
        public static final String DISABLE_COCOAPODS = "disableCocoapodsAnalyzer";
        public static final String DISABLE_SWIFT = "disableSwiftPackageManagerAnalyzer";
        public static final String DISABLE_SWIFT_RESOLVED = "disableSwiftPackageResolvedAnalyzer";
        public static final String DISABLE_ASSEMBLY = "disableAssembly";
        public static final String DISABLE_BUNDLE_AUDIT = "disableBundleAudit";
        public static final String DISABLE_FILENAME = "disableFileName";
        public static final String DISABLE_NUSPEC = "disableNuspec";
        public static final String DISABLE_NUGETCONF = "disableNugetconf";
        public static final String DISABLE_CENTRAL = "disableCentral";
        public static final String DISABLE_CENTRAL_CACHE = "disableCentralCache";
        public static final String ENABLE_NEXUS = "enableNexus";
        public static final String DISABLE_OSSINDEX = "disableOssIndex";
        public static final String DISABLE_OSSINDEX_CACHE = "disableOssIndexCache";
        public static final String OSSINDEX_USERNAME = "ossIndexUsername";
        public static final String OSSINDEX_PASSWORD = "ossIndexPassword";
        public static final String DISABLE_OPENSSL = "disableOpenSSL";
        public static final String DISABLE_NODE_JS = "disableNodeJS";
        public static final String NODE_PACKAGE_SKIP_DEV_DEPENDENCIES = "nodePackageSkipDevDependencies";
        public static final String DISABLE_NODE_AUDIT = "disableNodeAudit";
        public static final String DISABLE_YARN_AUDIT = "disableYarnAudit";
        public static final String DISABLE_PNPM_AUDIT = "disablePnpmAudit";
        public static final String DISABLE_NODE_AUDIT_CACHE = "disableNodeAuditCache";
        public static final String DISABLE_NODE_AUDIT_SKIPDEV = "nodeAuditSkipDevDependencies";
        public static final String DISABLE_RETIRE_JS = "disableRetireJS";
        public static final String RETIRE_JS_FORCEUPDATE = "retireJsForceUpdate";
        public static final String RETIREJS_URL = "retireJsUrl";
        public static final String NEXUS_URL = "nexus";
        public static final String NEXUS_USERNAME = "nexusUser";
        public static final String NEXUS_PASSWORD = "nexusPass";
        public static final String NEXUS_USES_PROXY = "nexusUsesProxy";
        public static final String CONNECTION_STRING = "connectionString";
        public static final String DB_NAME = "dbUser";
        public static final String DB_PASSWORD = "dbPassword";
        public static final String DB_DRIVER = "dbDriverName";
        public static final String DB_DRIVER_PATH = "dbDriverPath";
        public static final String PATH_TO_CORE = "dotnet";
        public static final String ADDITIONAL_ZIP_EXTENSIONS = "zipExtensions";
        public static final String EXCLUDE = "exclude";
        public static final String PATH_TO_BUNDLE_AUDIT = "bundleAudit";
        public static final String PATH_TO_BUNDLE_AUDIT_WORKING_DIRECTORY = "bundleAuditWorkingDirectory";
        public static final String PATH_TO_MIX_AUDIT = "mixAudit";
        public static final String EXPERIMENTAL = "enableExperimental";
        public static final String RETIRED = "enableRetired";
        public static final String RETIREJS_FILTERS = "retirejsFilter";
        public static final String RETIREJS_FILTER_NON_VULNERABLE = "retirejsFilterNonVulnerable";
        public static final String ARTIFACTORY_ENABLED = "enableArtifactory";
        public static final String ARTIFACTORY_URL = "artifactoryUrl";
        public static final String ARTIFACTORY_USERNAME = "artifactoryUsername";
        public static final String ARTIFACTORY_API_TOKEN = "artifactoryApiToken";
        public static final String ARTIFACTORY_BEARER_TOKEN = "artifactoryBearerToken";
        public static final String ARTIFACTORY_USES_PROXY = "artifactoryUseProxy";
        public static final String ARTIFACTORY_PARALLEL_ANALYSIS = "artifactoryParallelAnalysis";
        public static final String FAIL_ON_CVSS = "failOnCVSS";
        public static final String PRETTY_PRINT = "prettyPrint";
        public static final String FAIL_JUNIT_ON_CVSS = "junitFailOnCVSS";
    }
}

