/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Purge
extends Task {
    private static final String PROPERTIES_FILE = "task.properties";
    private Settings settings;
    private String dataDirectory = null;
    private boolean failOnError = true;

    public Purge() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.populateSettings();
        try (Engine engine = new Engine(Engine.Mode.EVIDENCE_PROCESSING, this.getSettings());){
            engine.purge();
        }
        finally {
            this.settings.cleanup(true);
        }
    }

    protected void populateSettings() throws BuildException {
        this.settings = new Settings();
        try (InputStream taskProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            this.settings.mergeProperties(taskProperties);
        }
        catch (IOException ex) {
            String msg = "Unable to load the dependency-check ant task.properties file.";
            if (this.failOnError) {
                throw new BuildException("Unable to load the dependency-check ant task.properties file.", (Throwable)ex);
            }
            this.log("Unable to load the dependency-check ant task.properties file.", ex, 1);
        }
        if (this.dataDirectory != null) {
            this.settings.setString("data.directory", this.dataDirectory);
        } else {
            File jarPath = new File(Purge.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = this.settings.getString("data.directory");
            File dataDir = new File(base, sub);
            this.settings.setString("data.directory", dataDir.getAbsolutePath());
        }
    }
}

