/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.impl.StaticLoggerBinder;

public class Purge
extends Task {
    private static final String PROPERTIES_FILE = "task.properties";
    private String dataDirectory = null;

    public Purge() {
        StaticLoggerBinder.getSingleton().setTask(this);
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public void execute() throws BuildException {
        this.populateSettings();
        try {
            File db = new File(Settings.getDataDirectory(), "dc.h2.db");
            if (db.exists()) {
                if (db.delete()) {
                    this.log("Database file purged; local copy of the NVD has been removed", 2);
                } else {
                    this.log(String.format("Unable to delete '%s'; please delete the file manually", db.getAbsolutePath()), 0);
                }
            } else {
                this.log(String.format("Unable to purge database; the database file does not exists: %s", db.getAbsolutePath()), 0);
            }
        }
        catch (IOException ex) {
            this.log("Unable to delete the database", 0);
        }
        finally {
            Settings.cleanup((boolean)true);
        }
    }

    protected void populateSettings() {
        Settings.initialize();
        InputStream taskProperties = null;
        try {
            taskProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Settings.mergeProperties((InputStream)taskProperties);
        }
        catch (IOException ex) {
            this.log("Unable to load the dependency-check ant task.properties file.", ex, 1);
        }
        finally {
            if (taskProperties != null) {
                try {
                    taskProperties.close();
                }
                catch (IOException ex) {
                    this.log("", ex, 4);
                }
            }
        }
        if (this.dataDirectory != null) {
            Settings.setString((String)"data.directory", (String)this.dataDirectory);
        } else {
            File jarPath = new File(Purge.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = Settings.getString((String)"data.directory");
            File dataDir = new File(base, sub);
            Settings.setString((String)"data.directory", (String)dataDir.getAbsolutePath());
        }
    }
}

