/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.RAMDirectory;
import org.owasp.dependencycheck.data.cpe.IndexException;
import org.owasp.dependencycheck.data.lucene.FieldAnalyzer;
import org.owasp.dependencycheck.data.lucene.LuceneUtils;
import org.owasp.dependencycheck.data.lucene.SearchFieldAnalyzer;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CpeMemoryIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(CpeMemoryIndex.class);
    private static final CpeMemoryIndex INSTANCE = new CpeMemoryIndex();
    private RAMDirectory index;
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private Analyzer searchingAnalyzer;
    private QueryParser queryParser;
    private SearchFieldAnalyzer productSearchFieldAnalyzer;
    private SearchFieldAnalyzer vendorSearchFieldAnalyzer;
    private boolean openState = false;

    private CpeMemoryIndex() {
    }

    public static CpeMemoryIndex getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(CveDB cve) throws IndexException {
        CpeMemoryIndex cpeMemoryIndex = INSTANCE;
        synchronized (cpeMemoryIndex) {
            if (!this.openState) {
                this.index = new RAMDirectory();
                this.buildIndex(cve);
                try {
                    this.indexReader = DirectoryReader.open(this.index);
                }
                catch (IOException ex) {
                    throw new IndexException(ex);
                }
                this.indexSearcher = new IndexSearcher(this.indexReader);
                this.searchingAnalyzer = this.createSearchingAnalyzer();
                this.queryParser = new QueryParser(LuceneUtils.CURRENT_VERSION, "id", this.searchingAnalyzer);
                this.openState = true;
            }
        }
    }

    public boolean isOpen() {
        return this.openState;
    }

    private Analyzer createIndexingAnalyzer() {
        HashMap<String, Analyzer> fieldAnalyzers = new HashMap<String, Analyzer>();
        fieldAnalyzers.put("id", new KeywordAnalyzer());
        return new PerFieldAnalyzerWrapper(new FieldAnalyzer(LuceneUtils.CURRENT_VERSION), fieldAnalyzers);
    }

    private Analyzer createSearchingAnalyzer() {
        HashMap<String, Analyzer> fieldAnalyzers = new HashMap<String, Analyzer>();
        fieldAnalyzers.put("id", new KeywordAnalyzer());
        this.productSearchFieldAnalyzer = new SearchFieldAnalyzer(LuceneUtils.CURRENT_VERSION);
        this.vendorSearchFieldAnalyzer = new SearchFieldAnalyzer(LuceneUtils.CURRENT_VERSION);
        fieldAnalyzers.put("product", this.productSearchFieldAnalyzer);
        fieldAnalyzers.put("vendor", this.vendorSearchFieldAnalyzer);
        return new PerFieldAnalyzerWrapper(new FieldAnalyzer(LuceneUtils.CURRENT_VERSION), fieldAnalyzers);
    }

    public void saveEntry(String vendor, String product, IndexWriter indexWriter) throws CorruptIndexException, IOException {
        Document doc = new Document();
        TextField v = new TextField("vendor", vendor, Field.Store.YES);
        TextField p = new TextField("product", product, Field.Store.YES);
        doc.add(v);
        doc.add(p);
        indexWriter.addDocument(doc);
    }

    public void close() {
        if (this.searchingAnalyzer != null) {
            this.searchingAnalyzer.close();
            this.searchingAnalyzer = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException ex) {
                LOGGER.trace("", ex);
            }
            this.indexReader = null;
        }
        this.queryParser = null;
        this.indexSearcher = null;
        if (this.index != null) {
            this.index.close();
            this.index = null;
        }
        this.openState = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndex(CveDB cve) throws IndexException {
        Analyzer analyzer = null;
        IndexWriter indexWriter = null;
        try {
            analyzer = this.createIndexingAnalyzer();
            IndexWriterConfig conf = new IndexWriterConfig(LuceneUtils.CURRENT_VERSION, analyzer);
            indexWriter = new IndexWriter(this.index, conf);
            try {
                Set<Pair<String, String>> data = cve.getVendorProductList();
                for (Pair<String, String> pair : data) {
                    this.saveEntry(pair.getLeft(), pair.getRight(), indexWriter);
                }
            }
            catch (DatabaseException ex) {
                LOGGER.debug("", ex);
                throw new IndexException("Error reading CPE data", ex);
            }
        }
        catch (CorruptIndexException ex) {
            throw new IndexException("Unable to close an in-memory index", ex);
        }
        catch (IOException ex) {
            throw new IndexException("Unable to close an in-memory index", ex);
        }
        finally {
            if (indexWriter != null) {
                try {
                    try {
                        indexWriter.commit();
                    }
                    finally {
                        indexWriter.close(true);
                    }
                }
                catch (CorruptIndexException ex) {
                    throw new IndexException("Unable to close an in-memory index", ex);
                }
                catch (IOException ex) {
                    throw new IndexException("Unable to close an in-memory index", ex);
                }
                if (analyzer != null) {
                    analyzer.close();
                }
            }
        }
    }

    private void resetSearchingAnalyzer() {
        if (this.productSearchFieldAnalyzer != null) {
            this.productSearchFieldAnalyzer.clear();
        }
        if (this.vendorSearchFieldAnalyzer != null) {
            this.vendorSearchFieldAnalyzer.clear();
        }
    }

    public TopDocs search(String searchString, int maxQueryResults) throws ParseException, IOException {
        if (searchString == null || searchString.trim().isEmpty()) {
            throw new ParseException("Query is null or empty");
        }
        Query query = this.queryParser.parse(searchString);
        return this.indexSearcher.search(query, maxQueryResults);
    }

    public TopDocs search(Query query, int maxQueryResults) throws CorruptIndexException, IOException {
        this.resetSearchingAnalyzer();
        return this.indexSearcher.search(query, maxQueryResults);
    }

    public Document getDocument(int documentId) throws IOException {
        return this.indexSearcher.doc(documentId);
    }

    public int numDocs() {
        if (this.indexReader == null) {
            return -1;
        }
        return this.indexReader.numDocs();
    }
}

