/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.utils.ExtractionException;
import org.owasp.dependencycheck.utils.ExtractionUtil;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.UrlStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonDistributionAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final String PKG_INFO = "PKG-INFO";
    private static final String METADATA = "METADATA";
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonDistributionAnalyzer.class);
    private static int dirCount = 0;
    private static final String ANALYZER_NAME = "Python Distribution Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String[] EXTENSIONS = new String[]{"whl", "egg", "zip"};
    private static final FileFilter EGG_OR_ZIP = FileFilterBuilder.newInstance().addExtensions("egg", "zip").build();
    private static final FileFilter WHL_FILTER = FileFilterBuilder.newInstance().addExtensions("whl").build();
    private File tempFileLocation;
    private static final FilenameFilter DIST_INFO_FILTER = new SuffixFileFilter(".dist-info");
    private static final FilenameFilter EGG_INFO_FILTER = new NameFileFilter("EGG-INFO");
    private static final NameFileFilter METADATA_FILTER = new NameFileFilter("METADATA");
    private static final NameFileFilter PKG_INFO_FILTER = new NameFileFilter("PKG-INFO");
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFileFilters(METADATA_FILTER, PKG_INFO_FILTER).addExtensions(EXTENSIONS).build();

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.python.distribution.enabled";
    }

    @Override
    protected void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        File actualFile = dependency.getActualFile();
        if (WHL_FILTER.accept(actualFile)) {
            this.collectMetadataFromArchiveFormat(dependency, DIST_INFO_FILTER, METADATA_FILTER);
        } else if (EGG_OR_ZIP.accept(actualFile)) {
            this.collectMetadataFromArchiveFormat(dependency, EGG_INFO_FILTER, PKG_INFO_FILTER);
        } else {
            String name = actualFile.getName();
            boolean metadata = METADATA.equals(name);
            if (metadata || PKG_INFO.equals(name)) {
                File parent = actualFile.getParentFile();
                String parentName = parent.getName();
                dependency.setDisplayFileName(parentName + "/" + name);
                if (parent.isDirectory() && (metadata && parentName.endsWith(".dist-info") || parentName.endsWith(".egg-info") || "EGG-INFO".equals(parentName))) {
                    PythonDistributionAnalyzer.collectWheelMetadata(dependency, actualFile);
                }
            }
        }
    }

    private void collectMetadataFromArchiveFormat(Dependency dependency, FilenameFilter folderFilter, FilenameFilter metadataFilter) throws AnalysisException {
        File temp = this.getNextTempDirectory();
        LOGGER.debug("{} exists? {}", (Object)temp, (Object)temp.exists());
        try {
            ExtractionUtil.extractFilesUsingFilter(new File(dependency.getActualFilePath()), temp, metadataFilter);
        }
        catch (ExtractionException ex) {
            throw new AnalysisException(ex);
        }
        PythonDistributionAnalyzer.collectWheelMetadata(dependency, PythonDistributionAnalyzer.getMatchingFile(PythonDistributionAnalyzer.getMatchingFile(temp, folderFilter), metadataFilter));
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws Exception {
        File baseDir = Settings.getTempDirectory();
        this.tempFileLocation = File.createTempFile("check", "tmp", baseDir);
        if (!this.tempFileLocation.delete()) {
            String msg = String.format("Unable to delete temporary file '%s'.", this.tempFileLocation.getAbsolutePath());
            throw new AnalysisException(msg);
        }
        if (!this.tempFileLocation.mkdirs()) {
            String msg = String.format("Unable to create directory '%s'.", this.tempFileLocation.getAbsolutePath());
            throw new AnalysisException(msg);
        }
    }

    @Override
    public void close() {
        if (this.tempFileLocation != null && this.tempFileLocation.exists()) {
            LOGGER.debug("Attempting to delete temporary files");
            boolean success = FileUtils.delete(this.tempFileLocation);
            if (!success) {
                LOGGER.warn("Failed to delete some temporary files, see the log for more details");
            }
        }
    }

    private static void collectWheelMetadata(Dependency dependency, File file) throws AnalysisException {
        InternetHeaders headers = PythonDistributionAnalyzer.getManifestProperties(file);
        PythonDistributionAnalyzer.addPropertyToEvidence(headers, dependency.getVersionEvidence(), "Version", Confidence.HIGHEST);
        PythonDistributionAnalyzer.addPropertyToEvidence(headers, dependency.getProductEvidence(), "Name", Confidence.HIGHEST);
        String url = headers.getHeader("Home-page", null);
        EvidenceCollection vendorEvidence = dependency.getVendorEvidence();
        if (StringUtils.isNotBlank(url) && UrlStringUtils.isUrl(url)) {
            vendorEvidence.addEvidence(METADATA, "vendor", url, Confidence.MEDIUM);
        }
        PythonDistributionAnalyzer.addPropertyToEvidence(headers, vendorEvidence, "Author", Confidence.LOW);
        String summary = headers.getHeader("Summary", null);
        if (StringUtils.isNotBlank(summary)) {
            JarAnalyzer.addDescription(dependency, summary, METADATA, "summary");
        }
    }

    private static void addPropertyToEvidence(InternetHeaders headers, EvidenceCollection evidence, String property, Confidence confidence) {
        String value = headers.getHeader(property, null);
        LOGGER.debug("Property: {}, Value: {}", (Object)property, (Object)value);
        if (StringUtils.isNotBlank(value)) {
            evidence.addEvidence(METADATA, property, value, confidence);
        }
    }

    private static File getMatchingFile(File folder, FilenameFilter filter) {
        File result = null;
        File[] matches = folder.listFiles(filter);
        if (null != matches && 1 == matches.length) {
            result = matches[0];
        }
        return result;
    }

    private static InternetHeaders getManifestProperties(File manifest) {
        InternetHeaders result = new InternetHeaders();
        if (null == manifest) {
            LOGGER.debug("Manifest file not found.");
        } else {
            try {
                result.load(new AutoCloseInputStream(new BufferedInputStream(new FileInputStream(manifest))));
            }
            catch (MessagingException e) {
                LOGGER.warn(e.getMessage(), e);
            }
            catch (FileNotFoundException e) {
                LOGGER.warn(e.getMessage(), e);
            }
        }
        return result;
    }

    private File getNextTempDirectory() throws AnalysisException {
        File directory;
        while ((directory = new File(this.tempFileLocation, String.valueOf(++dirCount))).exists()) {
        }
        if (!directory.mkdirs()) {
            throw new AnalysisException(String.format("Unable to create temp directory '%s'.", directory.getAbsolutePath()));
        }
        return directory;
    }
}

