/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyBundlingAnalyzer
extends AbstractAnalyzer
implements Analyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyBundlingAnalyzer.class);
    private static final Pattern STARTING_TEXT_PATTERN = Pattern.compile("^[a-zA-Z0-9]*");
    private boolean analyzed = false;
    private static final String ANALYZER_NAME = "Dependency Bundling Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_FINDING_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void analyze(Dependency ignore, Engine engine) throws AnalysisException {
        if (!this.analyzed) {
            this.analyzed = true;
            HashSet<Dependency> dependenciesToRemove = new HashSet<Dependency>();
            ListIterator<Dependency> mainIterator = engine.getDependencies().listIterator();
            block0: while (mainIterator.hasNext()) {
                Dependency dependency = mainIterator.next();
                if (!mainIterator.hasNext() || dependenciesToRemove.contains(dependency)) continue;
                ListIterator<Dependency> subIterator = engine.getDependencies().listIterator(mainIterator.nextIndex());
                while (subIterator.hasNext()) {
                    Dependency nextDependency = subIterator.next();
                    if (this.hashesMatch(dependency, nextDependency) && !this.containedInWar(dependency.getFilePath()) && !this.containedInWar(nextDependency.getFilePath())) {
                        if (this.firstPathIsShortest(dependency.getFilePath(), nextDependency.getFilePath())) {
                            this.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                            continue;
                        }
                        this.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
                        continue block0;
                    }
                    if (this.isShadedJar(dependency, nextDependency)) {
                        if (dependency.getFileName().toLowerCase().endsWith("pom.xml")) {
                            this.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
                            nextDependency.getRelatedDependencies().remove(dependency);
                            continue block0;
                        }
                        this.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                        dependency.getRelatedDependencies().remove(nextDependency);
                        continue;
                    }
                    if (!this.cpeIdentifiersMatch(dependency, nextDependency) || !this.hasSameBasePath(dependency, nextDependency) || !this.fileNameMatch(dependency, nextDependency)) continue;
                    if (this.isCore(dependency, nextDependency)) {
                        this.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                        continue;
                    }
                    this.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
                    continue block0;
                }
            }
            engine.getDependencies().removeAll(dependenciesToRemove);
        }
    }

    private void mergeDependencies(Dependency dependency, Dependency relatedDependency, Set<Dependency> dependenciesToRemove) {
        dependency.addRelatedDependency(relatedDependency);
        Iterator<Dependency> i = relatedDependency.getRelatedDependencies().iterator();
        while (i.hasNext()) {
            dependency.addRelatedDependency(i.next());
            i.remove();
        }
        if (dependency.getSha1sum().equals(relatedDependency.getSha1sum())) {
            dependency.addAllProjectReferences(relatedDependency.getProjectReferences());
        }
        dependenciesToRemove.add(relatedDependency);
    }

    private String getBaseRepoPath(String path) {
        int pos = path.indexOf("repository" + File.separator) + 11;
        if (pos < 0) {
            return path;
        }
        int tmp = path.indexOf(File.separator, pos);
        if (tmp <= 0) {
            return path;
        }
        if (tmp > 0) {
            pos = tmp + 1;
        }
        if ((tmp = path.indexOf(File.separator, pos)) > 0) {
            pos = tmp + 1;
        }
        return path.substring(0, pos);
    }

    private boolean fileNameMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency1.getFileName() == null || dependency2 == null || dependency2.getFileName() == null) {
            return false;
        }
        String fileName1 = dependency1.getActualFile().getName();
        String fileName2 = dependency2.getActualFile().getName();
        DependencyVersion version1 = DependencyVersionUtil.parseVersion(fileName1);
        DependencyVersion version2 = DependencyVersionUtil.parseVersion(fileName2);
        if (version1 != null && version2 != null && !version1.equals(version2)) {
            return false;
        }
        Matcher match1 = STARTING_TEXT_PATTERN.matcher(fileName1);
        Matcher match2 = STARTING_TEXT_PATTERN.matcher(fileName2);
        if (match1.find() && match2.find()) {
            return match1.group().equals(match2.group());
        }
        return false;
    }

    private boolean cpeIdentifiersMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency1.getIdentifiers() == null || dependency2 == null || dependency2.getIdentifiers() == null) {
            return false;
        }
        boolean matches = false;
        int cpeCount1 = 0;
        int cpeCount2 = 0;
        for (Identifier i : dependency1.getIdentifiers()) {
            if (!"cpe".equals(i.getType())) continue;
            ++cpeCount1;
        }
        for (Identifier i : dependency2.getIdentifiers()) {
            if (!"cpe".equals(i.getType())) continue;
            ++cpeCount2;
        }
        if (cpeCount1 > 0 && cpeCount1 == cpeCount2) {
            for (Identifier i : dependency1.getIdentifiers()) {
                if ("cpe".equals(i.getType()) && !(matches |= dependency2.getIdentifiers().contains(i))) break;
            }
        }
        LOGGER.debug("IdentifiersMatch={} ({}, {})", matches, dependency1.getFileName(), dependency2.getFileName());
        return matches;
    }

    private boolean hasSameBasePath(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null) {
            return false;
        }
        File lFile = new File(dependency1.getFilePath());
        String left = lFile.getParent();
        File rFile = new File(dependency2.getFilePath());
        String right = rFile.getParent();
        if (left == null) {
            return right == null;
        }
        if (left.equalsIgnoreCase(right)) {
            return true;
        }
        if (left.matches(".*[/\\\\]repository[/\\\\].*") && right.matches(".*[/\\\\]repository[/\\\\].*")) {
            left = this.getBaseRepoPath(left);
            right = this.getBaseRepoPath(right);
        }
        if (left.equalsIgnoreCase(right)) {
            return true;
        }
        for (Dependency child : dependency2.getRelatedDependencies()) {
            if (!this.hasSameBasePath(dependency1, child)) continue;
            return true;
        }
        return false;
    }

    boolean isCore(Dependency left, Dependency right) {
        String leftName = left.getFileName().toLowerCase();
        String rightName = right.getFileName().toLowerCase();
        boolean returnVal = !rightName.matches(".*\\.(tar|tgz|gz|zip|ear|war).+") && leftName.matches(".*\\.(tar|tgz|gz|zip|ear|war).+") || rightName.contains("core") && !leftName.contains("core") || rightName.contains("kernel") && !leftName.contains("kernel") ? false : (rightName.matches(".*\\.(tar|tgz|gz|zip|ear|war).+") && !leftName.matches(".*\\.(tar|tgz|gz|zip|ear|war).+") || !rightName.contains("core") && leftName.contains("core") || !rightName.contains("kernel") && leftName.contains("kernel") ? true : leftName.length() <= rightName.length());
        LOGGER.debug("IsCore={} ({}, {})", returnVal, left.getFileName(), right.getFileName());
        return returnVal;
    }

    private boolean hashesMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || dependency1.getSha1sum() == null || dependency2.getSha1sum() == null) {
            return false;
        }
        return dependency1.getSha1sum().equals(dependency2.getSha1sum());
    }

    private boolean isShadedJar(Dependency dependency, Dependency nextDependency) {
        String mainName = dependency.getFileName().toLowerCase();
        String nextName = nextDependency.getFileName().toLowerCase();
        if (mainName.endsWith(".jar") && nextName.endsWith("pom.xml")) {
            return dependency.getIdentifiers().containsAll(nextDependency.getIdentifiers());
        }
        if (nextName.endsWith(".jar") && mainName.endsWith("pom.xml")) {
            return nextDependency.getIdentifiers().containsAll(dependency.getIdentifiers());
        }
        return false;
    }

    protected boolean firstPathIsShortest(String left, String right) {
        int rightCount;
        String leftPath = left.replace('\\', '/');
        String rightPath = right.replace('\\', '/');
        int leftCount = this.countChar(leftPath, '/');
        if (leftCount == (rightCount = this.countChar(rightPath, '/'))) {
            return leftPath.compareTo(rightPath) <= 0;
        }
        return leftCount < rightCount;
    }

    private int countChar(String string, char c) {
        int count = 0;
        int max = string.length();
        for (int i = 0; i < max; ++i) {
            if (c != string.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    private boolean containedInWar(String filePath) {
        return filePath == null ? false : filePath.matches(".*\\.(ear|war)[\\\\/].*");
    }
}

