/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.utils.Settings;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    private static final String BIT_BUCKET_UNIX = "/dev/null";
    private static final String BIT_BUCKET_WIN = "NUL";

    private FileUtils() {
    }

    public static String getFileExtension(String fileName) {
        String ret = null;
        int pos = fileName.lastIndexOf(".");
        if (pos >= 0) {
            ret = fileName.substring(pos + 1, fileName.length()).toLowerCase();
        }
        return ret;
    }

    public static boolean delete(File file) {
        boolean success = true;
        if (!org.apache.commons.io.FileUtils.deleteQuietly(file)) {
            success = false;
            String msg = String.format("Failed to delete file: %s; attempting to delete on exit.", file.getPath());
            LOGGER.log(Level.INFO, msg);
            file.deleteOnExit();
        }
        return success;
    }

    public static File getTempFile(String prefix, String extension) throws IOException {
        File dir = Settings.getTempDirectory();
        String tempFileName = String.format("%s%s.%s", prefix, UUID.randomUUID().toString(), extension);
        File tempFile = new File(dir, tempFileName);
        if (tempFile.exists()) {
            return FileUtils.getTempFile(prefix, extension);
        }
        return tempFile;
    }

    @Deprecated
    public static File getDataDirectory(String configuredFilePath, Class clazz) throws IOException {
        File file = new File(configuredFilePath);
        if (file.isDirectory() && file.canWrite()) {
            return new File(file.getCanonicalPath());
        }
        File exePath = FileUtils.getPathToJar(clazz);
        return new File(exePath, configuredFilePath);
    }

    @Deprecated
    public static File getPathToJar(Class clazz) throws UnsupportedEncodingException {
        String filePath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(filePath, "UTF-8");
        File jarPath = new File(decodedPath);
        return jarPath.getParentFile();
    }

    public static String getBitBucket() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return BIT_BUCKET_WIN;
        }
        return BIT_BUCKET_UNIX;
    }
}

