/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;

public class EngineVersionCheck
implements CachedWebDataSource {
    private static final Logger LOGGER = Logger.getLogger(EngineVersionCheck.class.getName());
    public static final String ENGINE_VERSION_CHECKED_ON = "VersionCheckOn";
    public static final String CURRENT_ENGINE_RELEASE = "CurrentEngineRelease";
    private CveDB cveDB = null;
    private String updateToVersion;

    protected String getUpdateToVersion() {
        return this.updateToVersion;
    }

    protected void setUpdateToVersion(String version) {
        this.updateToVersion = version;
    }

    @Override
    public void update() throws UpdateException {
        try {
            this.openDatabase();
            DatabaseProperties properties = this.cveDB.getDatabaseProperties();
            long lastChecked = Long.parseLong(properties.getProperty(ENGINE_VERSION_CHECKED_ON, "0"));
            long now = new Date().getTime();
            this.updateToVersion = properties.getProperty(CURRENT_ENGINE_RELEASE, "");
            String currentVersion = Settings.getString("application.version", "0.0.0");
            boolean updateNeeded = this.shouldUpdate(lastChecked, now, properties, currentVersion);
            if (updateNeeded) {
                String msg = String.format("A new version of dependency-check is available. Consider updating to version %s.", this.updateToVersion);
                LOGGER.warning(msg);
            }
        }
        catch (DatabaseException ex) {
            LOGGER.log(Level.FINE, "Database Exception opening databases to retrieve properties", ex);
            throw new UpdateException("Error occured updating database properties.");
        }
        finally {
            this.closeDatabase();
        }
    }

    protected boolean shouldUpdate(long lastChecked, long now, DatabaseProperties properties, String currentVersion) throws UpdateException {
        DependencyVersion released;
        DependencyVersion running;
        DependencyVersion v;
        String currentRelease;
        int checkRange = 30;
        if (this.updateToVersion.isEmpty()) {
            checkRange = 7;
        }
        if (!DateUtil.withinDateRange(lastChecked, now, checkRange) && (currentRelease = this.getCurrentReleaseVersion()) != null && (v = new DependencyVersion(currentRelease)).getVersionParts() != null && v.getVersionParts().size() >= 3) {
            if (!currentRelease.equals(this.updateToVersion)) {
                properties.save(CURRENT_ENGINE_RELEASE, v.toString());
            } else {
                properties.save(CURRENT_ENGINE_RELEASE, "");
            }
            properties.save(ENGINE_VERSION_CHECKED_ON, Long.toString(now));
            this.updateToVersion = v.toString();
        }
        return (running = new DependencyVersion(currentVersion)).compareTo(released = new DependencyVersion(this.updateToVersion)) < 0;
    }

    protected final void openDatabase() throws DatabaseException {
        if (this.cveDB != null) {
            return;
        }
        this.cveDB = new CveDB();
        this.cveDB.open();
    }

    protected void closeDatabase() {
        if (this.cveDB != null) {
            try {
                this.cveDB.close();
            }
            catch (Throwable ignore) {
                LOGGER.log(Level.FINEST, "Error closing the cveDB", ignore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCurrentReleaseVersion() {
        HttpURLConnection conn = null;
        try {
            String str = Settings.getString("engine.version.url", "http://jeremylong.github.io/DependencyCheck/current.txt");
            URL url = new URL(str);
            conn = URLConnectionFactory.createHttpURLConnection(url);
            conn.connect();
            if (conn.getResponseCode() != 200) {
                String string = null;
                return string;
            }
            String releaseVersion = IOUtils.toString(conn.getInputStream(), "UTF-8");
            if (releaseVersion != null) {
                String string = releaseVersion.trim();
                return string;
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.FINE, "unable to retrieve current release version of dependency-check", ex);
        }
        catch (URLConnectionFailureException ex) {
            LOGGER.log(Level.FINE, "unable to retrieve current release version of dependency-check", ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "unable to retrieve current release version of dependency-check", ex);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }
}

