/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.packed.EliasFanoDecoder;

public class EliasFanoEncoder {
    final long numValues;
    private final long upperBound;
    final int numLowBits;
    final long lowerBitsMask;
    final long[] upperLongs;
    final long[] lowerLongs;
    private static final int LOG2_LONG_SIZE = Long.numberOfTrailingZeros(64L);
    long numEncoded = 0L;
    long lastEncoded = 0L;

    public EliasFanoEncoder(long numValues, long upperBound) {
        long lowBitsFac;
        if (numValues < 0L) {
            throw new IllegalArgumentException("numValues should not be negative: " + numValues);
        }
        this.numValues = numValues;
        if (numValues > 0L && upperBound < 0L) {
            throw new IllegalArgumentException("upperBound should not be negative: " + upperBound + " when numValues > 0");
        }
        this.upperBound = numValues > 0L ? upperBound : -1L;
        int nLowBits = 0;
        if (this.numValues > 0L && (lowBitsFac = this.upperBound / this.numValues) > 0L) {
            nLowBits = 63 - Long.numberOfLeadingZeros(lowBitsFac);
        }
        this.numLowBits = nLowBits;
        this.lowerBitsMask = Long.MAX_VALUE >>> 63 - this.numLowBits;
        long numLongsForLowBits = EliasFanoEncoder.numLongsForBits(numValues * (long)this.numLowBits);
        if (numLongsForLowBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("numLongsForLowBits too large to index a long array: " + numLongsForLowBits);
        }
        this.lowerLongs = new long[(int)numLongsForLowBits];
        long numHighBitsClear = (this.upperBound > 0L ? this.upperBound : 0L) >>> this.numLowBits;
        assert (numHighBitsClear <= 2L * this.numValues);
        long numHighBitsSet = this.numValues;
        long numLongsForHighBits = EliasFanoEncoder.numLongsForBits(numHighBitsClear + numHighBitsSet);
        if (numLongsForHighBits > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("numLongsForHighBits too large to index a long array: " + numLongsForHighBits);
        }
        this.upperLongs = new long[(int)numLongsForHighBits];
    }

    private static long numLongsForBits(long numBits) {
        assert (numBits >= 0L) : numBits;
        return numBits + 63L >>> LOG2_LONG_SIZE;
    }

    public void encodeNext(long x) {
        if (this.numEncoded >= this.numValues) {
            throw new IllegalStateException("encodeNext called more than " + this.numValues + " times.");
        }
        if (this.lastEncoded > x) {
            throw new IllegalArgumentException(x + " smaller than previous " + this.lastEncoded);
        }
        if (x > this.upperBound) {
            throw new IllegalArgumentException(x + " larger than upperBound " + this.upperBound);
        }
        this.encodeUpperBits(x >>> this.numLowBits);
        this.encodeLowerBits(x & this.lowerBitsMask);
        ++this.numEncoded;
        this.lastEncoded = x;
    }

    private void encodeUpperBits(long highValue) {
        long nextHighBitNum = this.numEncoded + highValue;
        int n = (int)(nextHighBitNum >>> LOG2_LONG_SIZE);
        this.upperLongs[n] = this.upperLongs[n] | 1L << (int)(nextHighBitNum & 0x3FL);
    }

    private void encodeLowerBits(long lowValue) {
        EliasFanoEncoder.packValue(lowValue, this.lowerLongs, this.numLowBits, this.numEncoded);
    }

    private static void packValue(long value, long[] longArray, int numBits, long packIndex) {
        if (numBits != 0) {
            long bitPos = (long)numBits * packIndex;
            int index = (int)(bitPos >>> LOG2_LONG_SIZE);
            int bitPosAtIndex = (int)(bitPos & 0x3FL);
            int n = index;
            longArray[n] = longArray[n] | value << bitPosAtIndex;
            if (bitPosAtIndex + numBits > 64) {
                longArray[index + 1] = value >>> 64 - bitPosAtIndex;
            }
        }
    }

    public static boolean sufficientlySmallerThanBitSet(long numValues, long upperBound) {
        return upperBound / 6L > numValues;
    }

    public EliasFanoDecoder getDecoder() {
        return new EliasFanoDecoder(this);
    }

    public long[] getLowerBits() {
        return this.lowerLongs;
    }

    public long[] getUpperBits() {
        return this.upperLongs;
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder("EliasFanoSequence");
        s.append(" numValues " + this.numValues);
        s.append(" numEncoded " + this.numEncoded);
        s.append(" upperBound " + this.upperBound);
        s.append(" lastEncoded " + this.lastEncoded);
        s.append(" numLowBits " + this.numLowBits);
        s.append("\nupperLongs[" + this.upperLongs.length + "]");
        for (i = 0; i < this.upperLongs.length; ++i) {
            s.append(" " + EliasFanoEncoder.longHex(this.upperLongs[i]));
        }
        s.append("\nlowerLongs[" + this.lowerLongs.length + "]");
        for (i = 0; i < this.lowerLongs.length; ++i) {
            s.append(" " + EliasFanoEncoder.longHex(this.lowerLongs[i]));
        }
        return s.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof EliasFanoEncoder)) {
            return false;
        }
        EliasFanoEncoder oefs = (EliasFanoEncoder)other;
        return this.numValues == oefs.numValues && this.numEncoded == oefs.numEncoded && this.numLowBits == oefs.numLowBits && Arrays.equals(this.upperLongs, oefs.upperLongs) && Arrays.equals(this.lowerLongs, oefs.lowerLongs);
    }

    public int hashCode() {
        int h = (int)(this.numValues + this.numEncoded) ^ this.numLowBits ^ Arrays.hashCode(this.upperLongs) ^ Arrays.hashCode(this.lowerLongs);
        return h;
    }

    public static String longHex(long x) {
        String hx = Long.toHexString(x);
        StringBuilder sb = new StringBuilder("0x");
        for (int l = 16 - hx.length(); l > 0; --l) {
            sb.append('0');
        }
        sb.append(hx);
        return sb.toString();
    }
}

