/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;

public final class Downloader {
    private static final Logger LOGGER = Logger.getLogger(Downloader.class.getName());
    private static final int MAX_REDIRECT_ATTEMPTS = 5;

    private Downloader() {
    }

    public static void fetchFile(URL url, File outputPath) throws DownloadFailedException {
        Downloader.fetchFile(url, outputPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchFile(URL url, File outputPath, boolean useProxy) throws DownloadFailedException {
        HttpURLConnection conn;
        block42: {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                File file;
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    String msg = String.format("Download failed, unable to locate '%s'", url.toString());
                    throw new DownloadFailedException(msg);
                }
                if (file.exists()) {
                    try {
                        FileUtils.copyFile(file, outputPath);
                    }
                    catch (IOException ex) {
                        String msg = String.format("Download failed, unable to copy '%s' to '%s'", url.toString(), outputPath.getAbsolutePath());
                        throw new DownloadFailedException(msg);
                    }
                }
                String msg = String.format("Download failed, file ('%s') does not exist", url.toString());
                throw new DownloadFailedException(msg);
            }
            conn = null;
            try {
                LOGGER.fine(String.format("Attempting download of %s", url.toString()));
                conn = URLConnectionFactory.createHttpURLConnection(url, useProxy);
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                conn.connect();
                int status = conn.getResponseCode();
                int redirectCount = 0;
                while ((status == 302 || status == 301 || status == 303) && 5 > redirectCount++) {
                    String location = conn.getHeaderField("Location");
                    try {
                        conn.disconnect();
                    }
                    finally {
                        conn = null;
                    }
                    LOGGER.fine(String.format("Download is being redirected from %s to %s", url.toString(), location));
                    conn = URLConnectionFactory.createHttpURLConnection(new URL(location), useProxy);
                    conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                    conn.connect();
                    status = conn.getResponseCode();
                }
                if (status == 200) break block42;
                try {
                    conn.disconnect();
                }
                finally {
                    conn = null;
                }
                String msg = String.format("Error downloading file %s; received response code %s.", url.toString(), status);
                throw new DownloadFailedException(msg);
            }
            catch (IOException ex) {
                try {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                finally {
                    conn = null;
                }
                String msg = String.format("Error downloading file %s; unable to connect.", url.toString());
                throw new DownloadFailedException(msg, ex);
            }
        }
        String encoding = conn.getContentEncoding();
        FilterOutputStream writer = null;
        InputStream reader = null;
        try {
            int bytesRead;
            reader = encoding != null && "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(conn.getInputStream()) : (encoding != null && "deflate".equalsIgnoreCase(encoding) ? new InflaterInputStream(conn.getInputStream()) : conn.getInputStream());
            writer = new BufferedOutputStream(new FileOutputStream(outputPath));
            byte[] buffer = new byte[4096];
            while ((bytesRead = reader.read(buffer)) > 0) {
                ((BufferedOutputStream)writer).write(buffer, 0, bytesRead);
            }
            LOGGER.fine(String.format("Download of %s complete", url.toString()));
        }
        catch (IOException ex) {
            Downloader.analyzeException(ex);
            String msg = String.format("Error saving '%s' to file '%s'%nConnection Timeout: %d%nEncoding: %s%n", url.toString(), outputPath.getAbsolutePath(), conn.getConnectTimeout(), encoding);
            throw new DownloadFailedException(msg, ex);
        }
        catch (Throwable ex) {
            String msg = String.format("Unexpected exception saving '%s' to file '%s'%nConnection Timeout: %d%nEncoding: %s%n", url.toString(), outputPath.getAbsolutePath(), conn.getConnectTimeout(), encoding);
            throw new DownloadFailedException(msg, ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, "Error closing the writer in Downloader.", ex);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, "Error closing the reader in Downloader.", ex);
                }
            }
            try {
                conn.disconnect();
            }
            finally {
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL url) throws DownloadFailedException {
        long timestamp;
        block17: {
            timestamp = 0L;
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                File lastModifiedFile;
                try {
                    lastModifiedFile = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    String msg = String.format("Unable to locate '%s'", url.toString());
                    throw new DownloadFailedException(msg);
                }
                timestamp = lastModifiedFile.lastModified();
            } else {
                HttpURLConnection conn = null;
                try {
                    conn = URLConnectionFactory.createHttpURLConnection(url);
                    conn.setRequestMethod("HEAD");
                    conn.connect();
                    int t = conn.getResponseCode();
                    if (t >= 200 && t < 300) {
                        timestamp = conn.getLastModified();
                        break block17;
                    }
                    throw new DownloadFailedException("HEAD request returned a non-200 status code");
                }
                catch (URLConnectionFailureException ex) {
                    throw new DownloadFailedException("Error creating URL Connection for HTTP HEAD request.", ex);
                }
                catch (IOException ex) {
                    Downloader.analyzeException(ex);
                    throw new DownloadFailedException("Error making HTTP HEAD request.", ex);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        finally {
                            conn = null;
                        }
                    }
                }
            }
        }
        return timestamp;
    }

    protected static void analyzeException(IOException ex) throws DownloadFailedException {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof InvalidAlgorithmParameterException)) continue;
            String keystore = System.getProperty("javax.net.ssl.keyStore");
            String version = System.getProperty("java.version");
            String vendor = System.getProperty("java.vendor");
            LOGGER.info("Error making HTTPS request - InvalidAlgorithmParameterException");
            LOGGER.info("There appears to be an issue with the installation of Java and the cacerts.See closed issue #177 here: https://github.com/jeremylong/DependencyCheck/issues/177");
            LOGGER.info(String.format("Java Info:%njavax.net.ssl.keyStore='%s'%njava.version='%s'%njava.vendor='%s'", keystore, version, vendor));
            throw new DownloadFailedException("Error making HTTPS request. Please see the log for more details.");
        }
    }
}

