/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.cwe.CweDB;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.Pair;

public class CveDB {
    private static final Logger LOGGER = Logger.getLogger(CveDB.class.getName());
    private Connection conn;
    private DatabaseProperties databaseProperties;
    private static final String DELETE_REFERENCE = "DELETE FROM reference WHERE cveid = ?";
    private static final String DELETE_SOFTWARE = "DELETE FROM software WHERE cveid = ?";
    private static final String DELETE_VULNERABILITY = "DELETE FROM vulnerability WHERE id = ?";
    private static final String CLEANUP_ORPHANS = "DELETE FROM CpeEntry WHERE id not in (SELECT CPEEntryId FROM Software); ";
    private static final String INSERT_REFERENCE = "INSERT INTO reference (cveid, name, url, source) VALUES (?, ?, ?, ?)";
    private static final String INSERT_SOFTWARE = "INSERT INTO software (cveid, cpeEntryId, previousVersion) VALUES (?, ?, ?)";
    private static final String INSERT_CPE = "INSERT INTO cpeEntry (cpe, vendor, product) VALUES (?, ?, ?)";
    private static final String SELECT_CPE_ID = "SELECT id FROM cpeEntry WHERE cpe = ?";
    private static final String INSERT_VULNERABILITY = "INSERT INTO vulnerability (cve, description, cwe, cvssScore, cvssAccessVector, cvssAccessComplexity, cvssAuthentication, cvssConfidentialityImpact, cvssIntegrityImpact, cvssAvailabilityImpact) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_VULNERABILITY = "UPDATE vulnerability SET description=?, cwe=?, cvssScore=?, cvssAccessVector=?, cvssAccessComplexity=?, cvssAuthentication=?, cvssConfidentialityImpact=?, cvssIntegrityImpact=?, cvssAvailabilityImpact=? WHERE id=?";
    private static final String SELECT_CVE_FROM_SOFTWARE = "SELECT cve, cpe, previousVersion FROM software INNER JOIN vulnerability ON vulnerability.id = software.cveId INNER JOIN cpeEntry ON cpeEntry.id = software.cpeEntryId WHERE vendor = ? AND product = ?";
    private static final String SELECT_CPE_ENTRIES = "SELECT cpe FROM cpeEntry WHERE vendor = ? AND product = ?";
    private static final String SELECT_REFERENCE = "SELECT source, name, url FROM reference WHERE cveid = ?";
    private static final String SELECT_VENDOR_PRODUCT_LIST = "SELECT vendor, product FROM cpeEntry GROUP BY vendor, product";
    private static final String SELECT_SOFTWARE = "SELECT cpe, previousVersion FROM software INNER JOIN cpeEntry ON software.cpeEntryId = cpeEntry.id WHERE cveid = ?";
    private static final String SELECT_VULNERABILITY = "SELECT id, description, cwe, cvssScore, cvssAccessVector, cvssAccessComplexity, cvssAuthentication, cvssConfidentialityImpact, cvssIntegrityImpact, cvssAvailabilityImpact FROM vulnerability WHERE cve = ?";
    private static final String SELECT_VULNERABILITY_ID = "SELECT id FROM vulnerability WHERE cve = ?";
    private static final String SELECT_PROPERTIES = "SELECT id, value FROM properties";
    private static final String SELECT_PROPERTY = "SELECT id, value FROM properties WHERE id = ?";
    private static final String INSERT_PROPERTY = "INSERT INTO properties (id, value) VALUES (?, ?)";
    private static final String UPDATE_PROPERTY = "UPDATE properties SET value = ? WHERE id = ?";
    private static final String DELETE_PROPERTY = "DELETE FROM properties WHERE id = ?";

    public CveDB() throws DatabaseException {
        this.open();
        this.databaseProperties = new DatabaseProperties(this);
    }

    protected Connection getConnection() {
        return this.conn;
    }

    public final void open() throws DatabaseException {
        this.conn = ConnectionFactory.getConnection();
    }

    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException ex) {
                String msg = "There was an error attempting to close the CveDB, see the log for more details.";
                LOGGER.log(Level.SEVERE, "There was an error attempting to close the CveDB, see the log for more details.");
                LOGGER.log(Level.FINE, null, ex);
            }
            catch (Throwable ex) {
                String msg = "There was an exception attempting to close the CveDB, see the log for more details.";
                LOGGER.log(Level.SEVERE, "There was an exception attempting to close the CveDB, see the log for more details.");
                LOGGER.log(Level.FINE, null, ex);
            }
            this.conn = null;
        }
    }

    public boolean isOpen() {
        return this.conn != null;
    }

    public void commit() throws SQLException {
    }

    protected void finalize() throws Throwable {
        LOGGER.log(Level.FINE, "Entering finalize");
        this.close();
        super.finalize();
    }

    public DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VulnerableSoftware> getCPEs(String vendor, String product) {
        HashSet<VulnerableSoftware> cpe = new HashSet<VulnerableSoftware>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(SELECT_CPE_ENTRIES);
            ps.setString(1, vendor);
            ps.setString(2, product);
            rs = ps.executeQuery();
            while (rs.next()) {
                VulnerableSoftware vs = new VulnerableSoftware();
                vs.setCpe(rs.getString(1));
                cpe.add(vs);
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                LOGGER.log(Level.SEVERE, "An unexpected SQL Exception occurred; please see the verbose log for more details.");
                LOGGER.log(Level.FINE, null, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(ps);
        return cpe;
    }

    public Set<Pair<String, String>> getVendorProductList() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = this.getConnection().prepareStatement(SELECT_VENDOR_PRODUCT_LIST);
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(ps);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(ps);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getProperties() {
        Properties prop = new Properties();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.getConnection().prepareStatement(SELECT_PROPERTIES);
            rs = ps.executeQuery();
            while (rs.next()) {
                prop.setProperty(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                LOGGER.log(Level.SEVERE, "An unexpected SQL Exception occurred; please see the verbose log for more details.");
                LOGGER.log(Level.FINE, null, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
            DBUtils.closeResultSet(rs);
        }
        DBUtils.closeStatement(ps);
        DBUtils.closeResultSet(rs);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveProperties(Properties props) {
        PreparedStatement updateProperty = null;
        PreparedStatement insertProperty = null;
        try {
            updateProperty = this.getConnection().prepareStatement(UPDATE_PROPERTY);
            insertProperty = this.getConnection().prepareStatement(INSERT_PROPERTY);
        }
        catch (SQLException ex) {
            LOGGER.log(Level.WARNING, "Unable to save properties to the database");
            LOGGER.log(Level.FINE, "Unable to save properties to the database", ex);
            DBUtils.closeStatement(updateProperty);
            DBUtils.closeStatement(insertProperty);
            return;
        }
        try {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                try {
                    updateProperty.setString(1, value);
                    updateProperty.setString(2, key);
                    if (updateProperty.executeUpdate() != 0) continue;
                    insertProperty.setString(1, key);
                    insertProperty.setString(2, value);
                }
                catch (SQLException ex) {
                    String msg = String.format("Unable to save property '%s' with a value of '%s' to the database", key, value);
                    LOGGER.log(Level.WARNING, msg);
                    LOGGER.log(Level.FINE, null, ex);
                }
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeStatement(updateProperty);
            DBUtils.closeStatement(insertProperty);
            throw throwable;
        }
        DBUtils.closeStatement(updateProperty);
        DBUtils.closeStatement(insertProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveProperty(String key, String value) {
        PreparedStatement insertProperty;
        PreparedStatement updateProperty;
        block10: {
            updateProperty = null;
            insertProperty = null;
            try {
                try {
                    updateProperty = this.getConnection().prepareStatement(UPDATE_PROPERTY);
                }
                catch (SQLException ex) {
                    LOGGER.log(Level.WARNING, "Unable to save properties to the database");
                    LOGGER.log(Level.FINE, "Unable to save properties to the database", ex);
                    DBUtils.closeStatement(updateProperty);
                    DBUtils.closeStatement(insertProperty);
                    return;
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(updateProperty);
                DBUtils.closeStatement(insertProperty);
                throw throwable;
            }
            updateProperty.setString(1, value);
            updateProperty.setString(2, key);
            if (updateProperty.executeUpdate() != 0) break block10;
            try {
                insertProperty = this.getConnection().prepareStatement(INSERT_PROPERTY);
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, "Unable to save properties to the database");
                LOGGER.log(Level.FINE, "Unable to save properties to the database", ex);
                DBUtils.closeStatement(updateProperty);
                DBUtils.closeStatement(insertProperty);
                return;
            }
            try {
                insertProperty.setString(1, key);
                insertProperty.setString(2, value);
                insertProperty.execute();
            }
            catch (SQLException ex) {
                String msg = String.format("Unable to save property '%s' with a value of '%s' to the database", key, value);
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        DBUtils.closeStatement(updateProperty);
        DBUtils.closeStatement(insertProperty);
    }

    public List<Vulnerability> getVulnerabilities(String cpeStr) throws DatabaseException {
        ResultSet rs = null;
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(cpeStr);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.log(Level.FINEST, null, ex);
        }
        DependencyVersion detectedVersion = this.parseDependencyVersion(cpe);
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        HashSet<String> cveEntries = new HashSet<String>();
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(SELECT_CVE_FROM_SOFTWARE);
            ps.setString(1, cpe.getVendor());
            ps.setString(2, cpe.getProduct());
            rs = ps.executeQuery();
            while (rs.next()) {
                String cveId = rs.getString(1);
                String cpeId = rs.getString(2);
                String previous = rs.getString(3);
                if (cveEntries.contains(cveId) || !this.isAffected(cpe.getVendor(), cpe.getProduct(), detectedVersion, cpeId, previous)) continue;
                cveEntries.add(cveId);
                Vulnerability v = this.getVulnerability(cveId);
                v.setMatchedCPE(cpeId, previous);
                vulnerabilities.add(v);
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(ps);
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Exception retrieving vulnerability for " + cpeStr, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        return vulnerabilities;
    }

    private Vulnerability getVulnerability(String cve) throws DatabaseException {
        PreparedStatement psV = null;
        PreparedStatement psR = null;
        PreparedStatement psS = null;
        ResultSet rsV = null;
        ResultSet rsR = null;
        ResultSet rsS = null;
        Vulnerability vuln = null;
        try {
            psV = this.getConnection().prepareStatement(SELECT_VULNERABILITY);
            psV.setString(1, cve);
            rsV = psV.executeQuery();
            if (rsV.next()) {
                String name;
                vuln = new Vulnerability();
                vuln.setName(cve);
                vuln.setDescription(rsV.getString(2));
                String cwe = rsV.getString(3);
                if (cwe != null && (name = CweDB.getCweName(cwe)) != null) {
                    cwe = cwe + " " + name;
                }
                int cveId = rsV.getInt(1);
                vuln.setCwe(cwe);
                vuln.setCvssScore(rsV.getFloat(4));
                vuln.setCvssAccessVector(rsV.getString(5));
                vuln.setCvssAccessComplexity(rsV.getString(6));
                vuln.setCvssAuthentication(rsV.getString(7));
                vuln.setCvssConfidentialityImpact(rsV.getString(8));
                vuln.setCvssIntegrityImpact(rsV.getString(9));
                vuln.setCvssAvailabilityImpact(rsV.getString(10));
                psR = this.getConnection().prepareStatement(SELECT_REFERENCE);
                psR.setInt(1, cveId);
                rsR = psR.executeQuery();
                while (rsR.next()) {
                    vuln.addReference(rsR.getString(1), rsR.getString(2), rsR.getString(3));
                }
                psS = this.getConnection().prepareStatement(SELECT_SOFTWARE);
                psS.setInt(1, cveId);
                rsS = psS.executeQuery();
                while (rsS.next()) {
                    String cpe = rsS.getString(1);
                    String prevVersion = rsS.getString(2);
                    if (prevVersion == null) {
                        vuln.addVulnerableSoftware(cpe);
                        continue;
                    }
                    vuln.addVulnerableSoftware(cpe, prevVersion);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Error retrieving " + cve, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rsV);
                DBUtils.closeResultSet(rsR);
                DBUtils.closeResultSet(rsS);
                DBUtils.closeStatement(psV);
                DBUtils.closeStatement(psR);
                DBUtils.closeStatement(psS);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rsV);
        DBUtils.closeResultSet(rsR);
        DBUtils.closeResultSet(rsS);
        DBUtils.closeStatement(psV);
        DBUtils.closeStatement(psR);
        DBUtils.closeStatement(psS);
        return vuln;
    }

    public void updateVulnerability(Vulnerability vuln) throws DatabaseException {
        PreparedStatement selectVulnerabilityId = null;
        PreparedStatement deleteVulnerability = null;
        PreparedStatement deleteReferences = null;
        PreparedStatement deleteSoftware = null;
        PreparedStatement updateVulnerability = null;
        PreparedStatement insertVulnerability = null;
        PreparedStatement insertReference = null;
        PreparedStatement selectCpeId = null;
        PreparedStatement insertCpe = null;
        PreparedStatement insertSoftware = null;
        try {
            selectVulnerabilityId = this.getConnection().prepareStatement(SELECT_VULNERABILITY_ID);
            deleteVulnerability = this.getConnection().prepareStatement(DELETE_VULNERABILITY);
            deleteReferences = this.getConnection().prepareStatement(DELETE_REFERENCE);
            deleteSoftware = this.getConnection().prepareStatement(DELETE_SOFTWARE);
            updateVulnerability = this.getConnection().prepareStatement(UPDATE_VULNERABILITY);
            insertVulnerability = this.getConnection().prepareStatement(INSERT_VULNERABILITY, 1);
            insertReference = this.getConnection().prepareStatement(INSERT_REFERENCE);
            selectCpeId = this.getConnection().prepareStatement(SELECT_CPE_ID);
            insertCpe = this.getConnection().prepareStatement(INSERT_CPE, 1);
            insertSoftware = this.getConnection().prepareStatement(INSERT_SOFTWARE);
            int vulnerabilityId = 0;
            selectVulnerabilityId.setString(1, vuln.getName());
            ResultSet rs = selectVulnerabilityId.executeQuery();
            if (rs.next()) {
                vulnerabilityId = rs.getInt(1);
                deleteReferences.setInt(1, vulnerabilityId);
                deleteReferences.execute();
                deleteSoftware.setInt(1, vulnerabilityId);
                deleteSoftware.execute();
            }
            DBUtils.closeResultSet(rs);
            rs = null;
            if (vulnerabilityId != 0) {
                if (vuln.getDescription().contains("** REJECT **")) {
                    deleteVulnerability.setInt(1, vulnerabilityId);
                    deleteVulnerability.executeUpdate();
                } else {
                    updateVulnerability.setString(1, vuln.getDescription());
                    updateVulnerability.setString(2, vuln.getCwe());
                    updateVulnerability.setFloat(3, vuln.getCvssScore());
                    updateVulnerability.setString(4, vuln.getCvssAccessVector());
                    updateVulnerability.setString(5, vuln.getCvssAccessComplexity());
                    updateVulnerability.setString(6, vuln.getCvssAuthentication());
                    updateVulnerability.setString(7, vuln.getCvssConfidentialityImpact());
                    updateVulnerability.setString(8, vuln.getCvssIntegrityImpact());
                    updateVulnerability.setString(9, vuln.getCvssAvailabilityImpact());
                    updateVulnerability.setInt(10, vulnerabilityId);
                    updateVulnerability.executeUpdate();
                }
            } else {
                insertVulnerability.setString(1, vuln.getName());
                insertVulnerability.setString(2, vuln.getDescription());
                insertVulnerability.setString(3, vuln.getCwe());
                insertVulnerability.setFloat(4, vuln.getCvssScore());
                insertVulnerability.setString(5, vuln.getCvssAccessVector());
                insertVulnerability.setString(6, vuln.getCvssAccessComplexity());
                insertVulnerability.setString(7, vuln.getCvssAuthentication());
                insertVulnerability.setString(8, vuln.getCvssConfidentialityImpact());
                insertVulnerability.setString(9, vuln.getCvssIntegrityImpact());
                insertVulnerability.setString(10, vuln.getCvssAvailabilityImpact());
                insertVulnerability.execute();
                try {
                    rs = insertVulnerability.getGeneratedKeys();
                    rs.next();
                    vulnerabilityId = rs.getInt(1);
                }
                catch (SQLException ex) {
                    String msg = String.format("Unable to retrieve id for new vulnerability for '%s'", vuln.getName());
                    throw new DatabaseException(msg, ex);
                }
                finally {
                    DBUtils.closeResultSet(rs);
                    rs = null;
                }
            }
            insertReference.setInt(1, vulnerabilityId);
            for (Reference r : vuln.getReferences()) {
                insertReference.setString(2, r.getName());
                insertReference.setString(3, r.getUrl());
                insertReference.setString(4, r.getSource());
                insertReference.execute();
            }
            for (VulnerableSoftware s : vuln.getVulnerableSoftware()) {
                int cpeProductId = 0;
                selectCpeId.setString(1, s.getName());
                try {
                    rs = selectCpeId.executeQuery();
                    if (rs.next()) {
                        cpeProductId = rs.getInt(1);
                    }
                }
                catch (SQLException ex) {
                    throw new DatabaseException("Unable to get primary key for new cpe: " + s.getName(), ex);
                }
                finally {
                    DBUtils.closeResultSet(rs);
                    rs = null;
                }
                if (cpeProductId == 0) {
                    insertCpe.setString(1, s.getName());
                    insertCpe.setString(2, s.getVendor());
                    insertCpe.setString(3, s.getProduct());
                    insertCpe.executeUpdate();
                    cpeProductId = DBUtils.getGeneratedKey(insertCpe);
                }
                if (cpeProductId == 0) {
                    throw new DatabaseException("Unable to retrieve cpeProductId - no data returned");
                }
                insertSoftware.setInt(1, vulnerabilityId);
                insertSoftware.setInt(2, cpeProductId);
                if (s.getPreviousVersion() == null) {
                    insertSoftware.setNull(3, 12);
                } else {
                    insertSoftware.setString(3, s.getPreviousVersion());
                }
                insertSoftware.execute();
            }
        }
        catch (SQLException ex) {
            try {
                String msg = String.format("Error updating '%s'", vuln.getName());
                LOGGER.log(Level.FINE, null, ex);
                throw new DatabaseException(msg, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(selectVulnerabilityId);
                DBUtils.closeStatement(deleteReferences);
                DBUtils.closeStatement(deleteSoftware);
                DBUtils.closeStatement(updateVulnerability);
                DBUtils.closeStatement(deleteVulnerability);
                DBUtils.closeStatement(insertVulnerability);
                DBUtils.closeStatement(insertReference);
                DBUtils.closeStatement(selectCpeId);
                DBUtils.closeStatement(insertCpe);
                DBUtils.closeStatement(insertSoftware);
                throw throwable;
            }
        }
        DBUtils.closeStatement(selectVulnerabilityId);
        DBUtils.closeStatement(deleteReferences);
        DBUtils.closeStatement(deleteSoftware);
        DBUtils.closeStatement(updateVulnerability);
        DBUtils.closeStatement(deleteVulnerability);
        DBUtils.closeStatement(insertVulnerability);
        DBUtils.closeStatement(insertReference);
        DBUtils.closeStatement(selectCpeId);
        DBUtils.closeStatement(insertCpe);
        DBUtils.closeStatement(insertSoftware);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDatabase() {
        PreparedStatement ps;
        block4: {
            ps = null;
            try {
                ps = this.getConnection().prepareStatement(CLEANUP_ORPHANS);
                if (ps == null) break block4;
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                try {
                    String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                    LOGGER.log(Level.SEVERE, "An unexpected SQL Exception occurred; please see the verbose log for more details.");
                    LOGGER.log(Level.FINE, null, ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeStatement(ps);
                    throw throwable;
                }
                DBUtils.closeStatement(ps);
            }
        }
        DBUtils.closeStatement(ps);
    }

    private boolean isAffected(String vendor, String product, DependencyVersion identifiedVersion, String cpeId, String previous) {
        boolean prevAffected;
        boolean affected = false;
        boolean isStruts = "apache".equals(vendor) && "struts".equals(product);
        DependencyVersion v = this.parseDependencyVersion(cpeId);
        boolean bl = prevAffected = previous != null && !previous.isEmpty();
        if (v == null || "-".equals(v.toString())) {
            affected = true;
        } else if (identifiedVersion == null || "-".equals(identifiedVersion.toString())) {
            if (prevAffected) {
                affected = true;
            }
        } else if (identifiedVersion.equals(v) || prevAffected && identifiedVersion.compareTo(v) < 0) {
            if (isStruts) {
                if (identifiedVersion.getVersionParts().get(0).equals(v.getVersionParts().get(0))) {
                    affected = true;
                }
            } else {
                affected = true;
            }
        }
        return affected;
    }

    private DependencyVersion parseDependencyVersion(String cpeStr) {
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(cpeStr);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.log(Level.FINEST, null, ex);
        }
        return this.parseDependencyVersion(cpe);
    }

    private DependencyVersion parseDependencyVersion(VulnerableSoftware cpe) {
        DependencyVersion cpeVersion;
        if (cpe.getVersion() != null && cpe.getVersion().length() > 0) {
            String versionText = cpe.getRevision() != null && cpe.getRevision().length() > 0 ? String.format("%s.%s", cpe.getVersion(), cpe.getRevision()) : cpe.getVersion();
            cpeVersion = DependencyVersionUtil.parseVersion(versionText);
        } else {
            cpeVersion = new DependencyVersion("-");
        }
        return cpeVersion;
    }
}

