/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.net.MalformedURLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.data.update.UpdateableNvdCve;
import org.owasp.dependencycheck.data.update.exception.InvalidDataException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.task.CallableDownloadTask;
import org.owasp.dependencycheck.data.update.task.ProcessTask;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;

public class StandardUpdate {
    private static final Logger LOGGER = Logger.getLogger(StandardUpdate.class.getName());
    public static final int MAX_THREAD_POOL_SIZE = Settings.getInt("max.download.threads", 3);
    private DatabaseProperties properties;
    private UpdateableNvdCve updateable;
    private CveDB cveDB = null;

    public boolean isUpdateNeeded() {
        return this.updateable.isUpdateNeeded();
    }

    public StandardUpdate() throws MalformedURLException, DownloadFailedException, UpdateException {
        this.openDataStores();
        this.properties = this.cveDB.getDatabaseProperties();
        this.updateable = this.updatesNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws UpdateException {
        int maxUpdates = 0;
        try {
            Object task;
            for (NvdCveInfo cve : this.updateable) {
                if (!cve.getNeedsUpdate()) continue;
                ++maxUpdates;
            }
            if (maxUpdates <= 0) {
                return;
            }
            if (maxUpdates > 3) {
                LOGGER.log(Level.INFO, "NVD CVE requires several updates; this could take a couple of minutes.");
            }
            if (maxUpdates > 0) {
                this.openDataStores();
            }
            int poolSize = MAX_THREAD_POOL_SIZE < maxUpdates ? MAX_THREAD_POOL_SIZE : maxUpdates;
            ExecutorService downloadExecutors = Executors.newFixedThreadPool(poolSize);
            ExecutorService processExecutor = Executors.newSingleThreadExecutor();
            HashSet<Future<Future<ProcessTask>>> downloadFutures = new HashSet<Future<Future<ProcessTask>>>(maxUpdates);
            for (NvdCveInfo cve : this.updateable) {
                if (!cve.getNeedsUpdate()) continue;
                CallableDownloadTask callableDownloadTask = new CallableDownloadTask(cve, processExecutor, this.cveDB, Settings.getInstance());
                downloadFutures.add(downloadExecutors.submit(callableDownloadTask));
            }
            downloadExecutors.shutdown();
            HashSet<Object> processFutures = new HashSet<Object>(maxUpdates);
            for (Future future : downloadFutures) {
                task = null;
                try {
                    task = (Future)future.get();
                }
                catch (InterruptedException ex) {
                    downloadExecutors.shutdownNow();
                    processExecutor.shutdownNow();
                    LOGGER.log(Level.FINE, "Thread was interrupted during download", ex);
                    throw new UpdateException("The download was interrupted", ex);
                }
                catch (ExecutionException ex) {
                    downloadExecutors.shutdownNow();
                    processExecutor.shutdownNow();
                    LOGGER.log(Level.FINE, "Thread was interrupted during download execution", ex);
                    throw new UpdateException("The execution of the download was interrupted", ex);
                }
                if (task == null) {
                    downloadExecutors.shutdownNow();
                    processExecutor.shutdownNow();
                    LOGGER.log(Level.FINE, "Thread was interrupted during download");
                    throw new UpdateException("The download was interrupted; unable to complete the update");
                }
                processFutures.add(task);
            }
            for (Future future : processFutures) {
                try {
                    task = (ProcessTask)future.get();
                    if (((ProcessTask)task).getException() == null) continue;
                    throw ((ProcessTask)task).getException();
                }
                catch (InterruptedException ex) {
                    processExecutor.shutdownNow();
                    LOGGER.log(Level.FINE, "Thread was interrupted during processing", ex);
                    throw new UpdateException(ex);
                }
                catch (ExecutionException ex) {
                    processExecutor.shutdownNow();
                    LOGGER.log(Level.FINE, "Execution Exception during process", ex);
                    throw new UpdateException(ex);
                }
                finally {
                    processExecutor.shutdown();
                }
            }
            if (maxUpdates >= 1) {
                this.properties.save(this.updateable.get("Modified"));
                this.cveDB.cleanupDatabase();
            }
        }
        finally {
            this.closeDataStores();
        }
    }

    protected final UpdateableNvdCve updatesNeeded() throws MalformedURLException, DownloadFailedException, UpdateException {
        UpdateableNvdCve updates;
        block15: {
            updates = null;
            try {
                updates = this.retrieveCurrentTimestampsFromWeb();
            }
            catch (InvalidDataException ex) {
                String msg = "Unable to retrieve valid timestamp from nvd cve downloads page";
                LOGGER.log(Level.FINE, "Unable to retrieve valid timestamp from nvd cve downloads page", ex);
                throw new DownloadFailedException("Unable to retrieve valid timestamp from nvd cve downloads page", ex);
            }
            catch (InvalidSettingException ex) {
                LOGGER.log(Level.FINE, "Invalid setting found when retrieving timestamps", ex);
                throw new DownloadFailedException("Invalid settings", ex);
            }
            if (updates == null) {
                throw new DownloadFailedException("Unable to retrieve the timestamps of the currently published NVD CVE data");
            }
            if (!this.properties.isEmpty()) {
                try {
                    long lastUpdated = Long.parseLong(this.properties.getProperty("NVD CVE Modified", "0"));
                    Date now = new Date();
                    int days = Settings.getInt("cve.url.modified.validfordays", 7);
                    if (lastUpdated == updates.getTimeStamp("Modified")) {
                        updates.clear();
                        break block15;
                    }
                    if (this.withinRange(lastUpdated, now.getTime(), days)) {
                        for (NvdCveInfo entry : updates) {
                            if ("Modified".equals(entry.getId())) {
                                entry.setNeedsUpdate(true);
                                continue;
                            }
                            entry.setNeedsUpdate(false);
                        }
                        break block15;
                    }
                    for (NvdCveInfo entry : updates) {
                        if ("Modified".equals(entry.getId())) {
                            entry.setNeedsUpdate(true);
                            continue;
                        }
                        long currentTimestamp = 0L;
                        try {
                            currentTimestamp = Long.parseLong(this.properties.getProperty("NVD CVE " + entry.getId(), "0"));
                        }
                        catch (NumberFormatException ex) {
                            String msg = String.format("Error parsing '%s' '%s' from nvdcve.lastupdated", "NVD CVE ", entry.getId());
                            LOGGER.log(Level.FINE, msg, ex);
                        }
                        if (currentTimestamp != entry.getTimestamp()) continue;
                        entry.setNeedsUpdate(false);
                    }
                }
                catch (NumberFormatException ex) {
                    String msg = "An invalid schema version or timestamp exists in the data.properties file.";
                    LOGGER.log(Level.WARNING, "An invalid schema version or timestamp exists in the data.properties file.");
                    LOGGER.log(Level.FINE, "", ex);
                }
            }
        }
        return updates;
    }

    private UpdateableNvdCve retrieveCurrentTimestampsFromWeb() throws MalformedURLException, DownloadFailedException, InvalidDataException, InvalidSettingException {
        UpdateableNvdCve updates = new UpdateableNvdCve();
        updates.add("Modified", Settings.getString("cve.url-2.0.modified"), Settings.getString("cve.url-1.2.modified"), false);
        int start = Settings.getInt("cve.startyear");
        int end = Calendar.getInstance().get(1);
        String baseUrl20 = Settings.getString("cve.url-2.0.base");
        String baseUrl12 = Settings.getString("cve.url-1.2.base");
        for (int i = start; i <= end; ++i) {
            updates.add(Integer.toString(i), String.format(baseUrl20, i), String.format(baseUrl12, i), true);
        }
        return updates;
    }

    protected void closeDataStores() {
        if (this.cveDB != null) {
            try {
                this.cveDB.close();
            }
            catch (Throwable ignore) {
                LOGGER.log(Level.FINEST, "Error closing the cveDB", ignore);
            }
        }
    }

    protected final void openDataStores() throws UpdateException {
        if (this.cveDB != null) {
            return;
        }
        try {
            this.cveDB = new CveDB();
            this.cveDB.open();
        }
        catch (DatabaseException ex) {
            this.closeDataStores();
            LOGGER.log(Level.FINE, "Database Exception opening databases", ex);
            throw new UpdateException("Error updating the CPE/CVE data, please see the log file for more details.");
        }
    }

    protected boolean withinRange(long date, long compareTo, int range) {
        double differenceInDays = (double)(compareTo - date) / 1000.0 / 60.0 / 60.0 / 24.0;
        return differenceInDays < (double)range;
    }
}

