/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nuget.NugetPackage;
import org.owasp.dependencycheck.data.nuget.NuspecParseException;
import org.owasp.dependencycheck.data.nuget.XPathNuspecParser;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;

public class NuspecAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(NuspecAnalyzer.class.getName());
    private static final String ANALYZER_NAME = "Nuspec Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Set<String> SUPPORTED_EXTENSIONS = NuspecAnalyzer.newHashSet("nuspec");

    @Override
    public void initializeFileTypeAnalyzer() throws Exception {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nuspec.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    @Override
    public void analyzeFileType(Dependency dependency, Engine engine) throws AnalysisException {
        LOGGER.log(Level.FINE, "Checking Nuspec file {0}", dependency.toString());
        try {
            XPathNuspecParser parser = new XPathNuspecParser();
            NugetPackage np = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(dependency.getActualFilePath());
                np = parser.parse(fis);
            }
            catch (NuspecParseException ex) {
                throw new AnalysisException(ex);
            }
            catch (FileNotFoundException ex) {
                throw new AnalysisException(ex);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LOGGER.fine("Error closing input stream");
                    }
                }
            }
            if (np.getOwners() != null) {
                dependency.getVendorEvidence().addEvidence("nuspec", "owners", np.getOwners(), Confidence.HIGHEST);
            }
            dependency.getVendorEvidence().addEvidence("nuspec", "authors", np.getAuthors(), Confidence.HIGH);
            dependency.getVersionEvidence().addEvidence("nuspec", "version", np.getVersion(), Confidence.HIGHEST);
            dependency.getProductEvidence().addEvidence("nuspec", "id", np.getId(), Confidence.HIGHEST);
            if (np.getTitle() != null) {
                dependency.getProductEvidence().addEvidence("nuspec", "title", np.getTitle(), Confidence.MEDIUM);
            }
        }
        catch (Throwable e) {
            throw new AnalysisException(e);
        }
    }
}

