/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.Resources;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.LogUtils;
import org.owasp.dependencycheck.utils.Settings;

public class DependencyCheckTask
extends Task {
    private static final String PROPERTIES_FILE = "task.properties";
    private static final String LOG_PROPERTIES_FILE = "log.properties";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private Resources path = null;
    private Reference refid = null;
    private String applicationName = "Dependency-Check";
    private String dataDirectory = null;
    private String reportOutputDirectory = ".";
    private float failBuildOnCVSS = 11.0f;
    private boolean autoUpdate = true;
    private String reportFormat = "HTML";
    private String proxyUrl;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String connectionTimeout;
    private String logFile = null;
    private String suppressionFile;
    private boolean showSummary = true;
    private boolean nexusAnalyzerEnabled = true;
    private String nexusUrl;
    private boolean nexusUsesProxy = true;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String databasePassword;
    private String zipExtensions;
    private String cveUrl12Modified;
    private String cveUrl20Modified;
    private String cveUrl12Base;
    private String cveUrl20Base;
    private String pathToMono;

    public void add(ResourceCollection rc) {
        if (this.isReference()) {
            throw new BuildException("Nested elements are not allowed when using the refid attribute.");
        }
        this.getPath().add(rc);
    }

    private synchronized Resources getPath() {
        if (this.path == null) {
            this.path = new Resources(this.getProject());
            this.path.setCache(true);
        }
        return this.path;
    }

    public boolean isReference() {
        return this.refid != null;
    }

    public void setRefid(Reference r) {
        if (this.path != null) {
            throw new BuildException("Nested elements are not allowed when using the refid attribute.");
        }
        this.refid = r;
    }

    private void dealWithReferences() throws BuildException {
        if (this.isReference()) {
            Object o = this.refid.getReferencedObject(this.getProject());
            if (!(o instanceof ResourceCollection)) {
                throw new BuildException("refid '" + this.refid.getRefId() + "' does not refer to a resource collection.");
            }
            this.getPath().add((ResourceCollection)o);
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(String reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public float getFailBuildOnCVSS() {
        return this.failBuildOnCVSS;
    }

    public void setFailBuildOnCVSS(float failBuildOnCVSS) {
        this.failBuildOnCVSS = failBuildOnCVSS;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportFormats reportFormat) {
        this.reportFormat = reportFormat.getValue();
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getSuppressionFile() {
        return this.suppressionFile;
    }

    public void setSuppressionFile(String suppressionFile) {
        this.suppressionFile = suppressionFile;
    }

    public boolean isShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(boolean showSummary) {
        this.showSummary = showSummary;
    }

    public boolean isNexusAnalyzerEnabled() {
        return this.nexusAnalyzerEnabled;
    }

    public void setNexusAnalyzerEnabled(boolean nexusAnalyzerEnabled) {
        this.nexusAnalyzerEnabled = nexusAnalyzerEnabled;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public boolean isNexusUsesProxy() {
        return this.nexusUsesProxy;
    }

    public void setNexusUsesProxy(boolean nexusUsesProxy) {
        this.nexusUsesProxy = nexusUsesProxy;
    }

    public String getDatabaseDriverName() {
        return this.databaseDriverName;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public String getDatabaseDriverPath() {
        return this.databaseDriverPath;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getZipExtensions() {
        return this.zipExtensions;
    }

    public void setZipExtensions(String zipExtensions) {
        this.zipExtensions = zipExtensions;
    }

    public String getCveUrl12Modified() {
        return this.cveUrl12Modified;
    }

    public void setCveUrl12Modified(String cveUrl12Modified) {
        this.cveUrl12Modified = cveUrl12Modified;
    }

    public String getCveUrl20Modified() {
        return this.cveUrl20Modified;
    }

    public void setCveUrl20Modified(String cveUrl20Modified) {
        this.cveUrl20Modified = cveUrl20Modified;
    }

    public String getCveUrl12Base() {
        return this.cveUrl12Base;
    }

    public void setCveUrl12Base(String cveUrl12Base) {
        this.cveUrl12Base = cveUrl12Base;
    }

    public String getCveUrl20Base() {
        return this.cveUrl20Base;
    }

    public void setCveUrl20Base(String cveUrl20Base) {
        this.cveUrl20Base = cveUrl20Base;
    }

    public String getPathToMono() {
        return this.pathToMono;
    }

    public void setPathToMono(String pathToMono) {
        this.pathToMono = pathToMono;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        InputStream in = DependencyCheckTask.class.getClassLoader().getResourceAsStream(LOG_PROPERTIES_FILE);
        LogUtils.prepareLogger(in, this.logFile);
        this.dealWithReferences();
        this.validateConfiguration();
        this.populateSettings();
        Engine engine = null;
        try {
            engine = new Engine();
            for (Resource resource : this.path) {
                File file;
                FileProvider provider = resource.as(FileProvider.class);
                if (provider == null || (file = provider.getFile()) == null || !file.exists()) continue;
                engine.scan(file);
            }
            try {
                engine.analyzeDependencies();
                DatabaseProperties prop = null;
                CveDB cve = null;
                try {
                    cve = new CveDB();
                    cve.open();
                    prop = cve.getDatabaseProperties();
                }
                catch (DatabaseException ex) {
                    Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.FINE, "Unable to retrieve DB Properties", ex);
                }
                finally {
                    if (cve != null) {
                        cve.close();
                    }
                }
                ReportGenerator reporter = new ReportGenerator(this.applicationName, engine.getDependencies(), engine.getAnalyzers(), prop);
                reporter.generateReports(this.reportOutputDirectory, this.reportFormat);
                if (this.failBuildOnCVSS <= 10.0f) {
                    this.checkForFailure(engine.getDependencies());
                }
                if (this.showSummary) {
                    this.showSummary(engine.getDependencies());
                }
            }
            catch (IOException ex) {
                Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.FINE, "Unable to generate dependency-check report", ex);
                throw new BuildException("Unable to generate dependency-check report", ex);
            }
            catch (Exception ex) {
                Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.FINE, "An exception occurred; unable to continue task", ex);
                throw new BuildException("An exception occurred; unable to continue task", ex);
            }
        }
        catch (DatabaseException ex) {
            Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.SEVERE, "Unable to connect to the dependency-check database; analysis has stopped");
            Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.FINE, "", ex);
        }
        finally {
            if (engine != null) {
                engine.cleanup();
            }
        }
    }

    private void validateConfiguration() throws BuildException {
        if (this.path == null) {
            throw new BuildException("No project dependencies have been defined to analyze.");
        }
        if (this.failBuildOnCVSS < 0.0f || this.failBuildOnCVSS > 11.0f) {
            throw new BuildException("Invalid configuration, failBuildOnCVSS must be between 0 and 11.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSettings() {
        InputStream taskProperties = null;
        try {
            taskProperties = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Settings.mergeProperties(taskProperties);
        }
        catch (IOException ex) {
            Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.WARNING, "Unable to load the dependency-check ant task.properties file.");
            Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.FINE, null, ex);
        }
        finally {
            if (taskProperties != null) {
                try {
                    taskProperties.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
        if (this.dataDirectory != null) {
            Settings.setString("data.directory", this.dataDirectory);
        } else {
            File jarPath = new File(DependencyCheckTask.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = Settings.getString("data.directory");
            File dataDir = new File(base, sub);
            Settings.setString("data.directory", dataDir.getAbsolutePath());
        }
        Settings.setBoolean("autoupdate", this.autoUpdate);
        if (this.proxyUrl != null && !this.proxyUrl.isEmpty()) {
            Settings.setString("proxy.url", this.proxyUrl);
        }
        if (this.proxyPort != null && !this.proxyPort.isEmpty()) {
            Settings.setString("proxy.port", this.proxyPort);
        }
        if (this.proxyUsername != null && !this.proxyUsername.isEmpty()) {
            Settings.setString("proxy.username", this.proxyUsername);
        }
        if (this.proxyPassword != null && !this.proxyPassword.isEmpty()) {
            Settings.setString("proxy.password", this.proxyPassword);
        }
        if (this.connectionTimeout != null && !this.connectionTimeout.isEmpty()) {
            Settings.setString("connection.timeout", this.connectionTimeout);
        }
        if (this.suppressionFile != null && !this.suppressionFile.isEmpty()) {
            Settings.setString("suppression.file", this.suppressionFile);
        }
        Settings.setBoolean("analyzer.nexus.enabled", this.nexusAnalyzerEnabled);
        if (this.nexusUrl != null && !this.nexusUrl.isEmpty()) {
            Settings.setString("analyzer.nexus.url", this.nexusUrl);
        }
        Settings.setBoolean("analyzer.nexus.proxy", this.nexusUsesProxy);
        if (this.databaseDriverName != null && !this.databaseDriverName.isEmpty()) {
            Settings.setString("data.driver_name", this.databaseDriverName);
        }
        if (this.databaseDriverPath != null && !this.databaseDriverPath.isEmpty()) {
            Settings.setString("data.driver_path", this.databaseDriverPath);
        }
        if (this.connectionString != null && !this.connectionString.isEmpty()) {
            Settings.setString("data.connection_string", this.connectionString);
        }
        if (this.databaseUser != null && !this.databaseUser.isEmpty()) {
            Settings.setString("data.user", this.databaseUser);
        }
        if (this.databasePassword != null && !this.databasePassword.isEmpty()) {
            Settings.setString("data.password", this.databasePassword);
        }
        if (this.zipExtensions != null && !this.zipExtensions.isEmpty()) {
            Settings.setString("extensions.zip", this.zipExtensions);
        }
        if (this.cveUrl12Modified != null && !this.cveUrl12Modified.isEmpty()) {
            Settings.setString("cve.url-1.2.modified", this.cveUrl12Modified);
        }
        if (this.cveUrl20Modified != null && !this.cveUrl20Modified.isEmpty()) {
            Settings.setString("cve.url-2.0.modified", this.cveUrl20Modified);
        }
        if (this.cveUrl12Base != null && !this.cveUrl12Base.isEmpty()) {
            Settings.setString("cve.url-1.2.base", this.cveUrl12Base);
        }
        if (this.cveUrl20Base != null && !this.cveUrl20Base.isEmpty()) {
            Settings.setString("cve.url-2.0.base", this.cveUrl20Base);
        }
        if (this.pathToMono != null && !this.pathToMono.isEmpty()) {
            Settings.setString("analyzer.assembly.mono.path", this.pathToMono);
        }
    }

    private void checkForFailure(List<Dependency> dependencies) throws BuildException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                if (ids.length() == 0) {
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater then '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
            throw new BuildException(msg);
        }
    }

    private void showSummary(List<Dependency> dependencies) {
        StringBuilder summary = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean firstEntry = true;
            StringBuilder ids = new StringBuilder();
            for (Vulnerability v : d.getVulnerabilities()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    ids.append(", ");
                }
                ids.append(v.getName());
            }
            if (ids.length() <= 0) continue;
            summary.append(d.getFileName()).append(" (");
            firstEntry = true;
            for (Identifier id : d.getIdentifiers()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    summary.append(", ");
                }
                summary.append(id.getValue());
            }
            summary.append(") : ").append((CharSequence)ids).append(NEW_LINE);
        }
        if (summary.length() > 0) {
            String msg = String.format("%n%nOne or more dependencies were identified with known vulnerabilities:%n%n%s%n%nSee the dependency-check report for more details.%n%n", summary.toString());
            Logger.getLogger(DependencyCheckTask.class.getName()).log(Level.WARNING, msg);
        }
    }

    public static class ReportFormats
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            int i = 0;
            ReportGenerator.Format[] formats = ReportGenerator.Format.values();
            String[] values = new String[formats.length];
            for (ReportGenerator.Format format : formats) {
                values[i++] = format.name();
            }
            return values;
        }
    }
}

