/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.util;

import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.owasp.csrfguard.action.IAction;

public class CsrfGuardPropertiesToStringBuilder
extends ReflectionToStringBuilder {
    private static final String PREFIX_CHARACTER = "*";
    private static final String PREFIX = "* ";
    private static final int CONFIG_DELIMITER_LENGTH = 60;
    private static final String NEW_LINE = System.lineSeparator();
    private static final Function<String, String> FIELD_NAME_TRANSFORMER = fieldName -> StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)fieldName), (String)" "));
    private static final String[] FIELDS_TO_EXCLUDE = new String[]{"propertiesCache", "javascriptTemplateCode"};

    public CsrfGuardPropertiesToStringBuilder(Object object) {
        super(object, (ToStringStyle)new CustomStyle());
        this.setExcludeFieldNames(FIELDS_TO_EXCLUDE);
    }

    public String toString() {
        String marginals = Stream.generate(() -> PREFIX_CHARACTER).limit(60L).collect(Collectors.joining("", NEW_LINE, NEW_LINE));
        return marginals + PREFIX + "OWASP CSRFGuard properties" + NEW_LINE + NEW_LINE + PREFIX + super.toString() + marginals;
    }

    public ToStringBuilder append(String fieldName, boolean value) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value);
    }

    public ToStringBuilder append(String fieldName, boolean[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, boolean[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    public ToStringBuilder append(String fieldName, byte value) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value);
    }

    public ToStringBuilder append(String fieldName, byte[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, byte[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    public ToStringBuilder append(String fieldName, char value) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value);
    }

    public ToStringBuilder append(String fieldName, char[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, char[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    public ToStringBuilder append(String fieldName, double value) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value);
    }

    public ToStringBuilder append(String fieldName, double[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, double[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    public ToStringBuilder append(String fieldName, float value) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value);
    }

    public ToStringBuilder append(String fieldName, float[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, float[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    public ToStringBuilder append(String fieldName, int value) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value);
    }

    public ToStringBuilder append(String fieldName, int[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, int[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    public ToStringBuilder append(String fieldName, long value) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value);
    }

    public ToStringBuilder append(String fieldName, long[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, long[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    public ToStringBuilder append(String fieldName, Object obj) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), obj);
    }

    public ToStringBuilder append(String fieldName, Object obj, boolean fullDetail) {
        Object value = this.customToString(obj);
        return Objects.isNull(value) ? this : super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value, fullDetail);
    }

    public ToStringBuilder append(String fieldName, Object[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, Object[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    public ToStringBuilder append(String fieldName, short value) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), value);
    }

    public ToStringBuilder append(String fieldName, short[] array) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array);
    }

    public ToStringBuilder append(String fieldName, short[] array, boolean fullDetail) {
        return super.append(FIELD_NAME_TRANSFORMER.apply(fieldName), array, fullDetail);
    }

    private Object customToString(Object obj) {
        return this.customToString(obj, "");
    }

    private Object customToString(Object obj, String prefixOffset) {
        Object result;
        if (Objects.isNull(obj)) {
            result = null;
        } else {
            String className = obj.getClass().getName();
            if (obj instanceof Collection) {
                result = this.handleCollections((Collection)obj);
            } else if (obj instanceof SecureRandom) {
                SecureRandom secureRandom = (SecureRandom)obj;
                result = String.format("%s(algorithm: %s, provider: %s)", secureRandom.getClass().getName(), secureRandom.getAlgorithm(), secureRandom.getProvider());
            } else {
                result = obj instanceof Duration ? ((Duration)obj).toMillis() + " ms" : (obj instanceof IAction ? this.handleActions((IAction)obj, prefixOffset) : (className.startsWith("org.owasp.csrfguard") ? className : obj));
            }
        }
        return result;
    }

    private Object handleActions(IAction action, String prefixOffset) {
        String parameters = action.getParameterMap().entrySet().stream().map(e -> String.format("%s\t%sParameter: %s = %s", prefixOffset, PREFIX, e.getKey(), e.getValue())).collect(Collectors.joining(NEW_LINE));
        String actionString = action.getClass().getName();
        return StringUtils.isBlank((CharSequence)parameters) ? actionString : actionString + NEW_LINE + parameters;
    }

    private Object handleCollections(Collection<?> collection) {
        return collection.isEmpty() ? null : collection.stream().map(element -> NEW_LINE + '\t' + PREFIX + this.customToString(element, "\t")).collect(Collectors.joining());
    }

    private static class CustomStyle
    extends RecursiveToStringStyle {
        public CustomStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setFieldSeparator(NEW_LINE + CsrfGuardPropertiesToStringBuilder.PREFIX);
            this.setFieldNameValueSeparator(": ");
            this.setContentStart("");
            this.setContentEnd("");
        }
    }
}

