/**
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.util.ant.archive;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.ow2.util.ant.archive.api.IClient;
import org.ow2.util.ant.archive.file.ClientFile;
import org.ow2.util.ant.archive.info.ClientInfo;

/**
 * Task that creates a client archive (only .jar file).
 * @author Florent Benoit
 */
public class Client extends AbsArchive {

    /**
     * Name of the Main-Class attribute.
     */
    private String mainClassAttribute = null;

    /**
     * Default constructor.
     */
    public Client() {
        super();
    }

    /**
     * Execute the task.
     */
    @Override
    public void execute() {

        log("Building Client in '" + getDest() + "'.", Project.MSG_INFO);

        IClient client = null;

        client = new ClientFile(getProject());

        // Set the name of the task
        ((Task) client).setTaskName(getTaskName());

        // Build the info object
        ClientInfo clientInfo = new ClientInfo();
        client.setClientInfo(clientInfo);

        // Fill archive properties
        updateArchiveInfo(clientInfo);

        // complete
        clientInfo.setMainClass(mainClassAttribute);

        // no exploded mode yet
        clientInfo.setExploded(false);

        // Execute the task
        client.execute();
    }

    /**
     * Sets the Main-Class: Attribute of the manifest.
     * @param mainClassAttribute the value of the Main-Class attribute
     */
    public void setMainClass(final String mainClassAttribute) {
        this.mainClassAttribute = mainClassAttribute;
    }

}
