/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.utils;

import java.io.File;

public final class ConversionUtils {
    public static String convertResourceToClassName(String pResourceName) {
        return ConversionUtils.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        if (i < 0) {
            return pResourceName;
        }
        String withoutExtension = pResourceName.substring(0, i);
        return withoutExtension;
    }

    public static String toJavaCasing(String pName) {
        char[] name = pName.toLowerCase().toCharArray();
        name[0] = Character.toUpperCase(name[0]);
        return new String(name);
    }

    public static String relative(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        String relFileName = absFileName.substring(rootLength + 1);
        return relFileName;
    }

    public static String getResourceNameFromFileName(String pFileName) {
        if ('/' == File.separatorChar) {
            return pFileName;
        }
        return pFileName.replace(File.separatorChar, '/');
    }
}

