/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.stores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MemoryResourceStore
implements ResourceStore {
    private final Log log = LogFactory.getLog((Class)MemoryResourceStore.class);
    private final Map store = new HashMap();

    public byte[] read(String pResourceName) {
        this.log.debug((Object)("reading resource " + pResourceName));
        return (byte[])this.store.get(pResourceName);
    }

    public void write(String pResourceName, byte[] pData) {
        this.log.debug((Object)("writing resource " + pResourceName + "(" + pData.length + ")"));
        this.store.put(pResourceName, pData);
    }

    public void remove(String pResourceName) {
        this.log.debug((Object)("removing resource " + pResourceName));
        this.store.remove(pResourceName);
    }

    public String[] list() {
        if (this.store == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = this.store.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            names.add(name);
        }
        return names.toArray(new String[this.store.size()]);
    }

    public String toString() {
        return this.getClass().getName() + this.store.toString();
    }
}

