/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import [Ljava.lang.String;;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.jci.compilers.AbstractJavaCompiler;
import org.apache.commons.jci.compilers.CompilationResult;
import org.apache.commons.jci.compilers.FileInputStreamProxy;
import org.apache.commons.jci.compilers.FileOutputStreamProxy;
import org.apache.commons.jci.compilers.JavaCompilerSettings;
import org.apache.commons.jci.compilers.JavacClassLoader;
import org.apache.commons.jci.compilers.JavacCompilationProblem;
import org.apache.commons.jci.compilers.JavacJavaCompilerSettings;
import org.apache.commons.jci.problems.CompilationProblem;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.ResourceStore;

public final class JavacJavaCompiler
extends AbstractJavaCompiler {
    private static final String EOL = System.getProperty("line.separator");
    private static final String WARNING_PREFIX = "warning: ";
    private static final String NOTE_PREFIX = "Note: ";
    private static final String ERROR_PREFIX = "error: ";
    private final JavacJavaCompilerSettings settings;

    public JavacJavaCompiler() {
        this.settings = new JavacJavaCompilerSettings();
    }

    public JavacJavaCompiler(JavacJavaCompilerSettings pSettings) {
        this.settings = pSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilationResult compile(String[] pSourcePaths, ResourceReader pReader, ResourceStore pStore, ClassLoader pClasspathClassLoader, JavaCompilerSettings pSettings) {
        try {
            JavacClassLoader cl = new JavacClassLoader(pClasspathClassLoader);
            Class<?> renamedClass = cl.loadClass("com.sun.tools.javac.Main");
            FileInputStreamProxy.setResourceReader(pReader);
            FileOutputStreamProxy.setResourceStore(pStore);
            Method compile = renamedClass.getMethod("compile", String;.class, PrintWriter.class);
            StringWriter out = new StringWriter();
            Integer ok = (Integer)compile.invoke(null, this.buildCompilerArguments(pSourcePaths, pClasspathClassLoader), new PrintWriter(out));
            CompilationResult result = this.parseModernStream(new BufferedReader(new StringReader(out.toString())));
            if (result.getErrors().length == 0 && ok != 0) {
                CompilationResult compilationResult = new CompilationResult(new CompilationProblem[]{new JavacCompilationProblem("Failure executing javac, but could not parse the error: " + out.toString(), true)});
                return compilationResult;
            }
            CompilationResult compilationResult = result;
            return compilationResult;
        }
        catch (Exception e) {
            CompilationResult compilationResult = new CompilationResult(new CompilationProblem[]{new JavacCompilationProblem("Error while executing the compiler: " + e.toString(), true)});
            return compilationResult;
        }
        finally {
            FileInputStreamProxy.setResourceReader(null);
            FileOutputStreamProxy.setResourceStore(null);
        }
    }

    private CompilationResult parseModernStream(BufferedReader pReader) throws IOException {
        ArrayList<CompilationProblem> problems = new ArrayList<CompilationProblem>();
        while (true) {
            String line;
            StringBuffer buffer = new StringBuffer();
            do {
                if ((line = pReader.readLine()) == null) {
                    return new CompilationResult(problems.toArray(new CompilationProblem[problems.size()]));
                }
                if (buffer.length() == 0 && line.startsWith(ERROR_PREFIX)) {
                    problems.add(new JavacCompilationProblem(line, true));
                    continue;
                }
                if (buffer.length() == 0 && line.startsWith(NOTE_PREFIX)) continue;
                buffer.append(line);
                buffer.append(EOL);
            } while (!line.endsWith("^"));
            problems.add(this.parseModernError(buffer.toString()));
        }
    }

    private CompilationProblem parseModernError(String pError) {
        StringTokenizer tokens = new StringTokenizer(pError, ":");
        boolean isError = true;
        try {
            int endcolumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            StringBuffer msgBuffer = new StringBuffer();
            String msg = tokens.nextToken(EOL).substring(2);
            boolean bl = isError = !msg.startsWith(WARNING_PREFIX);
            if (!isError) {
                msg = msg.substring(WARNING_PREFIX.length());
            }
            msgBuffer.append(msg);
            String context = tokens.nextToken(EOL);
            String pointer = tokens.nextToken(EOL);
            if (tokens.hasMoreTokens()) {
                msgBuffer.append(EOL);
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                msgBuffer.append(pointer);
                msgBuffer.append(EOL);
                context = tokens.nextToken(EOL);
                try {
                    pointer = tokens.nextToken(EOL);
                }
                catch (NoSuchElementException e) {
                    pointer = context;
                    context = null;
                }
            }
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new JavacCompilationProblem(file, isError, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException e) {
            return new JavacCompilationProblem("no more tokens - could not parse error message: " + pError, isError);
        }
        catch (NumberFormatException e) {
            return new JavacCompilationProblem("could not parse error message: " + pError, isError);
        }
        catch (Exception e) {
            return new JavacCompilationProblem("could not parse error message: " + pError, isError);
        }
    }

    public JavaCompilerSettings createDefaultSettings() {
        return this.settings;
    }

    private String[] buildCompilerArguments(String[] resourcePaths, ClassLoader classloader) {
        return resourcePaths;
    }
}

