/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.config;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import java.io.File;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osmdroid.config.IConfigurationProvider;
import org.osmdroid.tileprovider.util.StorageUtils;

public class DefaultConfigurationProvider
implements IConfigurationProvider {
    public static final String DEFAULT_USER_AGENT = "osmdroid";
    protected long gpsWaitTime = 20000L;
    protected boolean debugMode = false;
    protected boolean debugMapView = false;
    protected boolean debugTileProviders = false;
    protected boolean debugMapTileDownloader = false;
    protected boolean isMapViewHardwareAccelerated = true;
    protected String userAgentValue = "osmdroid";
    protected String userAgentHttpHeader = "User-Agent";
    private final Map<String, String> mAdditionalHttpRequestProperties = new HashMap<String, String>();
    protected short cacheMapTileCount = (short)9;
    protected short tileDownloadThreads = (short)2;
    protected short tileFileSystemThreads = (short)8;
    protected short tileDownloadMaxQueueSize = (short)40;
    protected short tileFileSystemMaxQueueSize = (short)40;
    protected long tileFileSystemCacheMaxBytes = 629145600L;
    protected long tileFileSystemCacheTrimBytes = 524288000L;
    protected SimpleDateFormat httpHeaderDateTimeFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    protected File osmdroidBasePath;
    protected File osmdroidTileCache;
    protected long expirationAdder = 0L;
    protected Long expirationOverride = null;
    protected Proxy httpProxy = null;
    protected int animationSpeedDefault = 1000;
    protected int animationSpeedShort = 500;
    protected boolean mapViewRecycler = true;
    protected short cacheTileOvershoot = 0;
    protected long mTileGCFrequencyInMillis = 300000L;
    protected int mTileGCBulkSize = 20;
    protected long mTileGCBulkPauseInMillis = 500L;
    protected boolean mTileDownloaderFollowRedirects = true;
    private String mNormalizedUserAgent;

    @Override
    public long getGpsWaitTime() {
        return this.gpsWaitTime;
    }

    @Override
    public void setGpsWaitTime(long gpsWaitTime) {
        this.gpsWaitTime = gpsWaitTime;
    }

    @Override
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public boolean isDebugMapView() {
        return this.debugMapView;
    }

    @Override
    public void setDebugMapView(boolean debugMapView) {
        this.debugMapView = debugMapView;
    }

    @Override
    public boolean isDebugTileProviders() {
        return this.debugTileProviders;
    }

    @Override
    public void setDebugTileProviders(boolean debugTileProviders) {
        this.debugTileProviders = debugTileProviders;
    }

    @Override
    public boolean isDebugMapTileDownloader() {
        return this.debugMapTileDownloader;
    }

    @Override
    public void setDebugMapTileDownloader(boolean debugMapTileDownloader) {
        this.debugMapTileDownloader = debugMapTileDownloader;
    }

    @Override
    public boolean isMapViewHardwareAccelerated() {
        return this.isMapViewHardwareAccelerated;
    }

    @Override
    public void setMapViewHardwareAccelerated(boolean mapViewHardwareAccelerated) {
        this.isMapViewHardwareAccelerated = mapViewHardwareAccelerated;
    }

    @Override
    public String getUserAgentValue() {
        return this.userAgentValue;
    }

    @Override
    public void setUserAgentValue(String userAgentValue) {
        this.userAgentValue = userAgentValue;
    }

    @Override
    public Map<String, String> getAdditionalHttpRequestProperties() {
        return this.mAdditionalHttpRequestProperties;
    }

    @Override
    public short getCacheMapTileCount() {
        return this.cacheMapTileCount;
    }

    @Override
    public void setCacheMapTileCount(short cacheMapTileCount) {
        this.cacheMapTileCount = cacheMapTileCount;
    }

    @Override
    public short getTileDownloadThreads() {
        return this.tileDownloadThreads;
    }

    @Override
    public void setTileDownloadThreads(short tileDownloadThreads) {
        this.tileDownloadThreads = tileDownloadThreads;
    }

    @Override
    public short getTileFileSystemThreads() {
        return this.tileFileSystemThreads;
    }

    @Override
    public void setTileFileSystemThreads(short tileFileSystemThreads) {
        this.tileFileSystemThreads = tileFileSystemThreads;
    }

    @Override
    public short getTileDownloadMaxQueueSize() {
        return this.tileDownloadMaxQueueSize;
    }

    @Override
    public void setTileDownloadMaxQueueSize(short tileDownloadMaxQueueSize) {
        this.tileDownloadMaxQueueSize = tileDownloadMaxQueueSize;
    }

    @Override
    public short getTileFileSystemMaxQueueSize() {
        return this.tileFileSystemMaxQueueSize;
    }

    @Override
    public void setTileFileSystemMaxQueueSize(short tileFileSystemMaxQueueSize) {
        this.tileFileSystemMaxQueueSize = tileFileSystemMaxQueueSize;
    }

    @Override
    public long getTileFileSystemCacheMaxBytes() {
        return this.tileFileSystemCacheMaxBytes;
    }

    @Override
    public void setTileFileSystemCacheMaxBytes(long tileFileSystemCacheMaxBytes) {
        this.tileFileSystemCacheMaxBytes = tileFileSystemCacheMaxBytes;
    }

    @Override
    public long getTileFileSystemCacheTrimBytes() {
        return this.tileFileSystemCacheTrimBytes;
    }

    @Override
    public void setTileFileSystemCacheTrimBytes(long tileFileSystemCacheTrimBytes) {
        this.tileFileSystemCacheTrimBytes = tileFileSystemCacheTrimBytes;
    }

    @Override
    public SimpleDateFormat getHttpHeaderDateTimeFormat() {
        return this.httpHeaderDateTimeFormat;
    }

    @Override
    public void setHttpHeaderDateTimeFormat(SimpleDateFormat httpHeaderDateTimeFormat) {
        this.httpHeaderDateTimeFormat = httpHeaderDateTimeFormat;
    }

    @Override
    public Proxy getHttpProxy() {
        return this.httpProxy;
    }

    @Override
    public void setHttpProxy(Proxy httpProxy) {
        this.httpProxy = httpProxy;
    }

    @Override
    public File getOsmdroidBasePath() {
        return this.getOsmdroidBasePath(null);
    }

    @Override
    public File getOsmdroidBasePath(Context context) {
        try {
            if (this.osmdroidBasePath == null) {
                StorageUtils.StorageInfo storageInfo = StorageUtils.getBestWritableStorage(context);
                String pathToStorage = storageInfo.path;
                this.osmdroidBasePath = new File(pathToStorage, DEFAULT_USER_AGENT);
                this.osmdroidBasePath.mkdirs();
            }
        }
        catch (Exception ex) {
            Log.d((String)"OsmDroid", (String)("Unable to create base path at " + this.osmdroidBasePath), (Throwable)ex);
        }
        return this.osmdroidBasePath;
    }

    @Override
    public void setOsmdroidBasePath(File osmdroidBasePath) {
        this.osmdroidBasePath = osmdroidBasePath;
    }

    @Override
    public File getOsmdroidTileCache() {
        return this.getOsmdroidTileCache(null);
    }

    @Override
    public File getOsmdroidTileCache(Context context) {
        if (this.osmdroidTileCache == null) {
            this.osmdroidTileCache = new File(this.getOsmdroidBasePath(context), "tiles");
        }
        try {
            this.osmdroidTileCache.mkdirs();
        }
        catch (Exception ex) {
            Log.d((String)"OsmDroid", (String)("Unable to create tile cache path at " + this.osmdroidTileCache), (Throwable)ex);
        }
        return this.osmdroidTileCache;
    }

    @Override
    public void setOsmdroidTileCache(File osmdroidTileCache) {
        this.osmdroidTileCache = osmdroidTileCache;
    }

    @Override
    public String getUserAgentHttpHeader() {
        return this.userAgentHttpHeader;
    }

    @Override
    public void setUserAgentHttpHeader(String userAgentHttpHeader) {
        this.userAgentHttpHeader = userAgentHttpHeader;
    }

    @Override
    public void load(Context ctx, SharedPreferences prefs) {
        this.mNormalizedUserAgent = this.computeNormalizedUserAgent(ctx);
        if (!prefs.contains("osmdroid.basePath")) {
            File discoveredBasePath = this.getOsmdroidBasePath(ctx);
            File discoveredCachePath = this.getOsmdroidTileCache(ctx);
            if (!discoveredBasePath.exists() || !StorageUtils.isWritable(discoveredBasePath)) {
                discoveredBasePath = new File(ctx.getFilesDir(), DEFAULT_USER_AGENT);
                discoveredCachePath = new File(discoveredBasePath, "tiles");
                discoveredCachePath.mkdirs();
            }
            SharedPreferences.Editor edit = prefs.edit();
            edit.putString("osmdroid.basePath", discoveredBasePath.getAbsolutePath());
            edit.putString("osmdroid.cachePath", discoveredCachePath.getAbsolutePath());
            DefaultConfigurationProvider.commit(edit);
            this.setOsmdroidBasePath(discoveredBasePath);
            this.setOsmdroidTileCache(discoveredCachePath);
            this.setUserAgentValue(ctx.getPackageName());
            this.save(ctx, prefs);
        } else {
            this.setOsmdroidBasePath(new File(prefs.getString("osmdroid.basePath", this.getOsmdroidBasePath().getAbsolutePath())));
            this.setOsmdroidTileCache(new File(prefs.getString("osmdroid.cachePath", this.getOsmdroidTileCache().getAbsolutePath())));
            this.setDebugMode(prefs.getBoolean("osmdroid.DebugMode", this.debugMode));
            this.setDebugMapTileDownloader(prefs.getBoolean("osmdroid.DebugDownloading", this.debugMapTileDownloader));
            this.setDebugMapView(prefs.getBoolean("osmdroid.DebugMapView", this.debugMapView));
            this.setDebugTileProviders(prefs.getBoolean("osmdroid.DebugTileProvider", this.debugTileProviders));
            this.setMapViewHardwareAccelerated(prefs.getBoolean("osmdroid.HardwareAcceleration", this.isMapViewHardwareAccelerated));
            this.setUserAgentValue(prefs.getString("osmdroid.userAgentValue", ctx.getPackageName()));
            DefaultConfigurationProvider.load(prefs, this.mAdditionalHttpRequestProperties, "osmdroid.additionalHttpRequestProperty.");
            this.setGpsWaitTime(prefs.getLong("osmdroid.gpsWaitTime", this.gpsWaitTime));
            this.setTileDownloadThreads((short)prefs.getInt("osmdroid.tileDownloadThreads", (int)this.tileDownloadThreads));
            this.setTileFileSystemThreads((short)prefs.getInt("osmdroid.tileFileSystemThreads", (int)this.tileFileSystemThreads));
            this.setTileDownloadMaxQueueSize((short)prefs.getInt("osmdroid.tileDownloadMaxQueueSize", (int)this.tileDownloadMaxQueueSize));
            this.setTileFileSystemMaxQueueSize((short)prefs.getInt("osmdroid.tileFileSystemMaxQueueSize", (int)this.tileFileSystemMaxQueueSize));
            this.setExpirationExtendedDuration(prefs.getLong("osmdroid.ExpirationExtendedDuration", this.expirationAdder));
            this.setMapViewRecyclerFriendly(prefs.getBoolean("osmdroid.mapViewRecycler", this.mapViewRecycler));
            this.setAnimationSpeedDefault(prefs.getInt("osmdroid.ZoomSpeedDefault", this.animationSpeedDefault));
            this.setAnimationSpeedShort(prefs.getInt("osmdroid.animationSpeedShort", this.animationSpeedShort));
            this.setCacheMapTileOvershoot((short)prefs.getInt("osmdroid.cacheTileOvershoot", (int)this.cacheTileOvershoot));
            this.setMapTileDownloaderFollowRedirects(prefs.getBoolean("osmdroid.TileDownloaderFollowRedirects", this.mTileDownloaderFollowRedirects));
            if (prefs.contains("osmdroid.ExpirationOverride")) {
                this.expirationOverride = prefs.getLong("osmdroid.ExpirationOverride", -1L);
                if (this.expirationOverride != null && this.expirationOverride == -1L) {
                    this.expirationOverride = null;
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 9) {
            long cacheSize = 0L;
            File dbFile = new File(this.getOsmdroidTileCache().getAbsolutePath() + File.separator + "cache.db");
            if (dbFile.exists()) {
                cacheSize = dbFile.length();
            }
            long freeSpace = this.getOsmdroidTileCache().getFreeSpace();
            if (this.getTileFileSystemCacheMaxBytes() > freeSpace + cacheSize) {
                this.setTileFileSystemCacheMaxBytes((long)((double)(freeSpace + cacheSize) * 0.95));
                this.setTileFileSystemCacheTrimBytes((long)((double)(freeSpace + cacheSize) * 0.9));
            }
        }
    }

    @Override
    public void save(Context ctx, SharedPreferences prefs) {
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString("osmdroid.basePath", this.getOsmdroidBasePath().getAbsolutePath());
        edit.putString("osmdroid.cachePath", this.getOsmdroidTileCache().getAbsolutePath());
        edit.putBoolean("osmdroid.DebugMode", this.isDebugMode());
        edit.putBoolean("osmdroid.DebugDownloading", this.isDebugMapTileDownloader());
        edit.putBoolean("osmdroid.DebugMapView", this.isDebugMapView());
        edit.putBoolean("osmdroid.DebugTileProvider", this.isDebugTileProviders());
        edit.putBoolean("osmdroid.HardwareAcceleration", this.isMapViewHardwareAccelerated());
        edit.putBoolean("osmdroid.TileDownloaderFollowRedirects", this.isMapTileDownloaderFollowRedirects());
        edit.putString("osmdroid.userAgentValue", this.getUserAgentValue());
        DefaultConfigurationProvider.save(prefs, edit, this.mAdditionalHttpRequestProperties, "osmdroid.additionalHttpRequestProperty.");
        edit.putLong("osmdroid.gpsWaitTime", this.gpsWaitTime);
        edit.putInt("osmdroid.cacheMapTileCount", (int)this.cacheMapTileCount);
        edit.putInt("osmdroid.tileDownloadThreads", (int)this.tileDownloadThreads);
        edit.putInt("osmdroid.tileFileSystemThreads", (int)this.tileFileSystemThreads);
        edit.putInt("osmdroid.tileDownloadMaxQueueSize", (int)this.tileDownloadMaxQueueSize);
        edit.putInt("osmdroid.tileFileSystemMaxQueueSize", (int)this.tileFileSystemMaxQueueSize);
        edit.putLong("osmdroid.ExpirationExtendedDuration", this.expirationAdder);
        if (this.expirationOverride != null) {
            edit.putLong("osmdroid.ExpirationOverride", this.expirationOverride.longValue());
        }
        edit.putInt("osmdroid.ZoomSpeedDefault", this.animationSpeedDefault);
        edit.putInt("osmdroid.animationSpeedShort", this.animationSpeedShort);
        edit.putBoolean("osmdroid.mapViewRecycler", this.mapViewRecycler);
        edit.putInt("osmdroid.cacheTileOvershoot", (int)this.cacheTileOvershoot);
        DefaultConfigurationProvider.commit(edit);
    }

    private static void load(SharedPreferences pPrefs, Map<String, String> pMap, String pPrefix) {
        if (pPrefix == null || pMap == null) {
            return;
        }
        pMap.clear();
        for (String key : pPrefs.getAll().keySet()) {
            if (key == null || !key.startsWith(pPrefix)) continue;
            pMap.put(key.substring(pPrefix.length()), pPrefs.getString(key, null));
        }
    }

    private static void save(SharedPreferences pPrefs, SharedPreferences.Editor pEdit, Map<String, String> pMap, String pPrefix) {
        for (String string : pPrefs.getAll().keySet()) {
            if (!string.startsWith(pPrefix)) continue;
            pEdit.remove(string);
        }
        for (Map.Entry entry : pMap.entrySet()) {
            String key = pPrefix + (String)entry.getKey();
            pEdit.putString(key, (String)entry.getValue());
        }
    }

    private static void commit(SharedPreferences.Editor pEditor) {
        if (Build.VERSION.SDK_INT >= 9) {
            pEditor.apply();
        } else {
            pEditor.commit();
        }
    }

    @Override
    public long getExpirationExtendedDuration() {
        return this.expirationAdder;
    }

    @Override
    public void setExpirationExtendedDuration(long period) {
        this.expirationAdder = period < 0L ? 0L : period;
    }

    @Override
    public void setExpirationOverrideDuration(Long period) {
        this.expirationOverride = period;
    }

    @Override
    public Long getExpirationOverrideDuration() {
        return this.expirationOverride;
    }

    @Override
    public void setAnimationSpeedDefault(int durationsMilliseconds) {
        this.animationSpeedDefault = durationsMilliseconds;
    }

    @Override
    public int getAnimationSpeedDefault() {
        return this.animationSpeedDefault;
    }

    @Override
    public void setAnimationSpeedShort(int durationsMilliseconds) {
        this.animationSpeedShort = durationsMilliseconds;
    }

    @Override
    public int getAnimationSpeedShort() {
        return this.animationSpeedShort;
    }

    @Override
    public boolean isMapViewRecyclerFriendly() {
        return this.mapViewRecycler;
    }

    @Override
    public void setMapViewRecyclerFriendly(boolean enabled) {
        this.mapViewRecycler = enabled;
    }

    @Override
    public void setCacheMapTileOvershoot(short value) {
        this.cacheTileOvershoot = value;
    }

    @Override
    public short getCacheMapTileOvershoot() {
        return this.cacheTileOvershoot;
    }

    @Override
    public long getTileGCFrequencyInMillis() {
        return this.mTileGCFrequencyInMillis;
    }

    @Override
    public void setTileGCFrequencyInMillis(long pMillis) {
        this.mTileGCFrequencyInMillis = pMillis;
    }

    @Override
    public int getTileGCBulkSize() {
        return this.mTileGCBulkSize;
    }

    @Override
    public void setTileGCBulkSize(int pSize) {
        this.mTileGCBulkSize = pSize;
    }

    @Override
    public long getTileGCBulkPauseInMillis() {
        return this.mTileGCBulkPauseInMillis;
    }

    @Override
    public void setTileGCBulkPauseInMillis(long pMillis) {
        this.mTileGCBulkPauseInMillis = pMillis;
    }

    @Override
    public void setMapTileDownloaderFollowRedirects(boolean value) {
        this.mTileDownloaderFollowRedirects = value;
    }

    @Override
    public boolean isMapTileDownloaderFollowRedirects() {
        return this.mTileDownloaderFollowRedirects;
    }

    @Override
    public String getNormalizedUserAgent() {
        return this.mNormalizedUserAgent;
    }

    private String computeNormalizedUserAgent(Context pContext) {
        if (pContext == null) {
            return null;
        }
        String packageName = pContext.getPackageName();
        try {
            PackageInfo packageInfo = pContext.getPackageManager().getPackageInfo(packageName, 128);
            int version = packageInfo.versionCode;
            return packageName + "/" + version;
        }
        catch (PackageManager.NameNotFoundException e1) {
            return packageName;
        }
    }
}

