/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.util.MapTileIndex;

public class QuadTreeTileSource
extends OnlineTileSourceBase {
    public QuadTreeTileSource(String aName, int aZoomMinLevel, int aZoomMaxLevel, int aTileSizePixels, String aImageFilenameEnding, String[] aBaseUrl) {
        super(aName, aZoomMinLevel, aZoomMaxLevel, aTileSizePixels, aImageFilenameEnding, aBaseUrl);
    }

    @Override
    public String getTileURLString(long pMapTileIndex) {
        return this.getBaseUrl() + this.quadTree(pMapTileIndex) + this.mImageFilenameEnding;
    }

    protected String quadTree(long pMapTileIndex) {
        StringBuilder quadKey = new StringBuilder();
        for (int i = MapTileIndex.getZoom(pMapTileIndex); i > 0; --i) {
            int digit = 0;
            int mask = 1 << i - 1;
            if ((MapTileIndex.getX(pMapTileIndex) & mask) != 0) {
                ++digit;
            }
            if ((MapTileIndex.getY(pMapTileIndex) & mask) != 0) {
                digit += 2;
            }
            quadKey.append("" + digit);
        }
        return quadKey.toString();
    }
}

