/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.milestones;

import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.PointAccepter;
import org.osmdroid.util.PointL;
import org.osmdroid.views.overlay.milestones.MilestoneStep;

public abstract class MilestoneLister
implements PointAccepter {
    private final List<MilestoneStep> mMilestones = new ArrayList<MilestoneStep>();
    private final PointL mLatestPoint = new PointL();
    private boolean mFirst;
    private double[] mDistances;

    public List<MilestoneStep> getMilestones() {
        return this.mMilestones;
    }

    public void setDistances(double[] pDistances) {
        this.mDistances = pDistances;
    }

    protected double getDistance(int pIndex) {
        return this.mDistances[pIndex];
    }

    @Override
    public void init() {
        this.mMilestones.clear();
        this.mFirst = true;
    }

    @Override
    public void add(long pX, long pY) {
        if (this.mFirst) {
            this.mFirst = false;
            this.mLatestPoint.set(pX, pY);
        } else {
            this.add(this.mLatestPoint.x, this.mLatestPoint.y, pX, pY);
            this.mLatestPoint.set(pX, pY);
        }
    }

    @Override
    public void end() {
    }

    protected void add(MilestoneStep pMilestoneStep) {
        this.mMilestones.add(pMilestoneStep);
    }

    protected abstract void add(long var1, long var3, long var5, long var7);

    public static double getOrientation(long x0, long y0, long x1, long y1) {
        if (x0 == x1) {
            if (y0 == y1) {
                return 0.0;
            }
            if (y0 > y1) {
                return -90.0;
            }
            return 90.0;
        }
        double slope = (double)(y1 - y0) / (double)(x1 - x0);
        boolean isBeyondHalfPI = x1 < x0;
        return 57.29577951308232 * Math.atan(slope) + (double)(isBeyondHalfPI ? 180 : 0);
    }
}

