/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.PointL;

public class SegmentIntersection {
    public static boolean intersection(double pXA, double pYA, double pXB, double pYB, double pXC, double pYC, double pXD, double pYD, PointL pIntersection) {
        if (SegmentIntersection.parallelSideEffect(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection)) {
            return true;
        }
        if (SegmentIntersection.divisionByZeroSideEffect(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection)) {
            return true;
        }
        double d = (pXA - pXB) * (pYC - pYD) - (pYA - pYB) * (pXC - pXD);
        if (d == 0.0) {
            return false;
        }
        double xi = ((pXC - pXD) * (pXA * pYB - pYA * pXB) - (pXA - pXB) * (pXC * pYD - pYC * pXD)) / d;
        double yi = ((pYC - pYD) * (pXA * pYB - pYA * pXB) - (pYA - pYB) * (pXC * pYD - pYC * pXD)) / d;
        return SegmentIntersection.check(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection, xi, yi);
    }

    private static boolean parallelSideEffect(double pXA, double pYA, double pXB, double pYB, double pXC, double pYC, double pXD, double pYD, PointL pIntersection) {
        if (pXA == pXB) {
            return SegmentIntersection.parallelSideEffectSameX(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection);
        }
        if (pXC == pXD) {
            return SegmentIntersection.parallelSideEffectSameX(pXC, pYC, pXD, pYD, pXA, pYA, pXB, pYB, pIntersection);
        }
        double k1 = (pYB - pYA) / (pXB - pXA);
        double k2 = (pYD - pYC) / (pXD - pXC);
        if (k1 != k2) {
            return false;
        }
        double b1 = pYA - k1 * pXA;
        double b2 = pYC - k2 * pXC;
        if (b1 != b2) {
            return false;
        }
        double xi = SegmentIntersection.middle(pXA, pXB, pXC, pXD);
        double yi = SegmentIntersection.middle(pYA, pYB, pYC, pYD);
        return SegmentIntersection.check(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection, xi, yi);
    }

    private static double middle(double pA, double pB, double pC, double pD) {
        return (Math.min(Math.max(pA, pB), Math.max(pC, pD)) + Math.max(Math.min(pA, pB), Math.min(pC, pD))) / 2.0;
    }

    private static boolean check(double pXA, double pYA, double pXB, double pYB, double pXC, double pYC, double pXD, double pYD, PointL pIntersection, double pXI, double pYI) {
        if (pXI < Math.min(pXA, pXB) || pXI > Math.max(pXA, pXB)) {
            return false;
        }
        if (pXI < Math.min(pXC, pXD) || pXI > Math.max(pXC, pXD)) {
            return false;
        }
        if (pYI < Math.min(pYA, pYB) || pYI > Math.max(pYA, pYB)) {
            return false;
        }
        if (pYI < Math.min(pYC, pYD) || pYI > Math.max(pYC, pYD)) {
            return false;
        }
        if (pIntersection != null) {
            pIntersection.x = Math.round(pXI);
            pIntersection.y = Math.round(pYI);
        }
        return true;
    }

    private static boolean parallelSideEffectSameX(double pXA, double pYA, double pXB, double pYB, double pXC, double pYC, double pXD, double pYD, PointL pIntersection) {
        if (pXA != pXB) {
            return false;
        }
        if (pXC != pXD) {
            return false;
        }
        if (pXA != pXC) {
            return false;
        }
        double yi = SegmentIntersection.middle(pYA, pYB, pYC, pYD);
        return SegmentIntersection.check(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection, pXA, yi);
    }

    private static boolean divisionByZeroSideEffect(double pXA, double pYA, double pXB, double pYB, double pXC, double pYC, double pXD, double pYD, PointL pIntersection) {
        return SegmentIntersection.divisionByZeroSideEffectX(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection) || SegmentIntersection.divisionByZeroSideEffectX(pXC, pYC, pXD, pYD, pXA, pYA, pXB, pYB, pIntersection) || SegmentIntersection.divisionByZeroSideEffectY(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection) || SegmentIntersection.divisionByZeroSideEffectY(pXC, pYC, pXD, pYD, pXA, pYA, pXB, pYB, pIntersection);
    }

    private static boolean divisionByZeroSideEffectX(double pXA, double pYA, double pXB, double pYB, double pXC, double pYC, double pXD, double pYD, PointL pIntersection) {
        if (pXA != pXB) {
            return false;
        }
        if (pXC == pXD) {
            return false;
        }
        double k = (pXA - pXC) / (pXD - pXC);
        double yi = k * (pYD - pYC) + pYC;
        return SegmentIntersection.check(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection, pXA, yi);
    }

    private static boolean divisionByZeroSideEffectY(double pXA, double pYA, double pXB, double pYB, double pXC, double pYC, double pXD, double pYD, PointL pIntersection) {
        if (pYA != pYB) {
            return false;
        }
        if (pYC == pYD) {
            return false;
        }
        double k = (pYA - pYC) / (pYD - pYC);
        double xi = k * (pXD - pXC) + pXC;
        return SegmentIntersection.check(pXA, pYA, pXB, pYB, pXC, pYC, pXD, pYD, pIntersection, xi, pYA);
    }
}

