/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.milestones;

import org.osmdroid.util.Distance;
import org.osmdroid.views.overlay.milestones.MilestoneLister;
import org.osmdroid.views.overlay.milestones.MilestoneStep;

public class MilestoneMeterDistanceSliceLister
extends MilestoneLister {
    private double mNbMetersStart;
    private double mNbMetersEnd;
    private double mDistance;
    private int mIndex;
    private Step mStep;

    public void setMeterDistanceSlice(double pNbMetersStart, double pNbMetersEnd) {
        this.mNbMetersStart = pNbMetersStart;
        this.mNbMetersEnd = pNbMetersEnd;
    }

    @Override
    public void init() {
        super.init();
        this.mDistance = 0.0;
        this.mIndex = 0;
        this.mStep = Step.STEP_INIT;
    }

    @Override
    protected void add(long x0, long y0, long x1, long y1) {
        double neededForNext;
        double currentDistance;
        if (this.mStep == Step.STEP_ENDED) {
            return;
        }
        if ((currentDistance = this.getDistance(++this.mIndex)) == 0.0) {
            return;
        }
        double pixelDistance = Math.sqrt(Distance.getSquaredDistanceToPoint(x0, y0, x1, y1));
        double metersToPixels = pixelDistance / currentDistance;
        double orientation = MilestoneMeterDistanceSliceLister.getOrientation(x0, y0, x1, y1);
        double x = x0;
        double y = y0;
        if (this.mStep == Step.STEP_INIT) {
            neededForNext = this.mNbMetersStart - this.mDistance;
            if (neededForNext > currentDistance) {
                this.mDistance += currentDistance;
                return;
            }
            this.mStep = Step.STEP_STARTED;
            this.mDistance += neededForNext;
            currentDistance -= neededForNext;
            this.add(new MilestoneStep((long)(x += neededForNext * Math.cos(Math.PI / 180 * orientation) * metersToPixels), (long)(y += neededForNext * Math.sin(Math.PI / 180 * orientation) * metersToPixels), orientation, null));
            if (this.mNbMetersStart == this.mNbMetersEnd) {
                this.mStep = Step.STEP_ENDED;
                return;
            }
        }
        if (this.mStep == Step.STEP_STARTED) {
            neededForNext = this.mNbMetersEnd - this.mDistance;
            if (neededForNext > currentDistance) {
                this.mDistance += currentDistance;
                this.add(new MilestoneStep(x1, y1, orientation, null));
                return;
            }
            this.mStep = Step.STEP_ENDED;
            this.add(new MilestoneStep((long)(x += neededForNext * Math.cos(Math.PI / 180 * orientation) * metersToPixels), (long)(y += neededForNext * Math.sin(Math.PI / 180 * orientation) * metersToPixels), orientation, null));
        }
    }

    private static enum Step {
        STEP_INIT,
        STEP_STARTED,
        STEP_ENDED;

    }
}

