/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.BitmapPool;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.TileSystem;

public class MapTileApproximater
extends MapTileModuleProviderBase {
    private final List<MapTileModuleProviderBase> mProviders = new CopyOnWriteArrayList<MapTileModuleProviderBase>();
    private int minZoomLevel;

    public MapTileApproximater() {
        this(Configuration.getInstance().getTileFileSystemThreads(), Configuration.getInstance().getTileFileSystemMaxQueueSize());
    }

    public MapTileApproximater(int pThreadPoolSize, int pPendingQueueSize) {
        super(pThreadPoolSize, pPendingQueueSize);
    }

    public void addProvider(MapTileModuleProviderBase pProvider) {
        this.mProviders.add(pProvider);
        this.computeZoomLevels();
    }

    private void computeZoomLevels() {
        boolean first = true;
        this.minZoomLevel = 0;
        for (MapTileModuleProviderBase provider : this.mProviders) {
            int otherMin = provider.getMinimumZoomLevel();
            if (first) {
                first = false;
                this.minZoomLevel = otherMin;
                continue;
            }
            this.minZoomLevel = Math.min(this.minZoomLevel, otherMin);
        }
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "Offline Tile Approximation Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "approximater";
    }

    @Override
    public TileLoader getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        return this.minZoomLevel;
    }

    @Override
    public int getMaximumZoomLevel() {
        return TileSystem.getMaximumZoomLevel();
    }

    @Override
    @Deprecated
    public void setTileSource(ITileSource pTileSource) {
    }

    public Bitmap approximateTileFromLowerZoom(long pMapTileIndex) {
        int zoomDiff = 1;
        while (MapTileIndex.getZoom(pMapTileIndex) - zoomDiff >= 0) {
            Bitmap bitmap = this.approximateTileFromLowerZoom(pMapTileIndex, zoomDiff);
            if (bitmap != null) {
                return bitmap;
            }
            ++zoomDiff;
        }
        return null;
    }

    public Bitmap approximateTileFromLowerZoom(long pMapTileIndex, int pZoomDiff) {
        for (MapTileModuleProviderBase provider : this.mProviders) {
            Bitmap bitmap = MapTileApproximater.approximateTileFromLowerZoom(provider, pMapTileIndex, pZoomDiff);
            if (bitmap == null) continue;
            return bitmap;
        }
        return null;
    }

    public static Bitmap approximateTileFromLowerZoom(MapTileModuleProviderBase pProvider, long pMapTileIndex, int pZoomDiff) {
        if (pZoomDiff <= 0) {
            return null;
        }
        int srcZoomLevel = MapTileIndex.getZoom(pMapTileIndex) - pZoomDiff;
        if (srcZoomLevel < pProvider.getMinimumZoomLevel()) {
            return null;
        }
        if (srcZoomLevel > pProvider.getMaximumZoomLevel()) {
            return null;
        }
        long srcTile = MapTileIndex.getTileIndex(srcZoomLevel, MapTileIndex.getX(pMapTileIndex) >> pZoomDiff, MapTileIndex.getY(pMapTileIndex) >> pZoomDiff);
        try {
            Drawable srcDrawable = pProvider.getTileLoader().loadTileIfReachable(srcTile);
            if (!(srcDrawable instanceof BitmapDrawable)) {
                return null;
            }
            return MapTileApproximater.approximateTileFromLowerZoom((BitmapDrawable)srcDrawable, pMapTileIndex, pZoomDiff);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap approximateTileFromLowerZoom(BitmapDrawable pSrcDrawable, long pMapTileIndex, int pZoomDiff) {
        if (pZoomDiff <= 0) {
            return null;
        }
        int tileSizePixels = pSrcDrawable.getBitmap().getWidth();
        Bitmap bitmap = MapTileApproximater.getTileBitmap(tileSizePixels);
        Canvas canvas = new Canvas(bitmap);
        boolean isReusable = pSrcDrawable instanceof ReusableBitmapDrawable;
        ReusableBitmapDrawable reusableBitmapDrawable = isReusable ? (ReusableBitmapDrawable)pSrcDrawable : null;
        boolean success = false;
        if (isReusable) {
            reusableBitmapDrawable.beginUsingDrawable();
        }
        try {
            if (!isReusable || reusableBitmapDrawable.isBitmapValid()) {
                int srcSize = tileSizePixels >> pZoomDiff;
                if (srcSize == 0) {
                    success = false;
                } else {
                    int srcX = MapTileIndex.getX(pMapTileIndex) % (1 << pZoomDiff) * srcSize;
                    int srcY = MapTileIndex.getY(pMapTileIndex) % (1 << pZoomDiff) * srcSize;
                    Rect srcRect = new Rect(srcX, srcY, srcX + srcSize, srcY + srcSize);
                    Rect dstRect = new Rect(0, 0, tileSizePixels, tileSizePixels);
                    canvas.drawBitmap(pSrcDrawable.getBitmap(), srcRect, dstRect, null);
                    success = true;
                }
            }
        }
        finally {
            if (isReusable) {
                reusableBitmapDrawable.finishUsingDrawable();
            }
        }
        if (!success) {
            return null;
        }
        return bitmap;
    }

    public static Bitmap getTileBitmap(int pTileSizePx) {
        Bitmap bitmap = BitmapPool.getInstance().obtainSizedBitmapFromPool(pTileSizePx, pTileSizePx);
        if (bitmap != null) {
            if (Build.VERSION.SDK_INT >= 12) {
                bitmap.setHasAlpha(true);
            }
            bitmap.eraseColor(0);
            return bitmap;
        }
        return Bitmap.createBitmap((int)pTileSizePx, (int)pTileSizePx, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    @Override
    public void detach() {
        super.detach();
        this.mProviders.clear();
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
            super(MapTileApproximater.this);
        }

        @Override
        public Drawable loadTile(long pMapTileIndex) {
            Bitmap bitmap = MapTileApproximater.this.approximateTileFromLowerZoom(pMapTileIndex);
            if (bitmap != null) {
                BitmapDrawable drawable = new BitmapDrawable(bitmap);
                ExpirableBitmapDrawable.setState((Drawable)drawable, -3);
                return drawable;
            }
            return null;
        }
    }
}

