/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

import java.util.concurrent.Semaphore;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.TileSourcePolicy;

public abstract class OnlineTileSourceBase
extends BitmapTileSourceBase {
    private final String[] mBaseUrls;
    private final Semaphore mSemaphore;
    private final TileSourcePolicy mTileSourcePolicy;

    public OnlineTileSourceBase(String aName, int aZoomMinLevel, int aZoomMaxLevel, int aTileSizePixels, String aImageFilenameEnding, String[] aBaseUrl) {
        this(aName, aZoomMinLevel, aZoomMaxLevel, aTileSizePixels, aImageFilenameEnding, aBaseUrl, null);
    }

    public OnlineTileSourceBase(String aName, int aZoomMinLevel, int aZoomMaxLevel, int aTileSizePixels, String aImageFilenameEnding, String[] aBaseUrl, String copyyright) {
        this(aName, aZoomMinLevel, aZoomMaxLevel, aTileSizePixels, aImageFilenameEnding, aBaseUrl, copyyright, new TileSourcePolicy());
    }

    public OnlineTileSourceBase(String pName, int pZoomMinLevel, int pZoomMaxLevel, int pTileSizePixels, String pImageFilenameEnding, String[] pBaseUrl, String pCopyright, TileSourcePolicy pTileSourcePolicy) {
        super(pName, pZoomMinLevel, pZoomMaxLevel, pTileSizePixels, pImageFilenameEnding, pCopyright);
        this.mBaseUrls = pBaseUrl;
        this.mTileSourcePolicy = pTileSourcePolicy;
        this.mSemaphore = this.mTileSourcePolicy.getMaxConcurrent() > 0 ? new Semaphore(this.mTileSourcePolicy.getMaxConcurrent(), true) : null;
    }

    public abstract String getTileURLString(long var1);

    public String getBaseUrl() {
        if (this.mBaseUrls != null && this.mBaseUrls.length > 0) {
            return this.mBaseUrls[this.random.nextInt(this.mBaseUrls.length)];
        }
        return "";
    }

    public void acquire() throws InterruptedException {
        if (this.mSemaphore == null) {
            return;
        }
        this.mSemaphore.acquire();
    }

    public void release() {
        if (this.mSemaphore == null) {
            return;
        }
        this.mSemaphore.release();
    }

    public TileSourcePolicy getTileSourcePolicy() {
        return this.mTileSourcePolicy;
    }
}

