/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Paint;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.PolyOverlayWithIW;

public class Polyline
extends PolyOverlayWithIW {
    protected OnClickListener mOnClickListener;

    public Polyline() {
        this((MapView)null);
    }

    public Polyline(MapView mapView) {
        this(mapView, false);
    }

    public Polyline(MapView pMapView, boolean pUsePath) {
        super(pMapView, pUsePath, false);
        this.mOutlinePaint.setColor(-16777216);
        this.mOutlinePaint.setStrokeWidth(10.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutlinePaint.setAntiAlias(true);
    }

    public ArrayList<GeoPoint> getPoints() {
        ArrayList<GeoPoint> result = new ArrayList<GeoPoint>(this.mOriginalPoints.size());
        for (GeoPoint p : this.mOriginalPoints) {
            result.add(p);
        }
        return result;
    }

    @Deprecated
    public int getColor() {
        return this.mOutlinePaint.getColor();
    }

    @Deprecated
    public float getWidth() {
        return this.mOutlinePaint.getStrokeWidth();
    }

    @Deprecated
    public Paint getPaint() {
        return this.getOutlinePaint();
    }

    @Deprecated
    public void setColor(int color) {
        this.mOutlinePaint.setColor(color);
    }

    @Deprecated
    public void setWidth(float width) {
        this.mOutlinePaint.setStrokeWidth(width);
    }

    public void setOnClickListener(OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public void setPoints(List<GeoPoint> points) {
        this.mOutline.clearPath();
        this.mOriginalPoints = new ArrayList(points.size());
        for (GeoPoint p : points) {
            this.mOriginalPoints.add(p);
        }
        this.mOutline.setPoints(points);
        this.setDefaultInfoWindowLocation();
    }

    public void addPoint(GeoPoint p) {
        this.mOriginalPoints.add(p);
        this.mOutline.addPoint(p);
    }

    public boolean isCloseTo(GeoPoint point, double tolerance, MapView mapView) {
        return this.getCloseTo(point, tolerance, mapView) != null;
    }

    public GeoPoint getCloseTo(GeoPoint point, double tolerance, MapView mapView) {
        return this.mOutline.getCloseTo(point, tolerance, mapView.getProjection(), false);
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        double tolerance;
        Projection pj = mapView.getProjection();
        GeoPoint eventPos = (GeoPoint)pj.fromPixels((int)event.getX(), (int)event.getY());
        GeoPoint closest = this.getCloseTo(eventPos, tolerance = (double)(this.mOutlinePaint.getStrokeWidth() * this.mDensity), mapView);
        if (closest != null) {
            if (this.mOnClickListener == null) {
                return this.onClickDefault(this, mapView, closest);
            }
            return this.mOnClickListener.onClick(this, mapView, closest);
        }
        return false;
    }

    public boolean onClickDefault(Polyline polyline, MapView mapView, GeoPoint eventPos) {
        polyline.setInfoWindowLocation(eventPos);
        polyline.showInfoWindow();
        return true;
    }

    @Override
    public void onDetach(MapView mapView) {
        super.onDetach(mapView);
        this.mOnClickListener = null;
    }

    @Override
    public double getDistance() {
        return this.mOutline.getDistance();
    }

    public static interface OnClickListener {
        public boolean onClick(Polyline var1, MapView var2, GeoPoint var3);
    }
}

