/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.tilesource;

public class TileSourcePolicy {
    public static final int FLAG_NO_BULK = 1;
    public static final int FLAG_NO_PREVENTIVE = 2;
    public static final int FLAG_USER_AGENT_MEANINGFUL = 4;
    public static final int FLAG_USER_AGENT_NORMALIZED = 8;
    private final int mMaxConcurrent;
    private final int mFlags;

    public TileSourcePolicy() {
        this(0, 0);
    }

    public TileSourcePolicy(int pMaxConcurrent, int pFlags) {
        this.mMaxConcurrent = pMaxConcurrent;
        this.mFlags = pFlags;
    }

    public int getMaxConcurrent() {
        return this.mMaxConcurrent;
    }

    public boolean acceptsBulkDownload() {
        return (this.mFlags & 1) == 0;
    }

    private boolean acceptsMeaninglessUserAgent() {
        return (this.mFlags & 4) == 0;
    }

    public boolean normalizesUserAgent() {
        return (this.mFlags & 8) != 0;
    }

    public boolean acceptsPreventive() {
        return (this.mFlags & 2) == 0;
    }

    public boolean acceptsUserAgent(String pUserAgent) {
        if (this.acceptsMeaninglessUserAgent()) {
            return true;
        }
        return pUserAgent != null && pUserAgent.trim().length() > 0 && !pUserAgent.equals("osmdroid");
    }
}

