/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.MotionEvent;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.MapTileProviderBasic;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.TilesOverlay;

public class MinimapOverlay
extends TilesOverlay {
    private int mWidth = 100;
    private int mHeight = 100;
    private int mPadding = 10;
    private int mZoomDifference;
    private final Paint mPaint;

    public MinimapOverlay(Context pContext, Handler pTileRequestCompleteHandler, MapTileProviderBase pTileProvider, int pZoomDifference) {
        super(pTileProvider, pContext);
        this.setZoomDifference(pZoomDifference);
        this.mTileProvider.setTileRequestCompleteHandler(pTileRequestCompleteHandler);
        this.setLoadingLineColor(this.getLoadingBackgroundColor());
        float density = pContext.getResources().getDisplayMetrics().density;
        this.mWidth = (int)((float)this.mWidth * density);
        this.mHeight = (int)((float)this.mHeight * density);
        this.mPaint = new Paint();
        this.mPaint.setColor(-7829368);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(2.0f);
    }

    public MinimapOverlay(Context pContext, Handler pTileRequestCompleteHandler, MapTileProviderBase pTileProvider) {
        this(pContext, pTileRequestCompleteHandler, pTileProvider, 3);
    }

    public MinimapOverlay(Context pContext, Handler pTileRequestCompleteHandler) {
        this(pContext, pTileRequestCompleteHandler, new MapTileProviderBasic(pContext));
    }

    public void setTileSource(ITileSource pTileSource) {
        this.mTileProvider.setTileSource(pTileSource);
    }

    public int getZoomDifference() {
        return this.mZoomDifference;
    }

    public void setZoomDifference(int zoomDifference) {
        this.mZoomDifference = zoomDifference;
    }

    @Override
    public void draw(Canvas c, MapView osmv, boolean shadow) {
        if (shadow) {
            return;
        }
        if (!this.setViewPort(c, osmv)) {
            return;
        }
        osmv.getProjection().save(c, false, true);
        c.drawRect((float)(this.getCanvasRect().left - 2), (float)(this.getCanvasRect().top - 2), (float)(this.getCanvasRect().right + 2), (float)(this.getCanvasRect().bottom + 2), this.mPaint);
        super.drawTiles(c, this.getProjection(), this.getProjection().getZoomLevel(), this.mViewPort);
        osmv.getProjection().restore(c, true);
    }

    @Override
    public boolean onSingleTapUp(MotionEvent pEvent, MapView pMapView) {
        return this.contains(pEvent);
    }

    @Override
    public boolean onDoubleTap(MotionEvent pEvent, MapView pMapView) {
        return this.contains(pEvent);
    }

    @Override
    public boolean onLongPress(MotionEvent pEvent, MapView pMapView) {
        return this.contains(pEvent);
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return false;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setPadding(int padding) {
        this.mPadding = padding;
    }

    public int getPadding() {
        return this.mPadding;
    }

    private boolean contains(MotionEvent pEvent) {
        Rect canvasRect = this.getCanvasRect();
        return canvasRect != null && canvasRect.contains((int)pEvent.getX(), (int)pEvent.getY());
    }

    @Override
    protected boolean setViewPort(Canvas pCanvas, MapView pMapView) {
        double zoomLevel = pMapView.getProjection().getZoomLevel() - (double)this.getZoomDifference();
        if (zoomLevel < (double)this.mTileProvider.getMinimumZoomLevel()) {
            return false;
        }
        int left = pCanvas.getWidth() - this.getPadding() - this.getWidth();
        int top = pCanvas.getHeight() - this.getPadding() - this.getHeight();
        this.setCanvasRect(new Rect(left, top, left + this.getWidth(), top + this.getHeight()));
        this.setProjection(pMapView.getProjection().getOffspring(zoomLevel, this.getCanvasRect()));
        this.getProjection().getMercatorViewPort(this.mViewPort);
        return true;
    }
}

