/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import org.osmdroid.util.MapTileIndex;
import org.osmdroid.util.MapTileList;
import org.osmdroid.util.MapTileListComputer;

public class MapTileListBorderComputer
implements MapTileListComputer {
    private final int mBorder;
    private final boolean mIncludeAll;

    public MapTileListBorderComputer(int pBorder, boolean pIncludeAll) {
        this.mBorder = pBorder;
        this.mIncludeAll = pIncludeAll;
    }

    public int getBorder() {
        return this.mBorder;
    }

    public boolean isIncludeAll() {
        return this.mIncludeAll;
    }

    @Override
    public MapTileList computeFromSource(MapTileList pSource, MapTileList pReuse) {
        MapTileList out = pReuse != null ? pReuse : new MapTileList();
        for (int i = 0; i < pSource.getSize(); ++i) {
            long sourceIndex = pSource.get(i);
            int zoom = MapTileIndex.getZoom(sourceIndex);
            int sourceX = MapTileIndex.getX(sourceIndex);
            int sourceY = MapTileIndex.getY(sourceIndex);
            int power = 1 << zoom;
            for (int j = -this.mBorder; j <= this.mBorder; ++j) {
                for (int k = -this.mBorder; k <= this.mBorder; ++k) {
                    int destX;
                    int destY = sourceY + k;
                    for (destX = sourceX + j; destX < 0; destX += power) {
                    }
                    while (destY < 0) {
                        destY += power;
                    }
                    while (destX >= power) {
                        destX -= power;
                    }
                    while (destY >= power) {
                        destY -= power;
                    }
                    long index = MapTileIndex.getTileIndex(zoom, destX, destY);
                    if (out.contains(index) || pSource.contains(index) && !this.mIncludeAll) continue;
                    out.put(index);
                }
            }
        }
        return out;
    }
}

