/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.Distance;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.LineBuilder;
import org.osmdroid.util.ListPointL;
import org.osmdroid.util.PathBuilder;
import org.osmdroid.util.PointAccepter;
import org.osmdroid.util.PointL;
import org.osmdroid.util.SegmentClipper;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;

class LinearRing {
    private final ArrayList<GeoPoint> mOriginalPoints = new ArrayList();
    private double[] mDistances;
    private long[] mProjectedPoints;
    private final PointL mProjectedCenter = new PointL();
    private final SegmentClipper mSegmentClipper = new SegmentClipper();
    private final Path mPath;
    private boolean mPrecomputed;
    private boolean isHorizontalRepeating = true;
    private boolean isVerticalRepeating = true;
    private final ListPointL mPointsForMilestones = new ListPointL();
    private final PointAccepter mPointAccepter;

    public LinearRing(Path pPath) {
        this.mPath = pPath;
        this.mPointAccepter = new PathBuilder(pPath);
    }

    public LinearRing(LineBuilder pLineBuilder) {
        this.mPath = null;
        this.mPointAccepter = pLineBuilder;
    }

    void clearPath() {
        this.mOriginalPoints.clear();
        this.mProjectedPoints = null;
        this.mDistances = null;
        this.mPrecomputed = false;
        this.mPointAccepter.init();
    }

    void addPoint(GeoPoint pGeoPoint) {
        this.mOriginalPoints.add(pGeoPoint);
        this.mPrecomputed = false;
    }

    ArrayList<GeoPoint> getPoints() {
        return this.mOriginalPoints;
    }

    double[] getDistances() {
        return this.mDistances;
    }

    void setPoints(List<GeoPoint> points) {
        this.clearPath();
        for (GeoPoint point : points) {
            this.addPoint(point);
        }
    }

    PointL buildPathPortion(Projection pProjection, PointL pOffset, boolean pStorePoints) {
        PointL offset;
        int size = this.mOriginalPoints.size();
        if (size < 2) {
            return pOffset;
        }
        if (!this.mPrecomputed) {
            this.computeProjectedAndDistances(pProjection);
            this.mPrecomputed = true;
        }
        if (pOffset != null) {
            offset = pOffset;
        } else {
            offset = new PointL();
            this.getBestOffset(pProjection, offset);
        }
        this.mSegmentClipper.init();
        this.clipAndStore(pProjection, offset, true, pStorePoints, this.mSegmentClipper);
        this.mSegmentClipper.end();
        this.mPath.close();
        return offset;
    }

    void buildLinePortion(Projection pProjection, boolean pStorePoints) {
        int size = this.mOriginalPoints.size();
        if (size < 2) {
            return;
        }
        if (!this.mPrecomputed) {
            this.computeProjectedAndDistances(pProjection);
            this.mPrecomputed = true;
        }
        PointL offset = new PointL();
        this.getBestOffset(pProjection, offset);
        this.mSegmentClipper.init();
        this.clipAndStore(pProjection, offset, false, pStorePoints, this.mSegmentClipper);
        this.mSegmentClipper.end();
    }

    public ListPointL getPointsForMilestones() {
        return this.mPointsForMilestones;
    }

    private void getBestOffset(Projection pProjection, PointL pOffset) {
        double powerDifference = pProjection.getProjectedPowerDifference();
        PointL center = pProjection.getLongPixelsFromProjected(this.mProjectedCenter, powerDifference, false, null);
        Rect screenRect = pProjection.getIntrinsicScreenRect();
        double screenCenterX = (double)(screenRect.left + screenRect.right) / 2.0;
        double screenCenterY = (double)(screenRect.top + screenRect.bottom) / 2.0;
        double worldSize = TileSystem.MapSize(pProjection.getZoomLevel());
        this.getBestOffset((double)center.x, (double)center.y, screenCenterX, screenCenterY, worldSize, pOffset);
    }

    private void getBestOffset(double pPolyCenterX, double pPolyCenterY, double pScreenCenterX, double pScreenCenterY, double pWorldSize, PointL pOffset) {
        int deltaNegative;
        int deltaPositive;
        long worldSize = Math.round(pWorldSize);
        if (!this.isVerticalRepeating) {
            deltaPositive = 0;
            deltaNegative = 0;
        } else {
            deltaPositive = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, 0L, worldSize);
            deltaNegative = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, 0L, -worldSize);
        }
        pOffset.y = worldSize * (long)(deltaPositive > deltaNegative ? deltaPositive : -deltaNegative);
        if (!this.isHorizontalRepeating) {
            deltaPositive = 0;
            deltaNegative = 0;
        } else {
            deltaPositive = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, worldSize, 0L);
            deltaNegative = this.getBestOffset(pPolyCenterX, pPolyCenterY, pScreenCenterX, pScreenCenterY, -worldSize, 0L);
        }
        pOffset.x = worldSize * (long)(deltaPositive > deltaNegative ? deltaPositive : -deltaNegative);
    }

    private int getBestOffset(double pPolyCenterX, double pPolyCenterY, double pScreenCenterX, double pScreenCenterY, long pDeltaX, long pDeltaY) {
        double squaredDistance = 0.0;
        int i = 0;
        while (true) {
            double tmpSquaredDistance = Distance.getSquaredDistanceToPoint(pPolyCenterX + (double)((long)i * pDeltaX), pPolyCenterY + (double)((long)i * pDeltaY), pScreenCenterX, pScreenCenterY);
            if (i != 0 && !(squaredDistance > tmpSquaredDistance)) break;
            squaredDistance = tmpSquaredDistance;
            ++i;
        }
        return i - 1;
    }

    private void computeProjectedAndDistances(Projection pProjection) {
        if (this.mProjectedPoints == null || this.mProjectedPoints.length != this.mOriginalPoints.size() * 2) {
            this.mProjectedPoints = new long[this.mOriginalPoints.size() * 2];
        }
        if (this.mDistances == null || this.mDistances.length != this.mOriginalPoints.size()) {
            this.mDistances = new double[this.mOriginalPoints.size()];
        }
        long minX = 0L;
        long maxX = 0L;
        long minY = 0L;
        long maxY = 0L;
        int index = 0;
        PointL previous = new PointL();
        PointL current = new PointL();
        GeoPoint previousGeo = new GeoPoint(0.0, 0.0);
        for (GeoPoint currentGeo : this.mOriginalPoints) {
            pProjection.toProjectedPixels(currentGeo.getLatitude(), currentGeo.getLongitude(), false, current);
            if (index == 0) {
                this.mDistances[index] = 0.0;
                minX = maxX = current.x;
                minY = maxY = current.y;
            } else {
                this.mDistances[index] = currentGeo.distanceToAsDouble(previousGeo);
                this.setCloserPoint(previous, current, pProjection.mProjectedMapSize);
                if (minX > current.x) {
                    minX = current.x;
                }
                if (maxX < current.x) {
                    maxX = current.x;
                }
                if (minY > current.y) {
                    minY = current.y;
                }
                if (maxY < current.y) {
                    maxY = current.y;
                }
            }
            this.mProjectedPoints[2 * index] = current.x;
            this.mProjectedPoints[2 * index + 1] = current.y;
            previousGeo.setCoords(currentGeo.getLatitude(), currentGeo.getLongitude());
            previous.set(current.x, current.y);
            ++index;
        }
        this.mProjectedCenter.set((minX + maxX) / 2L, (minY + maxY) / 2L);
    }

    private void clipAndStore(Projection pProjection, PointL pOffset, boolean pClosePath, boolean pStorePoints, SegmentClipper pSegmentClipper) {
        this.mPointsForMilestones.clear();
        double powerDifference = pProjection.getProjectedPowerDifference();
        PointL projected = new PointL();
        PointL point = new PointL();
        PointL first = new PointL();
        for (int i = 0; i < this.mProjectedPoints.length; i += 2) {
            projected.set(this.mProjectedPoints[i], this.mProjectedPoints[i + 1]);
            pProjection.getLongPixelsFromProjected(projected, powerDifference, false, point);
            long x = point.x + pOffset.x;
            long y = point.y + pOffset.y;
            if (pStorePoints) {
                this.mPointsForMilestones.add(x, y);
            }
            if (pSegmentClipper != null) {
                pSegmentClipper.add(x, y);
            }
            if (i != 0) continue;
            first.set(x, y);
        }
        if (pClosePath) {
            if (pSegmentClipper != null) {
                pSegmentClipper.add(first.x, first.y);
            }
            if (pStorePoints) {
                this.mPointsForMilestones.add(first.x, first.y);
            }
        }
    }

    private void setCloserPoint(PointL pPrevious, PointL pNext, double pWorldSize) {
        while (this.isHorizontalRepeating && Math.abs((double)pNext.x - pWorldSize - (double)pPrevious.x) < (double)Math.abs(pNext.x - pPrevious.x)) {
            pNext.x = (long)((double)pNext.x - pWorldSize);
        }
        while (this.isHorizontalRepeating && Math.abs((double)pNext.x + pWorldSize - (double)pPrevious.x) < (double)Math.abs(pNext.x - pPrevious.x)) {
            pNext.x = (long)((double)pNext.x + pWorldSize);
        }
        while (this.isVerticalRepeating && Math.abs((double)pNext.y - pWorldSize - (double)pPrevious.y) < (double)Math.abs(pNext.y - pPrevious.y)) {
            pNext.y = (long)((double)pNext.y - pWorldSize);
        }
        while (this.isVerticalRepeating && Math.abs((double)pNext.y + pWorldSize - (double)pPrevious.y) < (double)Math.abs(pNext.y - pPrevious.y)) {
            pNext.y = (long)((double)pNext.y + pWorldSize);
        }
    }

    boolean isCloseTo(GeoPoint pPoint, double tolerance, Projection pProjection, boolean pClosePath) {
        if (!this.mPrecomputed) {
            this.computeProjectedAndDistances(pProjection);
            this.mPrecomputed = true;
        }
        Point pixel = pProjection.toPixels(pPoint, null);
        PointL offset = new PointL();
        this.getBestOffset(pProjection, offset);
        this.clipAndStore(pProjection, offset, pClosePath, true, null);
        double squaredTolerance = tolerance * tolerance;
        PointL point0 = new PointL();
        PointL point1 = new PointL();
        boolean first = true;
        for (PointL point : this.mPointsForMilestones) {
            point1.set(point);
            if (first) {
                first = false;
            } else if (squaredTolerance > Distance.getSquaredDistanceToSegment(pixel.x, pixel.y, point0.x, point0.y, point1.x, point1.y)) {
                return true;
            }
            point0.set(point1);
        }
        return false;
    }

    public void setClipArea(long pXMin, long pYMin, long pXMax, long pYMax) {
        this.mSegmentClipper.set(pXMin, pYMin, pXMax, pYMax, this.mPointAccepter, this.mPath != null);
    }

    public void setClipArea(MapView pMapView) {
        double border = 0.1;
        int halfWidth = pMapView.getWidth() / 2;
        int halfHeight = pMapView.getHeight() / 2;
        double radius = Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        int scaledRadius = (int)(radius * 1.1);
        this.setClipArea(halfWidth - scaledRadius, halfHeight - scaledRadius, halfWidth + scaledRadius, halfHeight + scaledRadius);
        this.isHorizontalRepeating = pMapView.isHorizontalMapRepetitionEnabled();
        this.isVerticalRepeating = pMapView.isVerticalMapRepetitionEnabled();
    }
}

