/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.util;

import android.graphics.Point;
import android.graphics.Rect;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.PointL;
import org.osmdroid.util.RectL;

public final class TileSystem {
    @Deprecated
    public static final double EarthRadius = 6378137.0;
    public static final double MinLatitude = -85.05112877980659;
    public static final double MaxLatitude = 85.05112877980659;
    public static final double MinLongitude = -180.0;
    public static final double MaxLongitude = 180.0;

    public static void setTileSize(int tileSize) {
        microsoft.mappoint.TileSystem.setTileSize(tileSize);
    }

    public static int getTileSize() {
        return microsoft.mappoint.TileSystem.getTileSize();
    }

    public static double getTileSize(double pZoomLevel) {
        return TileSystem.MapSize(pZoomLevel - (double)TileSystem.getInputTileZoomLevel(pZoomLevel));
    }

    public static int getInputTileZoomLevel(double pZoomLevel) {
        return MyMath.floorToInt(pZoomLevel);
    }

    @Deprecated
    public static int MapSize(int levelOfDetail) {
        return microsoft.mappoint.TileSystem.MapSize(levelOfDetail);
    }

    public static double MapSize(double pZoomLevel) {
        return (double)TileSystem.getTileSize() * TileSystem.getFactor(pZoomLevel);
    }

    public static double getFactor(double pZoomLevel) {
        return Math.pow(2.0, pZoomLevel);
    }

    public static double GroundResolution(double latitude, int levelOfDetail) {
        return TileSystem.GroundResolution(latitude, (double)levelOfDetail);
    }

    public static double GroundResolution(double latitude, double zoomLevel) {
        return TileSystem.GroundResolutionMapSize(TileSystem.wrap(latitude, -90.0, 90.0, 180.0), TileSystem.MapSize(zoomLevel));
    }

    public static double GroundResolutionMapSize(double latitude, double mapSize) {
        latitude = TileSystem.Clip(latitude, -85.05112877980659, 85.05112877980659);
        return Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / mapSize;
    }

    public static double MapScale(double latitude, int levelOfDetail, int screenDpi) {
        return TileSystem.GroundResolution(latitude, levelOfDetail) * (double)screenDpi / 0.0254;
    }

    @Deprecated
    public static Point LatLongToPixelXY(double latitude, double longitude, int levelOfDetail, Point reuse) {
        return microsoft.mappoint.TileSystem.LatLongToPixelXY(TileSystem.wrap(latitude, -90.0, 90.0, 180.0), TileSystem.wrap(longitude, -180.0, 180.0, 360.0), levelOfDetail, reuse);
    }

    @Deprecated
    public static PointL LatLongToPixelXY(double latitude, double longitude, double zoomLevel, PointL reuse) {
        return TileSystem.LatLongToPixelXYMapSize(TileSystem.wrap(latitude, -90.0, 90.0, 180.0), TileSystem.wrap(longitude, -180.0, 180.0, 360.0), TileSystem.MapSize(zoomLevel), reuse);
    }

    @Deprecated
    public static PointL LatLongToPixelXYMapSize(double latitude, double longitude, double mapSize, PointL reuse) {
        return TileSystem.getMercatorFromGeo(latitude, longitude, mapSize, reuse, true);
    }

    @Deprecated
    public static GeoPoint PixelXYToLatLong(int pixelX, int pixelY, int levelOfDetail, GeoPoint reuse) {
        int mapSize = TileSystem.MapSize(levelOfDetail);
        return microsoft.mappoint.TileSystem.PixelXYToLatLong(MyMath.floorToInt(TileSystem.wrap(pixelX, 0.0, mapSize - 1, mapSize)), MyMath.floorToInt(TileSystem.wrap(pixelY, 0.0, mapSize - 1, mapSize)), levelOfDetail, reuse);
    }

    @Deprecated
    public static GeoPoint PixelXYToLatLong(int pixelX, int pixelY, double zoomLevel, GeoPoint reuse) {
        return TileSystem.getGeoFromMercator(pixelX, pixelY, TileSystem.MapSize(zoomLevel), reuse, true, true);
    }

    public static GeoPoint PixelXYToLatLongWithoutWrap(int pixelX, int pixelY, double zoomLevel, GeoPoint reuse) {
        double mapSize = TileSystem.MapSize(zoomLevel);
        return TileSystem.PixelXYToLatLongMapSizeWithoutWrap(pixelX, pixelY, mapSize, reuse);
    }

    public static double getX01FromLongitude(double longitude, boolean wrapEnabled) {
        longitude = wrapEnabled ? TileSystem.Clip(longitude, -180.0, 180.0) : longitude;
        return (longitude + 180.0) / 360.0;
    }

    public static double getY01FromLatitude(double latitude, boolean wrapEnabled) {
        latitude = wrapEnabled ? TileSystem.Clip(latitude, -85.05112877980659, 85.05112877980659) : latitude;
        double sinus = Math.sin(latitude * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sinus) / (1.0 - sinus)) / (Math.PI * 4);
        return wrapEnabled ? TileSystem.Clip(y, 0.0, 1.0) : y;
    }

    public static double getX01FromLongitudeWithoutWrap(double longitude) {
        return (longitude + 180.0) / 360.0;
    }

    public static double getY01FromLatitudeWithoutWrap(double latitude) {
        double sinus = Math.sin(latitude * Math.PI / 180.0);
        return 0.5 - Math.log((1.0 + sinus) / (1.0 - sinus)) / (Math.PI * 4);
    }

    @Deprecated
    public static GeoPoint PixelXYToLatLongMapSize(int pixelX, int pixelY, double mapSize, GeoPoint reuse, boolean horizontalWrapEnabled, boolean verticalWrapEnabled) {
        return TileSystem.getGeoFromMercator(pixelX, pixelY, mapSize, reuse, horizontalWrapEnabled, verticalWrapEnabled);
    }

    public static GeoPoint PixelXYToLatLongMapSizeWithoutWrap(int pixelX, int pixelY, double mapSize, GeoPoint reuse) {
        GeoPoint out = reuse == null ? new GeoPoint(0.0, 0.0) : reuse;
        double x = (double)pixelX / mapSize - 0.5;
        double y = 0.5 - (double)pixelY / mapSize;
        double latitude = 90.0 - 360.0 * Math.atan(Math.exp(-y * 2.0 * Math.PI)) / Math.PI;
        double longitude = 360.0 * x;
        out.setLatitude(latitude);
        out.setLongitude(longitude);
        return out;
    }

    public static double Clip(double n, double minValue, double maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    @Deprecated
    public static Point PixelXYToTileXY(int pixelX, int pixelY, Point reuse) {
        return microsoft.mappoint.TileSystem.PixelXYToTileXY(pixelX, pixelY, reuse);
    }

    @Deprecated
    public static Point PixelXYToTileXY(int pPixelX, int pPixelY, double pTileSize, Point pReuse) {
        Point out = pReuse == null ? new Point() : pReuse;
        out.x = TileSystem.getTileFromMercator(pPixelX, pTileSize);
        out.y = TileSystem.getTileFromMercator(pPixelY, pTileSize);
        return out;
    }

    @Deprecated
    public static Rect PixelXYToTileXY(Rect rect, double pTileSize, Rect pReuse) {
        Rect out = pReuse == null ? new Rect() : pReuse;
        out.left = TileSystem.getTileFromMercator(rect.left, pTileSize);
        out.top = TileSystem.getTileFromMercator(rect.top, pTileSize);
        out.right = TileSystem.getTileFromMercator(rect.right, pTileSize);
        out.bottom = TileSystem.getTileFromMercator(rect.bottom, pTileSize);
        return out;
    }

    @Deprecated
    public static Point TileXYToPixelXY(int tileX, int tileY, Point reuse) {
        return microsoft.mappoint.TileSystem.TileXYToPixelXY(tileX, tileY, reuse);
    }

    @Deprecated
    public static PointL TileXYToPixelXY(int pTileX, int pTileY, double pTileSize, PointL pReuse) {
        PointL out = pReuse == null ? new PointL() : pReuse;
        out.x = TileSystem.getMercatorFromTile(pTileX, pTileSize);
        out.y = TileSystem.getMercatorFromTile(pTileY, pTileSize);
        return out;
    }

    public static String TileXYToQuadKey(int tileX, int tileY, int levelOfDetail) {
        return microsoft.mappoint.TileSystem.TileXYToQuadKey(tileX, tileY, levelOfDetail);
    }

    public static Point QuadKeyToTileXY(String quadKey, Point reuse) {
        return microsoft.mappoint.TileSystem.QuadKeyToTileXY(quadKey, reuse);
    }

    public static double getBoundingBoxZoom(BoundingBox pBoundingBox, int pScreenWidth, int pScreenHeight) {
        double longitudeZoom = TileSystem.getLongitudeZoom(pBoundingBox.getLonEast(), pBoundingBox.getLonWest(), pScreenWidth);
        double latitudeZoom = TileSystem.getLatitudeZoom(pBoundingBox.getLatNorth(), pBoundingBox.getLatSouth(), pScreenHeight);
        if (longitudeZoom == Double.MIN_VALUE) {
            return latitudeZoom;
        }
        if (latitudeZoom == Double.MIN_VALUE) {
            return longitudeZoom;
        }
        return Math.min(latitudeZoom, longitudeZoom);
    }

    public static double getLongitudeZoom(double pEast, double pWest, int pScreenWidth) {
        double x01West = TileSystem.getX01FromLongitude(pWest, true);
        double x01East = TileSystem.getX01FromLongitude(pEast, true);
        double span = x01East - x01West;
        if (span < 0.0) {
            span += 1.0;
        }
        if (span == 0.0) {
            return Double.MIN_VALUE;
        }
        return Math.log((double)pScreenWidth / span / (double)TileSystem.getTileSize()) / Math.log(2.0);
    }

    public static double getLatitudeZoom(double pNorth, double pSouth, int pScreenHeight) {
        double y01North = TileSystem.getY01FromLatitude(pNorth, true);
        double y01South = TileSystem.getY01FromLatitude(pSouth, true);
        double span = y01South - y01North;
        if (span <= 0.0) {
            return Double.MIN_VALUE;
        }
        return Math.log((double)pScreenHeight / span / (double)TileSystem.getTileSize()) / Math.log(2.0);
    }

    private static double wrap(double n, double minValue, double maxValue, double interval) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be smaller than maxValue: " + minValue + ">" + maxValue);
        }
        if (interval > maxValue - minValue + 1.0) {
            throw new IllegalArgumentException("interval must be equal or smaller than maxValue-minValue: min: " + minValue + " max:" + maxValue + " int:" + interval);
        }
        while (n < minValue) {
            n += interval;
        }
        while (n > maxValue) {
            n -= interval;
        }
        return n;
    }

    public static long getMercatorYFromLatitude(double pLatitude, double pMapSize, boolean wrapEnabled) {
        return TileSystem.getMercatorFromXY01(TileSystem.getY01FromLatitude(pLatitude, wrapEnabled), pMapSize, wrapEnabled);
    }

    public static long getMercatorXFromLongitude(double pLongitude, double pMapSize, boolean wrapEnabled) {
        return TileSystem.getMercatorFromXY01(TileSystem.getX01FromLongitude(pLongitude, wrapEnabled), pMapSize, wrapEnabled);
    }

    public static long getMercatorFromXY01(double pXY01, double pMapSize, boolean wrapEnabled) {
        return TileSystem.ClipToLong(pXY01 * pMapSize, pMapSize, wrapEnabled);
    }

    public static double getLatitudeFromY01(double pY01, boolean wrapEnabled) {
        double latitude = 90.0 - 360.0 * Math.atan(Math.exp((pY01 - 0.5) * 2.0 * Math.PI)) / Math.PI;
        return wrapEnabled ? TileSystem.Clip(latitude, -85.05112877980659, 85.05112877980659) : latitude;
    }

    public static double getLongitudeFromX01(double pX01, boolean wrapEnabled) {
        return -180.0 + 360.0 * (wrapEnabled ? TileSystem.Clip(pX01, 0.0, 1.0) : pX01);
    }

    public static long getCleanMercator(long pMercator, double pMercatorMapSize, boolean wrapEnabled) {
        return TileSystem.ClipToLong(wrapEnabled ? TileSystem.wrap(pMercator, 0.0, pMercatorMapSize, pMercatorMapSize) : (double)pMercator, pMercatorMapSize, wrapEnabled);
    }

    public static long ClipToLong(double value, double max, boolean wrapEnabled) {
        long longValue = MyMath.floorToLong(value - 0.5);
        return wrapEnabled ? TileSystem.Clip(longValue, 0L, MyMath.floorToLong(max - 1.0)) : longValue;
    }

    public static long Clip(long n, long minValue, long maxValue) {
        return Math.min(Math.max(n, minValue), maxValue);
    }

    public static int truncateToInt(long value) {
        return (int)Math.max(Math.min(value, Integer.MAX_VALUE), Integer.MIN_VALUE);
    }

    public static PointL getMercatorFromGeo(double pLatitude, double pLongitude, double pMapSize, PointL pReuse, boolean wrapEnabled) {
        PointL out = pReuse == null ? new PointL() : pReuse;
        out.x = TileSystem.getMercatorXFromLongitude(pLongitude, pMapSize, wrapEnabled);
        out.y = TileSystem.getMercatorYFromLatitude(pLatitude, pMapSize, wrapEnabled);
        return out;
    }

    public static GeoPoint getGeoFromMercator(long pMercatorX, long pMercatorY, double pMapSize, GeoPoint pReuse, boolean horizontalWrapEnabled, boolean verticalWrapEnabled) {
        GeoPoint out = pReuse == null ? new GeoPoint(0.0, 0.0) : pReuse;
        out.setLatitude(TileSystem.getLatitudeFromY01(TileSystem.getXY01FromMercator(pMercatorY, pMapSize, verticalWrapEnabled), verticalWrapEnabled));
        out.setLongitude(TileSystem.getLongitudeFromX01(TileSystem.getXY01FromMercator(pMercatorX, pMapSize, horizontalWrapEnabled), horizontalWrapEnabled));
        return out;
    }

    public static double getXY01FromMercator(long pMercator, double pMapSize, boolean wrapEnabled) {
        return wrapEnabled ? TileSystem.Clip((double)pMercator / pMapSize, 0.0, 1.0) : (double)pMercator / pMapSize;
    }

    public static double getRandomLongitude(double pRandom01) {
        return pRandom01 * 360.0 + -180.0;
    }

    public static double getRandomLatitude(double pRandom01, double pMinLatitude) {
        return pRandom01 * (85.05112877980659 - pMinLatitude) + pMinLatitude;
    }

    public static int getTileFromMercator(long pMercator, double pTileSize) {
        return MyMath.floorToInt((double)pMercator / pTileSize);
    }

    public static Rect getTileFromMercator(RectL pMercatorRect, double pTileSize, Rect pReuse) {
        Rect out = pReuse == null ? new Rect() : pReuse;
        out.left = TileSystem.getTileFromMercator(pMercatorRect.left, pTileSize);
        out.top = TileSystem.getTileFromMercator(pMercatorRect.top, pTileSize);
        out.right = TileSystem.getTileFromMercator(pMercatorRect.right, pTileSize);
        out.bottom = TileSystem.getTileFromMercator(pMercatorRect.bottom, pTileSize);
        return out;
    }

    public static long getMercatorFromTile(int pTile, double pTileSize) {
        return Math.round((double)pTile * pTileSize);
    }
}

