/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.util.Log;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import microsoft.mappoint.TileSystem;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IRegisterReceiver;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.MapTileFileStorageProviderBase;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.TileSourceFactory;
import org.osmdroid.tileprovider.util.Counters;

public class MapTileFilesystemProvider
extends MapTileFileStorageProviderBase {
    private final long mMaximumCachedFileAge;
    private final AtomicReference<ITileSource> mTileSource = new AtomicReference();

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver) {
        this(pRegisterReceiver, TileSourceFactory.DEFAULT_TILE_SOURCE);
    }

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver, ITileSource aTileSource) {
        this(pRegisterReceiver, aTileSource, 604800000L);
    }

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, long pMaximumCachedFileAge) {
        this(pRegisterReceiver, pTileSource, pMaximumCachedFileAge, Configuration.getInstance().getTileFileSystemThreads(), Configuration.getInstance().getTileFileSystemMaxQueueSize());
    }

    public MapTileFilesystemProvider(IRegisterReceiver pRegisterReceiver, ITileSource pTileSource, long pMaximumCachedFileAge, int pThreadPoolSize, int pPendingQueueSize) {
        super(pRegisterReceiver, pThreadPoolSize, pPendingQueueSize);
        this.setTileSource(pTileSource);
        this.mMaximumCachedFileAge = pMaximumCachedFileAge;
    }

    @Override
    public boolean getUsesDataConnection() {
        return false;
    }

    @Override
    protected String getName() {
        return "File System Cache Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "filesystem";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        ITileSource tileSource = this.mTileSource.get();
        return tileSource != null ? tileSource.getMaximumZoomLevel() : TileSystem.getMaximumZoomLevel();
    }

    @Override
    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource.set(pTileSource);
    }

    protected class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        protected TileLoader() {
            super(MapTileFilesystemProvider.this);
        }

        @Override
        public Drawable loadTile(MapTileRequestState pState) throws MapTileModuleProviderBase.CantContinueException {
            ITileSource tileSource = (ITileSource)MapTileFilesystemProvider.this.mTileSource.get();
            if (tileSource == null) {
                return null;
            }
            MapTile tile = pState.getMapTile();
            if (!MapTileFileStorageProviderBase.isSdCardAvailable()) {
                if (Configuration.getInstance().isDebugMode()) {
                    Log.d((String)"OsmDroid", (String)("No sdcard - do nothing for tile: " + tile));
                }
                ++Counters.fileCacheMiss;
                return null;
            }
            File file = new File(Configuration.getInstance().getOsmdroidTileCache(), tileSource.getTileRelativeFilenameString(tile) + ".tile");
            if (file.exists()) {
                try {
                    boolean fileExpired;
                    Drawable drawable = tileSource.getDrawable(file.getPath());
                    long now = System.currentTimeMillis();
                    long lastModified = file.lastModified();
                    boolean bl = fileExpired = lastModified < now - MapTileFilesystemProvider.this.mMaximumCachedFileAge;
                    if (fileExpired && drawable != null) {
                        if (Configuration.getInstance().isDebugMode()) {
                            Log.d((String)"OsmDroid", (String)("Tile expired: " + tile));
                        }
                        ExpirableBitmapDrawable.setDrawableExpired(drawable);
                    }
                    ++Counters.fileCacheHit;
                    return drawable;
                }
                catch (BitmapTileSourceBase.LowMemoryException e) {
                    Log.w((String)"OsmDroid", (String)("LowMemoryException downloading MapTile: " + tile + " : " + e));
                    ++Counters.fileCacheOOM;
                    throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileFilesystemProvider.this, (Throwable)e);
                }
            }
            ++Counters.fileCacheMiss;
            return null;
        }
    }
}

