/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.cachemanager;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.osmdroid.config.Configuration;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileProviderBase;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.util.MyMath;
import org.osmdroid.util.TileSystem;
import org.osmdroid.views.MapView;

public class CacheManager {
    protected final MapTileProviderBase mTileProvider;
    protected final IFilesystemCache mTileWriter;
    protected final MapView mMapView;
    protected Set<CacheManagerTask> mPendingTasks = new HashSet<CacheManagerTask>();

    public CacheManager(MapView mapView) {
        this.mTileProvider = mapView.getTileProvider();
        this.mTileWriter = mapView.getTileProvider().getTileWriter();
        this.mMapView = mapView;
    }

    public CacheManager(MapView mapView, IFilesystemCache writer) {
        this.mTileProvider = mapView.getTileProvider();
        this.mTileWriter = writer;
        this.mMapView = mapView;
    }

    public int getPendingJobs() {
        return this.mPendingTasks.size();
    }

    public static Point getMapTileFromCoordinates(double aLat, double aLon, int zoom) {
        int y = (int)Math.floor((1.0 - Math.log(Math.tan(aLat * Math.PI / 180.0) + 1.0 / Math.cos(aLat * Math.PI / 180.0)) / Math.PI) / 2.0 * (double)(1 << zoom));
        int x = (int)Math.floor((aLon + 180.0) / 360.0 * (double)(1 << zoom));
        return new Point(x, y);
    }

    public static GeoPoint getCoordinatesFromMapTile(int x, int y, int zoom) {
        double n = Math.PI - Math.PI * 2 * (double)y / (double)(1 << zoom);
        double lat = 57.29577951308232 * Math.atan(0.5 * (Math.exp(n) - Math.exp(-n)));
        double lon = 360.0 * (double)x / (double)(1 << zoom) - 180.0;
        return new GeoPoint(lat, lon);
    }

    public static File getFileName(ITileSource tileSource, MapTile tile) {
        File file = new File(Configuration.getInstance().getOsmdroidTileCache(), tileSource.getTileRelativeFilenameString(tile) + ".tile");
        return file;
    }

    /*
     * Exception decompiling
     */
    public boolean loadTile(OnlineTileSourceBase tileSource, MapTile tile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 38[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int possibleTilesInArea(BoundingBox bb, int zoomMin, int zoomMax) {
        int total = 0;
        for (int zoomLevel = zoomMin; zoomLevel <= zoomMax; ++zoomLevel) {
            Point mLowerRight = CacheManager.getMapTileFromCoordinates(bb.getLatSouth(), bb.getLonEast(), zoomLevel);
            Point mUpperLeft = CacheManager.getMapTileFromCoordinates(bb.getLatNorth(), bb.getLonWest(), zoomLevel);
            int y = mLowerRight.y - mUpperLeft.y + 1;
            int x = mLowerRight.x - mUpperLeft.x + 1;
            int nbTilesForZoomLevel = x * y;
            total += nbTilesForZoomLevel;
        }
        return total;
    }

    public int possibleTilesCovered(ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax) {
        ArrayList<Point> tilePoints = new ArrayList<Point>();
        GeoPoint prevPoint = null;
        Point prevTile = null;
        for (int zoomLevel = zoomMin; zoomLevel <= zoomMax; ++zoomLevel) {
            for (GeoPoint geoPoint : geoPoints) {
                Point tileAround;
                int yAround;
                int xAround;
                int ofsy;
                int ofsx;
                Point tile;
                double d = TileSystem.GroundResolution(geoPoint.getLatitude(), zoomLevel);
                if (tilePoints.size() != 0) {
                    if (prevPoint != null) {
                        double leadCoef = (geoPoint.getLatitude() - prevPoint.getLatitude()) / (geoPoint.getLongitude() - prevPoint.getLongitude());
                        double brng = geoPoint.getLongitude() > prevPoint.getLongitude() ? 1.5707963267948966 - Math.atan(leadCoef) : 4.71238898038469 - Math.atan(leadCoef);
                        GeoPoint wayPoint = new GeoPoint(prevPoint.getLatitude(), prevPoint.getLongitude());
                        while ((geoPoint.getLatitude() > prevPoint.getLatitude() && wayPoint.getLatitude() < geoPoint.getLatitude() || geoPoint.getLatitude() < prevPoint.getLatitude() && wayPoint.getLatitude() > geoPoint.getLatitude()) && (geoPoint.getLongitude() > prevPoint.getLongitude() && wayPoint.getLongitude() < geoPoint.getLongitude() || geoPoint.getLongitude() < prevPoint.getLongitude() && wayPoint.getLongitude() > geoPoint.getLongitude())) {
                            Point lastPoint = new Point();
                            TileSystem.LatLongToPixelXY(geoPoint.getLatitude(), geoPoint.getLongitude(), zoomLevel, lastPoint);
                            double prevLatRad = wayPoint.getLatitude() * Math.PI / 180.0;
                            double prevLonRad = wayPoint.getLongitude() * Math.PI / 180.0;
                            double latRad = Math.asin(Math.sin(prevLatRad) * Math.cos(d / 6378137.0) + Math.cos(prevLatRad) * Math.sin(d / 6378137.0) * Math.cos(brng));
                            double lonRad = prevLonRad + Math.atan2(Math.sin(brng) * Math.sin(d / 6378137.0) * Math.cos(prevLatRad), Math.cos(d / 6378137.0) - Math.sin(prevLatRad) * Math.sin(latRad));
                            wayPoint.setLatitude(latRad * 180.0 / Math.PI);
                            wayPoint.setLongitude(lonRad * 180.0 / Math.PI);
                            tile = CacheManager.getMapTileFromCoordinates(wayPoint.getLatitude(), wayPoint.getLongitude(), zoomLevel);
                            if (tile.equals((Object)prevTile)) continue;
                            ofsx = tile.x >= 0 ? 0 : -tile.x;
                            ofsy = tile.y >= 0 ? 0 : -tile.y;
                            for (xAround = tile.x + ofsx; xAround <= tile.x + 1 + ofsx; ++xAround) {
                                for (yAround = tile.y + ofsy; yAround <= tile.y + 1 + ofsy; ++yAround) {
                                    tileAround = new Point(xAround, yAround);
                                    boolean foundTilePoint = false;
                                    for (Point inList : tilePoints) {
                                        if (!tileAround.equals(inList.x, inList.y)) continue;
                                        foundTilePoint = true;
                                        break;
                                    }
                                    if (foundTilePoint) continue;
                                    tilePoints.add(0, tileAround);
                                }
                            }
                            prevTile = tile;
                        }
                    }
                } else {
                    prevTile = tile = CacheManager.getMapTileFromCoordinates(geoPoint.getLatitude(), geoPoint.getLongitude(), zoomLevel);
                    ofsx = tile.x >= 0 ? 0 : -tile.x;
                    ofsy = tile.y >= 0 ? 0 : -tile.y;
                    for (xAround = tile.x + ofsx; xAround <= tile.x + 1 + ofsx; ++xAround) {
                        for (yAround = tile.y + ofsy; yAround <= tile.y + 1 + ofsy; ++yAround) {
                            tileAround = new Point(xAround, yAround);
                            tilePoints.add(0, tileAround);
                        }
                    }
                }
                prevPoint = geoPoint;
            }
        }
        Log.d((String)"OsmDroid", (String)("need " + tilePoints.size() + " Tiles"));
        return tilePoints.size();
    }

    protected String zoomMessage(int zoomLevel, int zoomMin, int zoomMax) {
        return "Handling zoom level: " + zoomLevel + " (from " + zoomMin + " to " + zoomMax + ")";
    }

    public DownloadingTask downloadAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax) {
        DownloadingTask task = new DownloadingTask(ctx, bb, zoomMin, zoomMax, null, true);
        task.execute(new Object[0]);
        this.mPendingTasks.add(task);
        return task;
    }

    public DownloadingTask downloadAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax) {
        DownloadingTask task = new DownloadingTask(ctx, geoPoints, zoomMin, zoomMax, null, true);
        task.execute(new Object[0]);
        this.mPendingTasks.add(task);
        return task;
    }

    public DownloadingTask downloadAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        DownloadingTask task = new DownloadingTask(ctx, bb, zoomMin, zoomMax, callback, true);
        task.execute(new Object[0]);
        this.mPendingTasks.add(task);
        return task;
    }

    public DownloadingTask downloadAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        DownloadingTask task = new DownloadingTask(ctx, geoPoints, zoomMin, zoomMax, callback, true);
        task.execute(new Object[0]);
        this.mPendingTasks.add(task);
        return task;
    }

    public DownloadingTask downloadAreaAsyncNoUI(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        DownloadingTask task = new DownloadingTask(ctx, geoPoints, zoomMin, zoomMax, callback, false);
        task.execute(new Object[0]);
        this.mPendingTasks.add(task);
        return task;
    }

    public DownloadingTask downloadAreaAsyncNoUI(Context ctx, BoundingBox bb, int zoomMin, int zoomMax, CacheManagerCallback callback) {
        DownloadingTask task = new DownloadingTask(ctx, bb, zoomMin, zoomMax, callback, false);
        task.execute(new Object[0]);
        this.mPendingTasks.add(task);
        return task;
    }

    public void cancelAllJobs() {
        for (CacheManagerTask next : this.mPendingTasks) {
            next.cancel(true);
        }
        this.mPendingTasks.clear();
    }

    public CleaningTask cleanAreaAsync(Context ctx, BoundingBox bb, int zoomMin, int zoomMax) {
        CleaningTask task = new CleaningTask(ctx, bb, zoomMin, zoomMax);
        task.execute(new Object[0]);
        this.mPendingTasks.add(task);
        return task;
    }

    public CleaningTask cleanAreaAsync(Context ctx, ArrayList<GeoPoint> geoPoints, int zoomMin, int zoomMax) {
        BoundingBox extendedBounds = this.extendedBoundsFromGeoPoints(geoPoints, zoomMin);
        CleaningTask task = new CleaningTask(ctx, extendedBounds, zoomMin, zoomMax);
        task.execute(new Object[0]);
        this.mPendingTasks.add(task);
        return task;
    }

    public BoundingBox extendedBoundsFromGeoPoints(ArrayList<GeoPoint> geoPoints, int minZoomLevel) {
        BoundingBox bb = BoundingBox.fromGeoPoints(geoPoints);
        Point mLowerRight = CacheManager.getMapTileFromCoordinates(bb.getLatSouth(), bb.getLonEast(), minZoomLevel);
        GeoPoint lowerRightPoint = CacheManager.getCoordinatesFromMapTile(mLowerRight.x + 1, mLowerRight.y + 1, minZoomLevel);
        Point mUpperLeft = CacheManager.getMapTileFromCoordinates(bb.getLatNorth(), bb.getLonWest(), minZoomLevel);
        GeoPoint upperLeftPoint = CacheManager.getCoordinatesFromMapTile(mUpperLeft.x - 1, mUpperLeft.y - 1, minZoomLevel);
        BoundingBox extendedBounds = new BoundingBox(upperLeftPoint.getLatitude(), upperLeftPoint.getLongitude(), lowerRightPoint.getLatitude(), lowerRightPoint.getLongitude());
        return extendedBounds;
    }

    public long currentCacheUsage() {
        return this.directorySize(Configuration.getInstance().getOsmdroidTileCache());
    }

    public long cacheCapacity() {
        return Configuration.getInstance().getTileFileSystemCacheMaxBytes();
    }

    public long directorySize(File pDirectory) {
        long usedCacheSpace = 0L;
        File[] z = pDirectory.listFiles();
        if (z != null) {
            for (File file : z) {
                if (file.isFile()) {
                    usedCacheSpace += file.length();
                    continue;
                }
                if (!file.isDirectory()) continue;
                usedCacheSpace += this.directorySize(file);
            }
        }
        return usedCacheSpace;
    }

    public class CleaningTask
    extends CacheManagerTask {
        public CleaningTask(Context pCtx, BoundingBox pBB, int pZoomMin, int pZoomMax) {
            super(pCtx, pBB, pZoomMin, pZoomMax);
            this.showUI = true;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            if (this.mProgressDialog != null) {
                this.mProgressDialog.setTitle((CharSequence)"Cleaning tiles");
                this.mProgressDialog.setMessage((CharSequence)CacheManager.this.zoomMessage(this.mZoomMin, this.mZoomMin, this.mZoomMax));
                int total = CacheManager.this.possibleTilesInArea(this.mBB, this.mZoomMin, this.mZoomMax);
                this.mProgressDialog.setMax(total);
                this.mProgressDialog.show();
            }
        }

        protected void onPostExecute(Integer deleted) {
            Toast.makeText((Context)this.mCtx, (CharSequence)("Cleaning completed, " + deleted + " tiles deleted."), (int)0).show();
            if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
                this.mProgressDialog.dismiss();
            }
            CacheManager.this.mPendingTasks.remove((Object)this);
        }

        protected Integer doInBackground(Object ... params) {
            int errors = this.cleanArea();
            return errors;
        }

        protected int cleanArea() {
            ITileSource tileSource = CacheManager.this.mTileProvider.getTileSource();
            int deleted = 0;
            int tileCounter = 0;
            for (int zoomLevel = this.mZoomMin; zoomLevel <= this.mZoomMax; ++zoomLevel) {
                Point mLowerRight = CacheManager.getMapTileFromCoordinates(this.mBB.getLatSouth(), this.mBB.getLonEast(), zoomLevel);
                Point mUpperLeft = CacheManager.getMapTileFromCoordinates(this.mBB.getLatNorth(), this.mBB.getLonWest(), zoomLevel);
                int mapTileUpperBound = 1 << zoomLevel;
                int ofsy = mUpperLeft.y > 0 ? -1 : 0;
                int ofsx = mUpperLeft.x > 0 ? -1 : 0;
                for (int y = mUpperLeft.y + ofsy; y <= mLowerRight.y + 2 + ofsy; ++y) {
                    for (int x = mUpperLeft.x + ofsx; x <= mLowerRight.x + 2 + ofsx; ++x) {
                        int tileY = MyMath.mod(y, mapTileUpperBound);
                        int tileX = MyMath.mod(x, mapTileUpperBound);
                        MapTile tile = new MapTile(zoomLevel, tileX, tileY);
                        File file = CacheManager.getFileName(tileSource, tile);
                        if (file.exists()) {
                            file.delete();
                            ++deleted;
                        }
                        if (++tileCounter % 1000 != 0) continue;
                        if (this.isCancelled()) {
                            return deleted;
                        }
                        this.publishProgress(new Integer[]{tileCounter, zoomLevel});
                    }
                }
            }
            return deleted;
        }
    }

    public class DownloadingTask
    extends CacheManagerTask {
        public DownloadingTask(Context pCtx, BoundingBox pBB, int pZoomMin, int pZoomMax, CacheManagerCallback callback, boolean showUI) {
            super(pCtx, pBB, pZoomMin, pZoomMax, callback, showUI);
        }

        public DownloadingTask(Context pCtx, ArrayList<GeoPoint> pPoints, int pZoomMin, int pZoomMax, CacheManagerCallback callback, boolean showUI) {
            super(pCtx, pPoints, pZoomMin, pZoomMax, callback, showUI);
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            int total = 0;
            if (this.mBB != null) {
                total = CacheManager.this.possibleTilesInArea(this.mBB, this.mZoomMin, this.mZoomMax);
            } else if (this.mGeoPoints != null) {
                total = CacheManager.this.possibleTilesCovered(this.mGeoPoints, this.mZoomMin, this.mZoomMax);
            }
            if (this.showUI) {
                this.mProgressDialog.setTitle((CharSequence)"Downloading tiles");
                this.mProgressDialog.setMessage((CharSequence)CacheManager.this.zoomMessage(this.mZoomMin, this.mZoomMin, this.mZoomMax));
                this.mProgressDialog.setMax(total);
                this.mProgressDialog.show();
            }
            if (this.callback != null) {
                try {
                    this.callback.setPossibleTilesInArea(total);
                    this.callback.downloadStarted();
                }
                catch (Throwable t) {
                    Log.w((String)"OsmDroid", (String)"Error caught processing cachemanager callback, your implementation is faulty", (Throwable)t);
                }
            }
        }

        protected void onPostExecute(Integer errors) {
            if (this.showUI) {
                if (errors != 0) {
                    Toast.makeText((Context)this.mCtx, (CharSequence)("Loading completed with " + errors + " errors."), (int)0).show();
                }
                if (this.mProgressDialog.isShowing()) {
                    this.mProgressDialog.dismiss();
                }
            }
            if (this.callback != null) {
                try {
                    if (errors == 0) {
                        this.callback.onTaskComplete();
                    } else {
                        this.callback.onTaskFailed(errors);
                    }
                }
                catch (Throwable t) {
                    Log.w((String)"OsmDroid", (String)"Error caught processing cachemanager callback, your implementation is faulty", (Throwable)t);
                }
            }
            CacheManager.this.mPendingTasks.remove((Object)this);
        }

        protected Integer doInBackground(Object ... params) {
            int errors = this.downloadArea();
            return errors;
        }

        protected int downloadArea() {
            if (!(CacheManager.this.mTileProvider.getTileSource() instanceof OnlineTileSourceBase)) {
                Log.e((String)"OsmDroid", (String)"TileSource is not an online tile source");
                return 0;
            }
            OnlineTileSourceBase tileSource = (OnlineTileSourceBase)CacheManager.this.mTileProvider.getTileSource();
            int tileCounter = 0;
            int errors = 0;
            if (this.mBB != null) {
                for (int zoomLevel = this.mZoomMin; zoomLevel <= this.mZoomMax; ++zoomLevel) {
                    Point mLowerRight = CacheManager.getMapTileFromCoordinates(this.mBB.getLatSouth(), this.mBB.getLonEast(), zoomLevel);
                    Point mUpperLeft = CacheManager.getMapTileFromCoordinates(this.mBB.getLatNorth(), this.mBB.getLonWest(), zoomLevel);
                    int mapTileUpperBound = 1 << zoomLevel;
                    for (int y = mUpperLeft.y; y <= mLowerRight.y; ++y) {
                        for (int x = mUpperLeft.x; x <= mLowerRight.x; ++x) {
                            int tileY = MyMath.mod(y, mapTileUpperBound);
                            int tileX = MyMath.mod(x, mapTileUpperBound);
                            MapTile tile = new MapTile(zoomLevel, tileX, tileY);
                            boolean ok = CacheManager.this.loadTile(tileSource, tile);
                            if (!ok) {
                                ++errors;
                            }
                            if (++tileCounter % 10 != 0) continue;
                            if (this.isCancelled()) {
                                return errors;
                            }
                            this.publishProgress(new Integer[]{tileCounter, zoomLevel});
                        }
                    }
                }
            } else if (this.mGeoPoints != null) {
                GeoPoint prevPoint = null;
                Point prevTile = null;
                ArrayList<Point> tilePoints = new ArrayList<Point>();
                for (int zoomLevel = this.mZoomMin; zoomLevel <= this.mZoomMax; ++zoomLevel) {
                    int mapTileUpperBound = 1 << zoomLevel;
                    for (GeoPoint geoPoint : this.mGeoPoints) {
                        boolean ok;
                        MapTile tileToDownload;
                        Point tileAround;
                        int yAround;
                        int xAround;
                        int ofsy;
                        int ofsx;
                        Point tile;
                        double d = TileSystem.GroundResolution(geoPoint.getLatitude(), zoomLevel);
                        if (tileCounter != 0) {
                            if (prevPoint != null) {
                                double leadCoef = (geoPoint.getLatitude() - prevPoint.getLatitude()) / (geoPoint.getLongitude() - prevPoint.getLongitude());
                                double brng = geoPoint.getLongitude() > prevPoint.getLongitude() ? 1.5707963267948966 - Math.atan(leadCoef) : 4.71238898038469 - Math.atan(leadCoef);
                                GeoPoint wayPoint = new GeoPoint(prevPoint.getLatitude(), prevPoint.getLongitude());
                                while ((geoPoint.getLatitude() > prevPoint.getLatitude() && wayPoint.getLatitude() < geoPoint.getLatitude() || geoPoint.getLatitude() < prevPoint.getLatitude() && wayPoint.getLatitude() > geoPoint.getLatitude()) && (geoPoint.getLongitude() > prevPoint.getLongitude() && wayPoint.getLongitude() < geoPoint.getLongitude() || geoPoint.getLongitude() < prevPoint.getLongitude() && wayPoint.getLongitude() > geoPoint.getLongitude())) {
                                    Point lastPoint = new Point();
                                    TileSystem.LatLongToPixelXY(geoPoint.getLatitude(), geoPoint.getLongitude(), zoomLevel, lastPoint);
                                    double prevLatRad = wayPoint.getLatitude() * Math.PI / 180.0;
                                    double prevLonRad = wayPoint.getLongitude() * Math.PI / 180.0;
                                    double latRad = Math.asin(Math.sin(prevLatRad) * Math.cos(d / 6378137.0) + Math.cos(prevLatRad) * Math.sin(d / 6378137.0) * Math.cos(brng));
                                    double lonRad = prevLonRad + Math.atan2(Math.sin(brng) * Math.sin(d / 6378137.0) * Math.cos(prevLatRad), Math.cos(d / 6378137.0) - Math.sin(prevLatRad) * Math.sin(latRad));
                                    wayPoint.setLatitude(latRad * 180.0 / Math.PI);
                                    wayPoint.setLongitude(lonRad * 180.0 / Math.PI);
                                    tile = CacheManager.getMapTileFromCoordinates(wayPoint.getLatitude(), wayPoint.getLongitude(), zoomLevel);
                                    if (tile.equals((Object)prevTile)) continue;
                                    ofsx = tile.x >= 0 ? 0 : -tile.x;
                                    ofsy = tile.y >= 0 ? 0 : -tile.y;
                                    for (xAround = tile.x + ofsx; xAround <= tile.x + 1 + ofsx; ++xAround) {
                                        for (yAround = tile.y + ofsy; yAround <= tile.y + 1 + ofsy; ++yAround) {
                                            tileAround = new Point(xAround, yAround);
                                            boolean foundTilePoint = false;
                                            for (Point inList : tilePoints) {
                                                if (!tileAround.equals(inList.x, inList.y)) continue;
                                                foundTilePoint = true;
                                                break;
                                            }
                                            if (foundTilePoint) continue;
                                            int tileY = MyMath.mod(tileAround.y, mapTileUpperBound);
                                            int tileX = MyMath.mod(tileAround.x, mapTileUpperBound);
                                            tileToDownload = new MapTile(zoomLevel, tileX, tileY);
                                            ok = CacheManager.this.loadTile(tileSource, tileToDownload);
                                            if (!ok) {
                                                ++errors;
                                            }
                                            if (++tileCounter % 10 == 0) {
                                                if (this.isCancelled()) {
                                                    return errors;
                                                }
                                                this.publishProgress(new Integer[]{tileCounter, zoomLevel});
                                            }
                                            tilePoints.add(0, tileAround);
                                        }
                                    }
                                    prevTile = tile;
                                }
                            }
                        } else {
                            prevTile = tile = CacheManager.getMapTileFromCoordinates(geoPoint.getLatitude(), geoPoint.getLongitude(), zoomLevel);
                            ofsx = tile.x >= 0 ? 0 : -tile.x;
                            ofsy = tile.y >= 0 ? 0 : -tile.y;
                            for (xAround = tile.x + ofsx; xAround <= tile.x + 1 + ofsx; ++xAround) {
                                for (yAround = tile.y + ofsy; yAround <= tile.y + 1 + ofsy; ++yAround) {
                                    tileAround = new Point(xAround, yAround);
                                    int tileY = MyMath.mod(tileAround.y, mapTileUpperBound);
                                    int tileX = MyMath.mod(tileAround.x, mapTileUpperBound);
                                    tileToDownload = new MapTile(zoomLevel, tileX, tileY);
                                    ok = CacheManager.this.loadTile(tileSource, tileToDownload);
                                    if (!ok) {
                                        ++errors;
                                    }
                                    if (++tileCounter % 10 == 0) {
                                        if (this.isCancelled()) {
                                            return errors;
                                        }
                                        this.publishProgress(new Integer[]{tileCounter, zoomLevel});
                                    }
                                    tilePoints.add(0, tileAround);
                                }
                            }
                        }
                        prevPoint = geoPoint;
                    }
                }
                Log.d((String)"OsmDroid", (String)("downloaded " + tilePoints.size() + " tiles"));
            }
            return errors;
        }
    }

    public abstract class CacheManagerTask
    extends AsyncTask<Object, Integer, Integer> {
        ProgressDialog mProgressDialog = null;
        boolean showUI = true;
        int mZoomMin;
        int mZoomMax;
        BoundingBox mBB;
        ArrayList<GeoPoint> mGeoPoints;
        Context mCtx;
        CacheManagerCallback callback = null;

        public CacheManagerTask(Context pCtx, BoundingBox pBB, int pZoomMin, int pZoomMax, CacheManagerCallback callback, boolean showUI) {
            this(pCtx, pBB, pZoomMin, pZoomMax);
            this.callback = callback;
            this.showUI = showUI;
        }

        public CacheManagerTask(Context pCtx, ArrayList<GeoPoint> geoPoints, int pZoomMin, int pZoomMax, CacheManagerCallback callback, boolean showUI) {
            this(pCtx, geoPoints, pZoomMin, pZoomMax);
            this.callback = callback;
            this.showUI = showUI;
            this.mGeoPoints = geoPoints;
        }

        public CacheManagerTask(Context pCtx, ArrayList<GeoPoint> pGeoPoints, int pZoomMin, int pZoomMax) {
            this.mCtx = pCtx;
            this.mGeoPoints = pGeoPoints;
            this.mZoomMin = Math.max(pZoomMin, CacheManager.this.mMapView.getMinZoomLevel());
            this.mZoomMax = Math.min(pZoomMax, CacheManager.this.mMapView.getMaxZoomLevel());
        }

        public CacheManagerTask(Context pCtx, BoundingBox pBB, int pZoomMin, int pZoomMax) {
            this.mCtx = pCtx;
            this.mBB = pBB;
            this.mZoomMin = Math.max(pZoomMin, CacheManager.this.mMapView.getMinZoomLevel());
            this.mZoomMax = Math.min(pZoomMax, CacheManager.this.mMapView.getMaxZoomLevel());
        }

        protected void onPreExecute() {
            if (this.showUI) {
                this.mProgressDialog = this.createProgressDialog(this.mCtx);
            }
        }

        protected ProgressDialog createProgressDialog(Context pCtx) {
            ProgressDialog pd = new ProgressDialog(pCtx);
            pd.setProgressStyle(1);
            pd.setCancelable(true);
            pd.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    CacheManagerTask.this.cancel(true);
                }
            });
            return pd;
        }

        protected void onProgressUpdate(Integer ... count) {
            if (this.showUI) {
                this.mProgressDialog.setProgress(count[0].intValue());
                this.mProgressDialog.setMessage((CharSequence)CacheManager.this.zoomMessage(count[1], this.mZoomMin, this.mZoomMax));
            }
            if (this.callback != null) {
                try {
                    this.callback.updateProgress(count[0], count[1], this.mZoomMin, this.mZoomMax);
                }
                catch (Throwable t) {
                    Log.w((String)"OsmDroid", (String)"Error caught processing cachemanager callback, your implementation is faulty", (Throwable)t);
                }
            }
        }

        protected void onCancelled() {
            super.onCancelled();
            CacheManager.this.mPendingTasks.remove((Object)this);
        }
    }

    public static interface CacheManagerCallback {
        public void onTaskComplete();

        public void updateProgress(int var1, int var2, int var3, int var4);

        public void downloadStarted();

        public void setPossibleTilesInArea(int var1);

        public void onTaskFailed(int var1);
    }
}

