/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.os.Build;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.osmdroid.tileprovider.modules.DatabaseFileArchive;
import org.osmdroid.tileprovider.modules.GEMFFileArchive;
import org.osmdroid.tileprovider.modules.IArchiveFile;
import org.osmdroid.tileprovider.modules.MBTilesFileArchive;
import org.osmdroid.tileprovider.modules.ZipFileArchive;

public class ArchiveFileFactory {
    static Map<String, Class<? extends IArchiveFile>> extensionMap = new HashMap<String, Class<? extends IArchiveFile>>();

    public static boolean isFileExtensionRegistered(String extension) {
        return extensionMap.containsKey(extension);
    }

    public static void registerArchiveFileProvider(Class<? extends IArchiveFile> provider, String fileExtension) {
        extensionMap.put(fileExtension, provider);
    }

    public static IArchiveFile getArchiveFile(File pFile) {
        Class<? extends IArchiveFile> aClass;
        String extension = pFile.getName();
        if (extension.contains(".")) {
            try {
                extension = extension.substring(extension.lastIndexOf(".") + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((aClass = extensionMap.get(extension.toLowerCase())) != null) {
            try {
                IArchiveFile provider = aClass.newInstance();
                provider.init(pFile);
                return provider;
            }
            catch (InstantiationException e) {
                Log.e((String)"OsmDroid", (String)("Error initializing archive file provider " + pFile.getAbsolutePath()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.e((String)"OsmDroid", (String)("Error initializing archive file provider " + pFile.getAbsolutePath()), (Throwable)e);
            }
            catch (Exception e) {
                Log.e((String)"OsmDroid", (String)("Error opening archive file " + pFile.getAbsolutePath()), (Throwable)e);
            }
        }
        return null;
    }

    static {
        extensionMap.put("zip", ZipFileArchive.class);
        if (Build.VERSION.SDK_INT >= 10) {
            extensionMap.put("sqlite", DatabaseFileArchive.class);
            extensionMap.put("mbtiles", MBTilesFileArchive.class);
            extensionMap.put("gemf", GEMFFileArchive.class);
        }
    }
}

