/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.mylocation;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import java.util.HashSet;
import java.util.Set;
import org.osmdroid.util.NetworkLocationIgnorer;
import org.osmdroid.views.overlay.mylocation.IMyLocationConsumer;
import org.osmdroid.views.overlay.mylocation.IMyLocationProvider;

public class GpsMyLocationProvider
implements IMyLocationProvider,
LocationListener {
    private LocationManager mLocationManager;
    private Location mLocation;
    private IMyLocationConsumer mMyLocationConsumer;
    private long mLocationUpdateMinTime = 0L;
    private float mLocationUpdateMinDistance = 0.0f;
    private NetworkLocationIgnorer mIgnorer = new NetworkLocationIgnorer();
    private final Set<String> locationSources = new HashSet<String>();

    public GpsMyLocationProvider(Context context) {
        this.mLocationManager = (LocationManager)context.getSystemService("location");
        this.locationSources.add("gps");
    }

    public void clearLocationSources() {
        this.locationSources.clear();
    }

    public void addLocationSource(String source) {
        this.locationSources.add(source);
    }

    public Set<String> getLocationSources() {
        return this.locationSources;
    }

    public long getLocationUpdateMinTime() {
        return this.mLocationUpdateMinTime;
    }

    public void setLocationUpdateMinTime(long milliSeconds) {
        this.mLocationUpdateMinTime = milliSeconds;
    }

    public float getLocationUpdateMinDistance() {
        return this.mLocationUpdateMinDistance;
    }

    public void setLocationUpdateMinDistance(float meters) {
        this.mLocationUpdateMinDistance = meters;
    }

    @Override
    public boolean startLocationProvider(IMyLocationConsumer myLocationConsumer) {
        this.mMyLocationConsumer = myLocationConsumer;
        boolean result = false;
        for (String provider : this.mLocationManager.getProviders(true)) {
            if (!this.locationSources.contains(provider)) continue;
            result = true;
            this.mLocationManager.requestLocationUpdates(provider, this.mLocationUpdateMinTime, this.mLocationUpdateMinDistance, (LocationListener)this);
        }
        return result;
    }

    @Override
    public void stopLocationProvider() {
        this.mMyLocationConsumer = null;
        if (this.mLocationManager != null) {
            this.mLocationManager.removeUpdates((LocationListener)this);
        }
    }

    @Override
    public Location getLastKnownLocation() {
        return this.mLocation;
    }

    @Override
    public void destroy() {
        this.stopLocationProvider();
        this.mLocation = null;
        this.mLocationManager = null;
        this.mMyLocationConsumer = null;
        this.mIgnorer = null;
    }

    public void onLocationChanged(Location location) {
        if (this.mIgnorer == null) {
            Log.w((String)"OsmDroid", (String)"GpsMyLocation proivider, mIgnore is null, unexpected. Location update will be ignored");
            return;
        }
        if (location == null || location.getProvider() == null) {
            return;
        }
        if (this.mIgnorer.shouldIgnore(location.getProvider(), System.currentTimeMillis())) {
            return;
        }
        this.mLocation = location;
        if (this.mMyLocationConsumer != null && this.mLocation != null) {
            this.mMyLocationConsumer.onLocationChanged(this.mLocation, this);
        }
    }

    public void onProviderDisabled(String provider) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }
}

