/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.compass;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager;
import org.osmdroid.library.R;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.IOverlayMenuProvider;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.compass.IOrientationConsumer;
import org.osmdroid.views.overlay.compass.IOrientationProvider;
import org.osmdroid.views.overlay.compass.InternalCompassOrientationProvider;

public class CompassOverlay
extends Overlay
implements IOverlayMenuProvider,
IOrientationConsumer {
    private static final Paint sSmoothPaint = new Paint(2);
    protected final MapView mMapView;
    private final Display mDisplay;
    public IOrientationProvider mOrientationProvider;
    protected Bitmap mCompassFrameBitmap;
    protected Bitmap mCompassRoseBitmap;
    private final Matrix mCompassMatrix = new Matrix();
    private boolean mIsCompassEnabled;
    private float mAzimuth = Float.NaN;
    private float mCompassCenterX = 35.0f;
    private float mCompassCenterY = 35.0f;
    private final float mCompassRadius = 20.0f;
    protected final float mCompassFrameCenterX;
    protected final float mCompassFrameCenterY;
    protected final float mCompassRoseCenterX;
    protected final float mCompassRoseCenterY;
    public static final int MENU_COMPASS = CompassOverlay.getSafeMenuId();
    private boolean mOptionsMenuEnabled = true;

    public CompassOverlay(Context context, MapView mapView) {
        this(context, new InternalCompassOrientationProvider(context), mapView);
    }

    public CompassOverlay(Context context, IOrientationProvider orientationProvider, MapView mapView) {
        super(context);
        this.mMapView = mapView;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.mDisplay = windowManager.getDefaultDisplay();
        this.createCompassFramePicture();
        this.createCompassRosePicture();
        this.mCompassFrameCenterX = (float)(this.mCompassFrameBitmap.getWidth() / 2) - 0.5f;
        this.mCompassFrameCenterY = (float)(this.mCompassFrameBitmap.getHeight() / 2) - 0.5f;
        this.mCompassRoseCenterX = (float)(this.mCompassRoseBitmap.getWidth() / 2) - 0.5f;
        this.mCompassRoseCenterY = (float)(this.mCompassRoseBitmap.getHeight() / 2) - 0.5f;
        this.setOrientationProvider(orientationProvider);
    }

    @Override
    public void onDetach(MapView mapView) {
        this.disableCompass();
        super.onDetach(mapView);
    }

    private void invalidateCompass() {
        Rect screenRect = this.mMapView.getProjection().getScreenRect();
        int frameLeft = screenRect.left + (int)Math.ceil((this.mCompassCenterX - this.mCompassFrameCenterX) * this.mScale);
        int frameTop = screenRect.top + (int)Math.ceil((this.mCompassCenterY - this.mCompassFrameCenterY) * this.mScale);
        int frameRight = screenRect.left + (int)Math.ceil((this.mCompassCenterX + this.mCompassFrameCenterX) * this.mScale);
        int frameBottom = screenRect.top + (int)Math.ceil((this.mCompassCenterY + this.mCompassFrameCenterY) * this.mScale);
        this.mMapView.postInvalidateMapCoordinates(frameLeft - 2, frameTop - 2, frameRight + 2, frameBottom + 2);
    }

    public void setCompassCenter(float x, float y) {
        this.mCompassCenterX = x;
        this.mCompassCenterY = y;
    }

    public IOrientationProvider getOrientationProvider() {
        return this.mOrientationProvider;
    }

    protected void setOrientationProvider(IOrientationProvider orientationProvider) {
        if (orientationProvider == null) {
            throw new RuntimeException("You must pass an IOrientationProvider to setOrientationProvider()");
        }
        if (this.isCompassEnabled()) {
            this.mOrientationProvider.stopOrientationProvider();
        }
        this.mOrientationProvider = orientationProvider;
    }

    protected void drawCompass(Canvas canvas, float bearing, Rect screenRect) {
        Projection proj = this.mMapView.getProjection();
        float centerX = this.mCompassCenterX * this.mScale;
        float centerY = this.mCompassCenterY * this.mScale;
        this.mCompassMatrix.setTranslate(-this.mCompassFrameCenterX, -this.mCompassFrameCenterY);
        this.mCompassMatrix.postTranslate(centerX, centerY);
        canvas.save();
        canvas.concat(proj.getInvertedScaleRotateCanvasMatrix());
        canvas.concat(this.mCompassMatrix);
        canvas.drawBitmap(this.mCompassFrameBitmap, 0.0f, 0.0f, sSmoothPaint);
        canvas.restore();
        this.mCompassMatrix.setRotate(-bearing, this.mCompassRoseCenterX, this.mCompassRoseCenterY);
        this.mCompassMatrix.postTranslate(-this.mCompassRoseCenterX, -this.mCompassRoseCenterY);
        this.mCompassMatrix.postTranslate(centerX, centerY);
        canvas.save();
        canvas.concat(proj.getInvertedScaleRotateCanvasMatrix());
        canvas.concat(this.mCompassMatrix);
        canvas.drawBitmap(this.mCompassRoseBitmap, 0.0f, 0.0f, sSmoothPaint);
        canvas.restore();
    }

    @Override
    protected void draw(Canvas c, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        if (this.isCompassEnabled() && !Float.isNaN(this.mAzimuth)) {
            this.drawCompass(c, this.mAzimuth + (float)this.getDisplayOrientation(), mapView.getProjection().getScreenRect());
        }
    }

    @Override
    public void setOptionsMenuEnabled(boolean pOptionsMenuEnabled) {
        this.mOptionsMenuEnabled = pOptionsMenuEnabled;
    }

    @Override
    public boolean isOptionsMenuEnabled() {
        return this.mOptionsMenuEnabled;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.add(0, MENU_COMPASS + pMenuIdOffset, 0, (CharSequence)pMapView.getContext().getResources().getString(R.string.compass)).setIcon(pMapView.getContext().getResources().getDrawable(R.drawable.ic_menu_compass)).setCheckable(true);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu pMenu, int pMenuIdOffset, MapView pMapView) {
        pMenu.findItem(MENU_COMPASS + pMenuIdOffset).setChecked(this.isCompassEnabled());
        return false;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem pItem, int pMenuIdOffset, MapView pMapView) {
        int menuId = pItem.getItemId() - pMenuIdOffset;
        if (menuId == MENU_COMPASS) {
            if (this.isCompassEnabled()) {
                this.disableCompass();
            } else {
                this.enableCompass();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onOrientationChanged(float orientation, IOrientationProvider source) {
        this.mAzimuth = orientation;
        this.invalidateCompass();
    }

    public boolean enableCompass(IOrientationProvider orientationProvider) {
        boolean success;
        this.setOrientationProvider(orientationProvider);
        this.mIsCompassEnabled = success = this.mOrientationProvider.startOrientationProvider(this);
        if (this.mMapView != null) {
            this.invalidateCompass();
        }
        return success;
    }

    public boolean enableCompass() {
        return this.enableCompass(this.mOrientationProvider);
    }

    public void disableCompass() {
        this.mIsCompassEnabled = false;
        if (this.mOrientationProvider != null) {
            this.mOrientationProvider.stopOrientationProvider();
        }
        this.mAzimuth = Float.NaN;
        if (this.mMapView != null) {
            this.invalidateCompass();
        }
    }

    public boolean isCompassEnabled() {
        return this.mIsCompassEnabled;
    }

    public float getOrientation() {
        return this.mAzimuth;
    }

    private Point calculatePointOnCircle(float centerX, float centerY, float radius, float degrees) {
        double dblRadians = Math.toRadians(-degrees + 90.0f);
        int intX = (int)((double)radius * Math.cos(dblRadians));
        int intY = (int)((double)radius * Math.sin(dblRadians));
        return new Point((int)centerX + intX, (int)centerY - intY);
    }

    private void drawTriangle(Canvas canvas, float x, float y, float radius, float degrees, Paint paint) {
        canvas.save();
        Point point = this.calculatePointOnCircle(x, y, radius, degrees);
        canvas.rotate(degrees, (float)point.x, (float)point.y);
        Path p = new Path();
        p.moveTo((float)point.x - 2.0f * this.mScale, (float)point.y);
        p.lineTo((float)point.x + 2.0f * this.mScale, (float)point.y);
        p.lineTo((float)point.x, (float)point.y - 5.0f * this.mScale);
        p.close();
        canvas.drawPath(p, paint);
        canvas.restore();
    }

    private int getDisplayOrientation() {
        switch (this.mDisplay.getOrientation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    private void createCompassFramePicture() {
        Paint innerPaint = new Paint();
        innerPaint.setColor(-1);
        innerPaint.setAntiAlias(true);
        innerPaint.setStyle(Paint.Style.FILL);
        innerPaint.setAlpha(200);
        Paint outerPaint = new Paint();
        outerPaint.setColor(-7829368);
        outerPaint.setAntiAlias(true);
        outerPaint.setStyle(Paint.Style.STROKE);
        outerPaint.setStrokeWidth(2.0f);
        outerPaint.setAlpha(200);
        int picBorderWidthAndHeight = (int)(50.0f * this.mScale);
        int center = picBorderWidthAndHeight / 2;
        this.mCompassFrameBitmap = Bitmap.createBitmap((int)picBorderWidthAndHeight, (int)picBorderWidthAndHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.mCompassFrameBitmap);
        canvas.drawCircle((float)center, (float)center, 20.0f * this.mScale, innerPaint);
        canvas.drawCircle((float)center, (float)center, 20.0f * this.mScale, outerPaint);
        this.drawTriangle(canvas, center, center, 20.0f * this.mScale, 0.0f, outerPaint);
        this.drawTriangle(canvas, center, center, 20.0f * this.mScale, 90.0f, outerPaint);
        this.drawTriangle(canvas, center, center, 20.0f * this.mScale, 180.0f, outerPaint);
        this.drawTriangle(canvas, center, center, 20.0f * this.mScale, 270.0f, outerPaint);
    }

    private void createCompassRosePicture() {
        Paint northPaint = new Paint();
        northPaint.setColor(-6291456);
        northPaint.setAntiAlias(true);
        northPaint.setStyle(Paint.Style.FILL);
        northPaint.setAlpha(220);
        Paint southPaint = new Paint();
        southPaint.setColor(-16777216);
        southPaint.setAntiAlias(true);
        southPaint.setStyle(Paint.Style.FILL);
        southPaint.setAlpha(220);
        Paint centerPaint = new Paint();
        centerPaint.setColor(-1);
        centerPaint.setAntiAlias(true);
        centerPaint.setStyle(Paint.Style.FILL);
        centerPaint.setAlpha(220);
        int picBorderWidthAndHeight = (int)(50.0f * this.mScale);
        int center = picBorderWidthAndHeight / 2;
        this.mCompassRoseBitmap = Bitmap.createBitmap((int)picBorderWidthAndHeight, (int)picBorderWidthAndHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.mCompassRoseBitmap);
        Path pathNorth = new Path();
        pathNorth.moveTo((float)center, (float)center - 17.0f * this.mScale);
        pathNorth.lineTo((float)center + 4.0f * this.mScale, (float)center);
        pathNorth.lineTo((float)center - 4.0f * this.mScale, (float)center);
        pathNorth.lineTo((float)center, (float)center - 17.0f * this.mScale);
        pathNorth.close();
        canvas.drawPath(pathNorth, northPaint);
        Path pathSouth = new Path();
        pathSouth.moveTo((float)center, (float)center + 17.0f * this.mScale);
        pathSouth.lineTo((float)center + 4.0f * this.mScale, (float)center);
        pathSouth.lineTo((float)center - 4.0f * this.mScale, (float)center);
        pathSouth.lineTo((float)center, (float)center + 17.0f * this.mScale);
        pathSouth.close();
        canvas.drawPath(pathSouth, southPaint);
        canvas.drawCircle((float)center, (float)center, 2.0f, centerPaint);
    }
}

